/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.pattern.placement;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.block.IMultiStateBlock;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.pattern.placement.IPatternPlacementType;
import mod.chiselsandbits.api.pattern.placement.PlacementResult;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.ColorUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.registrars.ModPatternPlacementTypes;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class RemovalPatternPlacementType
extends ForgeRegistryEntry<IPatternPlacementType>
implements IPatternPlacementType {
    @Override
    public VoxelShape buildVoxelShapeForWireframe(IMultiStateSnapshot sourceSnapshot, PlayerEntity player, Vector3d targetedPoint, Direction hitFace) {
        BlockPos targetedPosition = hitFace.func_176743_c() == Direction.AxisDirection.NEGATIVE ? new BlockPos(targetedPoint) : new BlockPos(targetedPoint).func_177971_a(hitFace.func_176734_d().func_176730_m());
        VoxelShape targetingShape = BlockPosStreamProvider.getForRange(player.func_213453_ef() ? targetedPoint : Vector3d.func_237491_b_((Vector3i)targetedPosition), player.func_213453_ef() ? targetedPoint.func_72441_c(0.9999, 0.9999, 0.9999) : Vector3d.func_237491_b_((Vector3i)targetedPosition)).map(position -> player.field_70170_p.func_180495_p(position).func_196954_c((IBlockReader)player.field_70170_p, position).func_197751_a((double)(position.func_177958_n() - targetedPosition.func_177958_n()), (double)(position.func_177956_o() - targetedPosition.func_177956_o()), (double)(position.func_177952_p() - targetedPosition.func_177952_p()))).reduce(VoxelShapes.func_197880_a(), (voxelShape, voxelShape2) -> VoxelShapes.func_197882_b((VoxelShape)voxelShape, (VoxelShape)voxelShape2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).func_197753_c();
        Vector3d offSet = player.func_213453_ef() ? new Vector3d(targetedPoint.func_82615_a() - (double)targetedPosition.func_177958_n(), targetedPoint.func_82617_b() - (double)targetedPosition.func_177956_o(), targetedPoint.func_82616_c() - (double)targetedPosition.func_177952_p()) : Vector3d.field_186680_a;
        VoxelShape ownShape = ((IPatternPlacementType)ModPatternPlacementTypes.PLACEMENT.get()).buildVoxelShapeForWireframe(sourceSnapshot, player, targetedPoint, hitFace).func_197751_a(offSet.func_82615_a(), offSet.func_82617_b(), offSet.func_82616_c());
        return VoxelShapes.func_197878_a((VoxelShape)targetingShape, (VoxelShape)ownShape, (IBooleanFunction)IBooleanFunction.field_223234_e_);
    }

    @Override
    public PlacementResult performPlacement(IMultiStateSnapshot source, BlockItemUseContext context, boolean simulate) {
        boolean hasRequiredSpace;
        Vector3d targetedPosition = context.func_195999_j().func_213453_ef() ? context.func_221532_j() : Vector3d.func_237491_b_((Vector3i)context.func_195995_a().func_177971_a(context.func_196000_l().func_176734_d().func_176730_m()));
        IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().covering((IWorld)context.func_195991_k(), targetedPosition, targetedPosition.func_72441_c(0.9999, 0.9999, 0.9999));
        boolean isChiseledBlock = BlockPosStreamProvider.getForRange(areaMutator.getInWorldStartPoint(), areaMutator.getInWorldEndPoint()).map(pos -> context.func_195991_k().func_180495_p(pos)).allMatch(state -> state.func_177230_c() instanceof IMultiStateBlock);
        if (isChiseledBlock) {
            return PlacementResult.failure(ColorUtils.NOT_FITTING_PATTERN_PLACEMENT_COLOR, (ITextComponent)LocalStrings.PatternPlacementNotASolidBlock.getText());
        }
        boolean isSupported = BlockPosStreamProvider.getForRange(areaMutator.getInWorldStartPoint(), areaMutator.getInWorldEndPoint()).map(pos -> context.func_195991_k().func_180495_p(pos)).allMatch(IEligibilityManager.getInstance()::canBeChiseled);
        if (!isSupported) {
            return PlacementResult.failure(ColorUtils.NOT_FITTING_PATTERN_PLACEMENT_COLOR, (ITextComponent)LocalStrings.PatternPlacementNotASupportedBlock.getText());
        }
        Map<BlockState, Integer> totalRemovedBits = source.stream().filter(s -> !s.getState().func_196958_f()).filter(s -> {
            Optional<IStateEntryInfo> o = areaMutator.getInAreaTarget(s.getStartPoint());
            return o.filter(os -> !os.getState().func_196958_f()).map(os -> !os.getState().equals(s.getState())).orElse(false);
        }).map(s -> areaMutator.getInAreaTarget(s.getStartPoint())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(IStateEntryInfo::getState, s -> 1, Integer::sum));
        IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(context.func_195999_j());
        boolean bl = hasRequiredSpace = context.func_195999_j().func_184812_l_() || totalRemovedBits.entrySet().stream().allMatch(e -> playerBitInventory.canInsert((BlockState)e.getKey(), (Integer)e.getValue()));
        if (!hasRequiredSpace) {
            return PlacementResult.failure(ColorUtils.MISSING_BITS_OR_SPACE_PATTERN_PLACEMENT_COLOR, (ITextComponent)LocalStrings.PatternPlacementNoBitSpace.getText());
        }
        if (simulate) {
            return PlacementResult.success();
        }
        try (IBatchMutation ignored = areaMutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(context.func_195999_j()));){
            source.stream().filter(s -> !s.getState().func_196958_f()).forEach(stateEntryInfo -> areaMutator.clearInAreaTarget(stateEntryInfo.getStartPoint()));
        }
        if (!context.func_195999_j().func_184812_l_()) {
            totalRemovedBits.forEach(playerBitInventory::insertOrDiscard);
        }
        return PlacementResult.success();
    }

    @Override
    public Vector3d getTargetedPosition(ItemStack heldStack, PlayerEntity playerEntity, BlockRayTraceResult blockRayTraceResult) {
        return Vector3d.func_237491_b_((Vector3i)blockRayTraceResult.func_216350_a());
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return new ResourceLocation("chiselsandbits", "textures/icons/pattern_remove.png");
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.empty();
    }

    @Override
    public ITextComponent getDisplayName() {
        return LocalStrings.PatternPlacementModeRemoval.getText();
    }
}

