/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.entity;

import com.google.common.collect.ImmutableList;
import dev.itsmeow.betteranimalsplus.imdlib.entity.AbstractEntityBuilder;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeDefinition;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.ISelectiveVariantTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.builder.IEntityTypeDefinition;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.EntityVariantList;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.imdlib.item.ModSpawnEggItem;
import dev.itsmeow.betteranimalsplus.imdlib.util.HeadType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.fluid.Fluids;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;

public class EntityTypeContainer<T extends MobEntity> {
    protected final IEntityTypeDefinition<T> definition;
    protected EntityVariantList variantList;
    protected DataParameter<String> variantDataKey;
    protected boolean despawn;
    protected boolean placementRegistered = false;
    protected Supplier<Set<RegistryKey<Biome>>> spawnBiomesSupplier;
    protected Set<RegistryKey<Biome>> spawnBiomesCache = null;
    protected Supplier<Set<RegistryKey<Biome>>> spawnCostBiomesSupplier;
    protected Set<RegistryKey<Biome>> spawnCostBiomesCache = null;
    protected EntityConfiguration config;
    protected HeadType headType;
    protected ModSpawnEggItem egg;
    protected EntityType<T> entityType;
    protected final CustomConfigurationHolder<T> customConfigHolder = new CustomConfigurationHolder(this);
    protected final CustomConfigurationHolder<T> customConfigHolderClient = new CustomConfigurationHolder(this);
    protected final NonNullLazy<MobSpawnInfo.Spawners> spawnEntry = NonNullLazy.of(() -> new MobSpawnInfo.Spawners(this.entityType, ((Integer)this.config.spawnWeight.get()).intValue(), ((Integer)this.config.spawnMinGroup.get()).intValue(), ((Integer)this.config.spawnMaxGroup.get()).intValue()));

    protected EntityTypeContainer(IEntityTypeDefinition<T> def) {
        this.definition = def;
        if (this.hasVariants()) {
            this.variantList = new EntityVariantList(def.getVariantAmount());
            this.variantList.add(def.getVariants());
        }
        this.spawnBiomesSupplier = def.getDefaultSpawnBiomes() != null ? def.getDefaultSpawnBiomes() : HashSet::new;
        this.spawnCostBiomesSupplier = this.spawnBiomesSupplier;
    }

    public IEntityTypeDefinition<T> getDefinition() {
        return this.definition;
    }

    public EntityType<T> getEntityType() {
        return this.entityType;
    }

    public EntityConfiguration getConfiguration() {
        return this.config;
    }

    public String getModId() {
        return this.definition.getModId();
    }

    public boolean hasEgg() {
        return this.definition.hasEgg();
    }

    public boolean hasSpawns() {
        return this.definition.hasSpawns();
    }

    public float getWidth() {
        return this.definition.getWidth();
    }

    public float getHeight() {
        return this.definition.getHeight();
    }

    public Class<T> getEntityClass() {
        return this.definition.getEntityClass();
    }

    public String getEntityName() {
        return this.definition.getEntityName();
    }

    public Supplier<AttributeModifierMap.MutableAttribute> getAttributeBuilder() {
        return this.definition.getAttributeMap();
    }

    public HeadType getHeadType() {
        return this.headType;
    }

    public CustomConfigurationHolder<T> getCustomConfiguration() {
        return this.customConfigHolder;
    }

    public CustomConfigurationHolder<T> getCustomConfigurationClient() {
        return this.customConfigHolderClient;
    }

    public boolean hasVariants() {
        return this.definition.getVariantAmount() > 0;
    }

    public int getVariantMax() {
        return this.definition.getVariantAmount();
    }

    public MobSpawnInfo.Spawners getSpawnEntry() {
        return (MobSpawnInfo.Spawners)this.spawnEntry.get();
    }

    public boolean despawns() {
        return this.despawn;
    }

    public ModSpawnEggItem getEggItem() {
        return this.egg;
    }

    void setHeadType(HeadType headType) {
        this.headType = headType;
    }

    protected void onCreateEntityType() {
        if (this.hasEgg()) {
            this.egg = new ModSpawnEggItem(this);
        }
    }

    void registerPlacement() {
        if (this.definition.getPlacementType() != null && this.definition.getPlacementPredicate() != null && this.definition.getPlacementHeightMapType() != null && !this.placementRegistered) {
            EntitySpawnPlacementRegistry.func_209343_a(this.entityType, (EntitySpawnPlacementRegistry.PlacementType)this.definition.getPlacementType(), (Heightmap.Type)this.definition.getPlacementHeightMapType(), this.definition.getPlacementPredicate());
            this.placementRegistered = true;
        }
    }

    boolean registerAttributes() {
        return this.definition.getAttributeMap() != null && GlobalEntityTypeAttributes.put(this.entityType, (AttributeModifierMap)this.definition.getAttributeMap().get().func_233813_a_()) != null;
    }

    protected void createConfiguration(ForgeConfigSpec.Builder builder) {
        this.config = new EntityConfiguration(builder);
    }

    protected void customConfigurationLoad() {
        if (this.definition.getCustomConfigLoad() != null) {
            this.definition.getCustomConfigLoad().load(this.customConfigHolder);
        }
    }

    protected void clientCustomConfigurationLoad() {
        if (this.definition.getCustomClientConfigLoad() != null) {
            this.definition.getCustomClientConfigLoad().load(this.customConfigHolderClient);
        }
    }

    protected void customConfigurationInit(ForgeConfigSpec.Builder builder) {
        if (this.definition.getCustomConfigInit() != null) {
            this.definition.getCustomConfigInit().init(this.customConfigHolder, builder);
        }
    }

    protected void clientCustomConfigurationInit(ForgeConfigSpec.Builder builder) {
        if (this.definition.getCustomClientConfigInit() != null) {
            builder.push(this.getEntityName());
            this.definition.getCustomClientConfigInit().init(this.customConfigHolderClient, builder);
            builder.pop();
        }
    }

    public List<String> getBiomeIDs() {
        return EntityTypeContainer.setBiomesToIDs(this.getSpawnBiomes());
    }

    public List<String> getSpawnCostBiomeIDs() {
        return EntityTypeContainer.setBiomesToIDs(this.getSpawnCostBiomes());
    }

    public Set<RegistryKey<Biome>> getSpawnBiomes() {
        if (this.spawnBiomesCache == null) {
            this.spawnBiomesCache = this.spawnBiomesSupplier.get();
        }
        return this.spawnBiomesCache;
    }

    public Set<RegistryKey<Biome>> getSpawnCostBiomes() {
        if (this.spawnCostBiomesCache == null) {
            this.spawnCostBiomesCache = this.spawnCostBiomesSupplier.get();
        }
        return this.spawnCostBiomesCache;
    }

    protected void setSpawnBiomesSupplier(Supplier<Set<RegistryKey<Biome>>> biomesSupplier) {
        this.spawnBiomesCache = null;
        this.spawnBiomesSupplier = biomesSupplier;
    }

    protected void setSpawnCostBiomesSupplier(Supplier<Set<RegistryKey<Biome>>> biomesSupplier) {
        this.spawnCostBiomesCache = null;
        this.spawnCostBiomesSupplier = biomesSupplier;
    }

    public static <T extends MobEntity> boolean waterSpawn(EntityType<T> type, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return pos.func_177956_o() > 45 && pos.func_177956_o() < world.func_181545_F() - 1 && world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a;
    }

    protected static List<String> setBiomesToIDs(Set<RegistryKey<Biome>> set) {
        return set.parallelStream().filter(Objects::nonNull).map(b -> b.func_240901_a_().toString()).collect(Collectors.toList());
    }

    @Nullable
    @CheckForNull
    public IVariant getVariantForName(String name) {
        return this.variantList.getVariantForName(name);
    }

    @Deprecated
    public IVariant getVariantForIndex(int index) {
        return this.variantList.getVariantForIndex(index);
    }

    public ImmutableList<IVariant> getVariants() {
        return this.variantList.getVariantList();
    }

    @Deprecated
    public int getVariantIndex(IVariant variant) {
        return this.variantList.getVariantIndex(variant);
    }

    public DataParameter<String> getVariantDataKey() {
        if (this.variantDataKey == null) {
            this.variantDataKey = EntityDataManager.func_187226_a(this.getEntityClass(), (IDataSerializer)DataSerializers.field_187194_d);
        }
        return this.variantDataKey;
    }

    @FunctionalInterface
    public static interface CustomConfigurationInit {
        public void init(CustomConfigurationHolder<?> var1, ForgeConfigSpec.Builder var2);
    }

    @FunctionalInterface
    public static interface CustomConfigurationLoad {
        public void load(CustomConfigurationHolder<?> var1);
    }

    public static class CustomConfigurationHolder<T extends MobEntity> {
        protected Map<String, ForgeConfigSpec.ConfigValue<?>> values = new HashMap();
        protected EntityTypeContainer<T> container;

        CustomConfigurationHolder(EntityTypeContainer<T> container) {
            this.container = container;
        }

        public int getInt(String path) {
            return (Integer)this.getIntHolder(path).get();
        }

        public String getString(String path) {
            return (String)this.getStringHolder(path).get();
        }

        public double getDouble(String path) {
            return (Double)this.getDoubleHolder(path).get();
        }

        public long getLong(String path) {
            return (Long)this.getLongHolder(path).get();
        }

        public boolean getBoolean(String path) {
            return (Boolean)this.getBooleanHolder(path).get();
        }

        public <V> ForgeConfigSpec.ConfigValue<V> getAnyHolder(String path) {
            return this.values.get(path);
        }

        public ForgeConfigSpec.ConfigValue<List<String>> getStringListHolder(String path) {
            ForgeConfigSpec.ConfigValue<?> v = this.values.get(path);
            return v.get() instanceof List ? v : null;
        }

        public ForgeConfigSpec.IntValue getIntHolder(String path) {
            ForgeConfigSpec.ConfigValue<?> v = this.values.get(path);
            return v instanceof ForgeConfigSpec.IntValue ? (ForgeConfigSpec.IntValue)v : null;
        }

        public ForgeConfigSpec.ConfigValue<String> getStringHolder(String path) {
            ForgeConfigSpec.ConfigValue<?> v = this.values.get(path);
            return v.get() instanceof String ? v : null;
        }

        public ForgeConfigSpec.DoubleValue getDoubleHolder(String path) {
            ForgeConfigSpec.ConfigValue<?> v = this.values.get(path);
            return v instanceof ForgeConfigSpec.DoubleValue ? (ForgeConfigSpec.DoubleValue)v : null;
        }

        public ForgeConfigSpec.LongValue getLongHolder(String path) {
            ForgeConfigSpec.ConfigValue<?> v = this.values.get(path);
            return v instanceof ForgeConfigSpec.LongValue ? (ForgeConfigSpec.LongValue)v : null;
        }

        public ForgeConfigSpec.BooleanValue getBooleanHolder(String path) {
            ForgeConfigSpec.ConfigValue<?> v = this.values.get(path);
            return v instanceof ForgeConfigSpec.BooleanValue ? (ForgeConfigSpec.BooleanValue)v : null;
        }

        public void put(ForgeConfigSpec.ConfigValue<?> value) {
            String path = String.join((CharSequence)"/", value.getPath().toArray(new String[0]));
            path = path.substring(("entities/" + this.container.getEntityName() + "/").length());
            this.values.put(path, value);
        }
    }

    public class EntityConfiguration {
        public ForgeConfigSpec.BooleanValue doSpawning;
        public ForgeConfigSpec.BooleanValue biomeVariants;
        public ForgeConfigSpec.IntValue spawnMinGroup;
        public ForgeConfigSpec.IntValue spawnMaxGroup;
        public ForgeConfigSpec.IntValue spawnWeight;
        public ForgeConfigSpec.BooleanValue useSpawnCosts;
        public ForgeConfigSpec.DoubleValue spawnCostPer;
        public ForgeConfigSpec.DoubleValue spawnMaxCost;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> biomesList;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> spawnCostBiomes;
        public ForgeConfigSpec.BooleanValue doDespawn;

        protected EntityConfiguration(ForgeConfigSpec.Builder builder) {
            EntityTypeContainer container = EntityTypeContainer.this;
            builder.push(container.getEntityName());
            if (EntityTypeContainer.this.definition.getSpawnClassification() == EntityClassification.CREATURE) {
                this.doDespawn = builder.comment("Allows the entity to despawn freely when no players are nearby, like vanilla monsters do").worldRestart().define("can_despawn", EntityTypeContainer.this.definition.despawns());
            }
            if (EntityTypeContainer.this.hasSpawns()) {
                builder.push("spawning");
                this.doSpawning = builder.comment("Enables natural spawning - More info on these options: https://minecraft.fandom.com/wiki/Spawn#Java_Edition").worldRestart().define("spawn_naturally", true);
                this.spawnWeight = builder.comment("The spawn weight compared to other entities (typically between 6-20)").worldRestart().defineInRange("spawn_weight", EntityTypeContainer.this.definition.getSpawnWeight(), 1, 9999);
                this.spawnMinGroup = builder.comment("Minimum amount of entities in spawned groups").worldRestart().defineInRange("minimum_group_size", EntityTypeContainer.this.definition.getSpawnMinGroup(), 1, 9999);
                this.spawnMaxGroup = builder.comment("Maximum amount of entities in spawned groups - Must be greater or equal to min value").worldRestart().defineInRange("maximum_group_size", EntityTypeContainer.this.definition.getSpawnMaxGroup(), 1, 9999);
                this.biomesList = builder.comment("Enter biome IDs. Supports modded biomes https://minecraft.fandom.com/wiki/Biome#Biome_IDs").worldRestart().defineList("spawn_biomes", container.getBiomeIDs(), input -> input instanceof String);
                if (ISelectiveVariantTypes.class.isAssignableFrom(EntityTypeContainer.this.getEntityClass())) {
                    this.biomeVariants = builder.comment("Enables biome based variant selection. This will make this entity choose variants tailored to the biome they spawn in (Only applies to natural spawns)").worldRestart().define("biome_based_variants", true);
                }
                builder.push("spawn_costs");
                this.useSpawnCosts = builder.comment("Whether to use spawn costs in spawning or not").worldRestart().define("use_spawn_costs", EntityTypeContainer.this.definition.useSpawnCosts());
                this.spawnCostPer = builder.comment("Cost to spawning algorithm per entity spawned").worldRestart().defineInRange("cost_per_spawn", EntityTypeContainer.this.definition.getSpawnCostPer(), Double.MIN_VALUE, Double.MAX_VALUE);
                this.spawnMaxCost = builder.comment("Maximum cost the spawning algorithm can accrue for this entity").worldRestart().defineInRange("maximum_cost_per_biome", EntityTypeContainer.this.definition.getSpawnMaxCost(), Double.MIN_VALUE, Double.MAX_VALUE);
                this.spawnCostBiomes = builder.comment("Enter biome IDs to use these costs in. Supports modded biomes. An empty list will use spawn_biomes https://minecraft.fandom.com/wiki/Biome#Biome_IDs").worldRestart().defineList("spawn_cost_biomes", new ArrayList(), input -> input instanceof String);
                builder.pop();
                builder.pop();
            }
            EntityTypeContainer.this.customConfigurationInit(builder);
            builder.pop();
        }

        protected void load() {
            if (EntityTypeContainer.this.hasSpawns()) {
                EntityTypeContainer.this.despawn = EntityTypeContainer.this.definition.getSpawnClassification() == EntityClassification.CREATURE ? ((Boolean)this.doDespawn.get()).booleanValue() : EntityTypeContainer.this.definition.despawns();
                Function<ForgeConfigSpec.ConfigValue, Set> biomesLoader = configList -> {
                    HashSet<RegistryKey> biomeKeys = new HashSet<RegistryKey>();
                    for (String biomeName : (List)configList.get()) {
                        try {
                            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeName));
                            if (biome == null || biome.getRegistryName() == null) {
                                LogManager.getLogger().error("Invalid biome \"" + biomeName + "\" for entity " + EntityTypeContainer.this.getEntityName() + ". No biome exists with that name. Skipping.");
                                continue;
                            }
                            biomeKeys.add(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName()));
                        }
                        catch (Exception e) {
                            LogManager.getLogger().error("Invalid biome name: \"" + biomeName + "\" for entity " + EntityTypeContainer.this.getEntityName() + ". Is it formatted correctly? Skipping.");
                        }
                    }
                    return biomeKeys;
                };
                EntityTypeContainer.this.setSpawnBiomesSupplier(() -> (Set)biomesLoader.apply(this.biomesList));
                if (((Boolean)this.useSpawnCosts.get()).booleanValue()) {
                    EntityTypeContainer.this.setSpawnCostBiomesSupplier(((List)this.spawnCostBiomes.get()).size() == 0 ? EntityTypeContainer.this.spawnBiomesSupplier : () -> (Set)biomesLoader.apply(this.spawnCostBiomes));
                }
            }
            EntityTypeContainer.this.customConfigurationLoad();
        }
    }

    public static class Builder<T extends MobEntity>
    extends AbstractEntityBuilder<T, EntityTypeContainer<T>, Builder<T>> {
        private Builder(Class<T> EntityClass, EntityType.IFactory<T> factory, String entityNameIn, Supplier<AttributeModifierMap.MutableAttribute> attributeMap, String modid) {
            super(EntityClass, factory, entityNameIn, attributeMap, modid);
        }

        @Override
        public EntityTypeContainer<T> rawBuild() {
            return new EntityTypeContainer(new EntityTypeDefinition(this));
        }

        @Override
        public Builder<T> getImplementation() {
            return this;
        }

        public static <T extends MobEntity> Builder<T> create(Class<T> EntityClass, EntityType.IFactory<T> factory, String entityNameIn, Supplier<AttributeModifierMap.MutableAttribute> attributeMap, String modid) {
            return new Builder<T>(EntityClass, factory, entityNameIn, attributeMap, modid);
        }
    }
}

