/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeListBuilder {
    private final Set<RegistryKey<Biome>> extras = new HashSet<RegistryKey<Biome>>();
    private final Set<BiomeDictionary.Type> list = new HashSet<BiomeDictionary.Type>();
    private final Set<BiomeDictionary.Type> blacklist = new HashSet<BiomeDictionary.Type>();
    private final Set<RegistryKey<Biome>> blacklistBiome = new HashSet<RegistryKey<Biome>>();
    private final Set<BiomeDictionary.Type> required = new HashSet<BiomeDictionary.Type>();
    private boolean onlyOverworld = false;

    private BiomeListBuilder() {
    }

    public static BiomeListBuilder create() {
        return new BiomeListBuilder();
    }

    public BiomeListBuilder extra(RegistryKey<Biome> ... extraBiomes) {
        this.extras.addAll(Arrays.asList(extraBiomes));
        return this;
    }

    public BiomeListBuilder extra(BiomeDictionary.Type ... types) {
        this.list.addAll(Arrays.asList(types));
        return this;
    }

    public BiomeListBuilder withoutTypes(BiomeDictionary.Type ... types) {
        this.blacklist.addAll(Arrays.asList(types));
        return this;
    }

    public BiomeListBuilder withTypes(BiomeDictionary.Type ... types) {
        this.required.addAll(Arrays.asList(types));
        return this;
    }

    public BiomeListBuilder withoutBiomes(RegistryKey<Biome> ... biomes) {
        this.blacklistBiome.addAll(Arrays.asList(biomes));
        return this;
    }

    public BiomeListBuilder onlyOverworld() {
        this.onlyOverworld = true;
        return this;
    }

    public RegistryKey<Biome>[] collect() {
        HashSet<RegistryKey<Biome>> set = new HashSet<RegistryKey<Biome>>(this.extras);
        for (BiomeDictionary.Type extraT : this.list) {
            set.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)extraT));
        }
        if (this.required.size() > 0 || this.blacklist.size() > 0) {
            for (ResourceLocation biomeRL : ForgeRegistries.BIOMES.getKeys()) {
                RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)biomeRL);
                Set types = BiomeDictionary.getTypes((RegistryKey)biomeKey);
                if (types.size() <= 0) continue;
                boolean pass = true;
                for (BiomeDictionary.Type type : this.required) {
                    if (types.contains(type)) continue;
                    pass = false;
                    break;
                }
                for (BiomeDictionary.Type type : this.blacklist) {
                    if (!types.contains(type)) continue;
                    pass = false;
                    break;
                }
                if (this.blacklistBiome.contains(biomeKey)) {
                    pass = false;
                }
                if (this.onlyOverworld && !types.contains(BiomeDictionary.Type.OVERWORLD)) {
                    pass = false;
                }
                if (!pass) continue;
                set.add((RegistryKey<Biome>)biomeKey);
            }
        }
        return set.toArray(new RegistryKey[0]);
    }
}

