/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IVariantTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import its_meow.betteranimalsplus.common.entity.ai.WaterfowlNavigator;
import its_meow.betteranimalsplus.common.entity.util.EntityUtil;
import its_meow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithTypes;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModItems;
import its_meow.betteranimalsplus.init.ModSoundEvents;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityGoose
extends EntityAnimalWithTypes {
    public int attacksLeft = 0;
    public int lastAttackTime = 0;
    protected final Set<UUID> dislikedPlayers = new HashSet<UUID>();
    private int eatTicks;
    private static final Predicate<ItemEntity> ITEM_SELECTOR = item -> !item.func_174874_s() && item.func_70089_S();
    public int timeUntilNextEgg;
    public static final String PICKUP_BLOCK_LIST_KEY = "pickup_blacklist";

    public EntityGoose(EntityType<? extends EntityGoose> entityType, World worldIn) {
        super(entityType, worldIn);
        this.func_98053_h(true);
        this.timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + 6000;
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new WaterfowlNavigator((MobEntity)this, worldIn);
    }

    protected float func_189749_co() {
        return 0.95f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal((CreatureEntity)this, 1.4){

            public boolean func_75250_a() {
                return this.field_75267_a.func_70638_az() == null && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151080_bb, Items.field_151014_N, Items.field_185163_cU, Items.field_151081_bc, Items.field_151025_P}), false));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new FindItemsGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.1, false){

            public void func_75249_e() {
                EntityGoose.this.attacksLeft = this.field_75441_b.func_70681_au().nextInt(4) + 1;
                super.func_75249_e();
            }

            public boolean func_75250_a() {
                return super.func_75250_a() && this.field_75441_b.field_70173_aa - EntityGoose.this.lastAttackTime > 150 && !EntityGoose.this.isPassive();
            }

            public boolean func_75253_b() {
                return EntityGoose.this.attacksLeft > 0 && super.func_75253_b();
            }

            protected void func_190102_a(LivingEntity p_190102_1_, double p_190102_2_) {
                if (EntityGoose.this.attacksLeft > 0) {
                    super.func_190102_a(p_190102_1_, p_190102_2_);
                } else {
                    this.func_75251_c();
                }
            }

            public void func_75251_c() {
                super.func_75251_c();
                if (EntityGoose.this.attacksLeft <= 0) {
                    this.field_75441_b.func_70624_b(null);
                }
            }
        });
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]){

            public boolean func_75250_a() {
                return super.func_75250_a() && !EntityGoose.this.isPassive();
            }
        }.func_220794_a(new Class[]{EntityGoose.class}));
        this.field_70715_bh.func_75776_a(1, (Goal)new DislikeTargetGoal(this){

            @Override
            public boolean func_75250_a() {
                return super.func_75250_a() && !EntityGoose.this.isPassive();
            }
        });
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b;
    }

    protected boolean isPassive() {
        return this.getVariantString().equals("1") || this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL;
    }

    public void func_70636_d() {
        ItemStack itemstack;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70613_aW() && (itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND)).func_77973_b().func_219971_r() && this.func_70638_az() == null) {
            ++this.eatTicks;
            if (this.eatTicks > 200) {
                ItemStack itemstack1;
                if (itemstack.func_77973_b() == Items.field_151025_P) {
                    this.func_195064_c(new EffectInstance(Effects.field_76436_u, 900));
                }
                if (!(itemstack1 = itemstack.func_77950_b(this.field_70170_p, (LivingEntity)this)).func_190926_b()) {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack1);
                }
                this.eatTicks = 0;
            } else if (this.eatTicks > 160 && this.field_70146_Z.nextFloat() < 0.1f) {
                this.func_184185_a(this.func_213353_d(itemstack), 1.0f, 1.0f);
                this.field_70170_p.func_72960_a((Entity)this, (byte)45);
            }
        }
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && --this.timeUntilNextEgg <= 0) {
            this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_199702_a(this.func_70681_au().nextInt(128) == 0 ? (IItemProvider)ModItems.GOLDEN_GOOSE_EGG.get() : (IItemProvider)ModItems.GOOSE_EGG.get(), 1);
            this.timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + 6000;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 45) {
            ItemStack stack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!stack.func_190926_b()) {
                for (int i = 0; i < 8; ++i) {
                    Vector3d vec3d = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).func_178789_a(-this.field_70125_A * ((float)Math.PI / 180)).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), this.func_226277_ct_() + this.func_70040_Z().field_72450_a / 2.0, this.func_226278_cu_(), this.func_226281_cx_() + this.func_70040_Z().field_72449_c / 2.0, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70624_b(LivingEntity entity) {
        super.func_70624_b(entity);
        if (entity instanceof PlayerEntity) {
            UUID uuid = ((PlayerEntity)entity).func_146103_bH().getId();
            this.dislikedPlayers.add(uuid);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.attacksLeft > 0) {
            --this.attacksLeft;
        }
        this.lastAttackTime = this.field_70173_aa;
        return super.func_70652_k(entityIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() != null && source.func_76346_g() != null && source.func_76346_g() == this.func_70638_az()) {
            this.lastAttackTime = 0;
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_213345_d(DamageSource damageSourceIn) {
        ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        if (!itemstack.func_190926_b()) {
            this.func_199701_a_(itemstack);
            this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
        }
        super.func_213345_d(damageSourceIn);
    }

    public boolean func_213365_e(ItemStack stack) {
        EquipmentSlotType type = MobEntity.func_184640_d((ItemStack)stack);
        if (!this.func_184582_a(type).func_190926_b()) {
            return false;
        }
        return type == EquipmentSlotType.MAINHAND && super.func_213365_e(stack);
    }

    public boolean func_175448_a(ItemStack newStack) {
        ItemStack oldStack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        return !this.isPickupBlacklisted(newStack.func_77973_b()) && (oldStack.func_190926_b() || this.eatTicks == 0 && newStack.func_77973_b().func_219971_r() && !oldStack.func_77973_b().func_219971_r());
    }

    public boolean isPickupBlacklisted(Item item) {
        String id = item.getRegistryName().toString();
        for (String itemsId : (List)this.getContainer().getCustomConfiguration().getStringListHolder(PICKUP_BLOCK_LIST_KEY).get()) {
            if (!(itemsId.startsWith("#") ? item.getTags().contains(new ResourceLocation(itemsId.substring(1))) : id.equals(itemsId))) continue;
            return true;
        }
        return false;
    }

    private void dropItem(ItemStack stack) {
        if (!stack.func_190926_b() && !this.field_70170_p.field_72995_K) {
            ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + this.func_70040_Z().field_72450_a, this.func_226278_cu_() + 1.0, this.func_226281_cx_() + this.func_70040_Z().field_72449_c, stack);
            itementity.func_174867_a(40);
            itementity.func_200216_c(this.func_110124_au());
            this.func_184185_a(SoundEvents.field_219629_dC, 1.0f, 1.0f);
            this.field_70170_p.func_217376_c((Entity)itementity);
        }
    }

    private void spawnItem(ItemStack stack) {
        ItemEntity entity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack);
        this.field_70170_p.func_217376_c((Entity)entity);
    }

    public SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.GOOSE_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.GOOSE_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.GOOSE_DEATH.get();
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.func_92059_d();
        if (this.func_175448_a(stack)) {
            int i = stack.func_190916_E();
            if (i > 1) {
                this.spawnItem(stack.func_77979_a(i - 1));
            }
            this.dropItem(this.func_184582_a(EquipmentSlotType.MAINHAND));
            this.func_184201_a(EquipmentSlotType.MAINHAND, stack.func_77979_a(1));
            this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a((Entity)itemEntity, stack.func_190916_E());
            itemEntity.func_70106_y();
            this.eatTicks = 0;
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ListNBT list = new ListNBT();
        for (UUID uuid : this.dislikedPlayers) {
            list.add((Object)StringNBT.func_229705_a_((String)uuid.toString()));
        }
        compound.func_218657_a("disliked_players", (INBT)list);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        compound.func_150295_c("disliked_players", 8).forEach(nbt -> this.dislikedPlayers.add(UUID.fromString(nbt.func_150285_a_())));
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, ILivingEntityData livingdata, CompoundNBT compound) {
        String[] types;
        switch (reason) {
            case NATURAL: {
                types = new String[]{"2", "3"};
                break;
            }
            case CHUNK_GENERATION: {
                types = new String[]{"2", "3"};
                break;
            }
            case STRUCTURE: {
                types = new String[]{"2", "3"};
                break;
            }
            case BREEDING: {
                types = new String[]{"1"};
                break;
            }
            default: {
                types = new String[]{"1", "2", "3"};
            }
        }
        livingdata = EntityUtil.childChance((AgeableEntity)this, reason, livingdata, 0.25f);
        IVariant variant = this.getContainer().getVariantForName(types[this.func_70681_au().nextInt(types.length)]);
        if (livingdata instanceof IVariantTypes.AgeableTypeData) {
            variant = ((IVariantTypes.AgeableTypeData)((Object)livingdata)).typeData;
        } else {
            livingdata = livingdata instanceof AgeableEntity.AgeableData ? new IVariantTypes.AgeableTypeData((AgeableEntity.AgeableData)livingdata, variant) : new IVariantTypes.AgeableTypeData(variant);
        }
        this.setType(variant);
        return livingdata;
    }

    public static boolean canGooseSpawn(EntityType<EntityGoose> type, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        Block downBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return (downBlock == Blocks.field_196658_i && EntityGoose.nearWater(world, pos) || downBlock == Blocks.field_150355_j) && world.func_226659_b_(pos, 0) > 8 && world.func_175623_d(pos);
    }

    protected static boolean nearWater(IWorld world, BlockPos pos) {
        int i = 12;
        int j = 2;
        BlockPos.Mutable newpos = new BlockPos.Mutable();
        int k = 0;
        while (k <= j) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        newpos.func_189533_g((Vector3i)pos).func_196234_d(i1, k - 1, j1);
                        if (newpos.func_177958_n() >> 4 == pos.func_177958_n() >> 4 && newpos.func_177952_p() >> 4 == pos.func_177952_p() >> 4 && world.func_180495_p((BlockPos)newpos).func_177230_c() == Blocks.field_150355_j) {
                            return true;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return false;
    }

    @Override
    protected EntityGoose getBaseChild() {
        return (EntityGoose)this.getContainer().getEntityType().func_200721_a(this.field_70170_p);
    }

    @Override
    public EntityTypeContainer<EntityGoose> getContainer() {
        return ModEntities.GOOSE;
    }

    public class DislikeTargetGoal
    extends TargetGoal {
        protected EntityGoose goose;

        public DislikeTargetGoal(EntityGoose goose) {
            super((MobEntity)goose, true);
            this.goose = goose;
        }

        public boolean func_75250_a() {
            return this.goose.dislikedPlayers.size() > 0 && this.goose.func_70638_az() == null && this.goose.field_70173_aa - this.goose.lastAttackTime > 150;
        }

        protected boolean func_220777_a(LivingEntity potentialTarget, EntityPredicate targetPredicate) {
            return potentialTarget instanceof PlayerEntity && super.func_220777_a(potentialTarget, targetPredicate) && EntityGoose.this.dislikedPlayers.contains(((PlayerEntity)potentialTarget).func_146103_bH().getId());
        }
    }

    public class FindItemsGoal
    extends Goal {
        public FindItemsGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (!EntityGoose.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
                return false;
            }
            if (EntityGoose.this.func_70638_az() == null && EntityGoose.this.func_70643_av() == null) {
                if (EntityGoose.this.func_70681_au().nextInt(10) != 0) {
                    return false;
                }
                List list = EntityGoose.this.field_70170_p.func_175647_a(ItemEntity.class, EntityGoose.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), ITEM_SELECTOR);
                return !list.isEmpty() && EntityGoose.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b();
            }
            return false;
        }

        public void func_75246_d() {
            List list = EntityGoose.this.field_70170_p.func_175647_a(ItemEntity.class, EntityGoose.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), ITEM_SELECTOR);
            ItemStack itemstack = EntityGoose.this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (itemstack.func_190926_b() && !list.isEmpty()) {
                EntityGoose.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }

        public void func_75249_e() {
            List list = EntityGoose.this.field_70170_p.func_175647_a(ItemEntity.class, EntityGoose.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), ITEM_SELECTOR);
            if (!list.isEmpty()) {
                EntityGoose.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }
    }
}

