/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity.util.abstracts;

import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IVariantTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import its_meow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithTypes;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public abstract class EntityAnimalWithTypesAndSize
extends EntityAnimalWithTypes {
    protected static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(EntityAnimalWithTypesAndSize.class, (IDataSerializer)DataSerializers.field_187193_c);

    public EntityAnimalWithTypesAndSize(EntityType<? extends EntityAnimalWithTypes> entityType, World worldIn) {
        super(entityType, worldIn);
        this.setSize(0.35f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(1.0f));
    }

    public EntitySize func_213305_a(Pose pose) {
        float size = ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
        return EntitySize.func_220314_b((float)size, (float)size).func_220313_a(this.func_213355_cm());
    }

    public void setSize(float size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(size));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("Size", this.func_213305_a((Pose)Pose.STANDING).field_220315_a);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        float size = compound.func_74760_g("Size");
        this.setSize(size);
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingdata, CompoundNBT compound) {
        livingdata = super.func_213386_a(world, difficulty, reason, (ILivingEntityData)livingdata, compound);
        if (!this.func_70631_g_()) {
            IVariant i = this.getRandomType();
            float rand = this.getRandomizedSize();
            if (livingdata instanceof AgeableSizeTypeData) {
                i = ((AgeableSizeTypeData)((Object)livingdata)).typeData;
                rand = ((AgeableSizeTypeData)((Object)livingdata)).size;
            } else {
                livingdata = new AgeableSizeTypeData(i, rand);
            }
            this.setType(i);
            this.setSize(rand);
        }
        return livingdata;
    }

    protected abstract float getRandomizedSize();

    public static class AgeableSizeTypeData
    extends IVariantTypes.AgeableTypeData {
        public float size;

        public AgeableSizeTypeData(IVariant type, float size) {
            super(type);
            this.size = size;
        }

        public AgeableSizeTypeData(AgeableEntity.AgeableData ageable, IVariant type, float size) {
            super(ageable, type);
            this.size = size;
        }
    }
}

