/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbteams.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.property.TeamPropertyValue;
import java.util.Optional;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public abstract class TeamProperty<T> {
    public final ResourceLocation id;
    public final T defaultValue;

    public TeamProperty(ResourceLocation _id, T def) {
        this.id = _id;
        this.defaultValue = def;
    }

    public abstract TeamPropertyType<T> getType();

    public abstract Optional<T> fromString(String var1);

    public abstract void write(PacketBuffer var1);

    public String toString(T value) {
        return value.toString();
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final String toString() {
        return this.id.toString();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TeamProperty) {
            return this.id.equals((Object)((TeamProperty)o).id);
        }
        return false;
    }

    public void writeValue(PacketBuffer buf, T value) {
        buf.func_211400_a(this.toString(value), Short.MAX_VALUE);
    }

    public T readValue(PacketBuffer buf) {
        return this.fromString(buf.func_150789_c(Short.MAX_VALUE)).orElse(this.defaultValue);
    }

    public void config(ConfigGroup config, TeamPropertyValue<T> value) {
    }

    public INBT toNBT(T value) {
        return StringNBT.func_229705_a_((String)this.toString(value));
    }

    public Optional<T> fromNBT(INBT tag) {
        return this.fromString(tag.func_150285_a_());
    }
}

