/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.event.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import me.shedaniel.architectury.event.CompoundEventResult;
import me.shedaniel.architectury.event.EventResult;
import me.shedaniel.architectury.event.events.BlockEvent;
import me.shedaniel.architectury.event.events.ChatEvent;
import me.shedaniel.architectury.event.events.ChunkEvent;
import me.shedaniel.architectury.event.events.CommandPerformEvent;
import me.shedaniel.architectury.event.events.CommandRegistrationEvent;
import me.shedaniel.architectury.event.events.EntityEvent;
import me.shedaniel.architectury.event.events.ExplosionEvent;
import me.shedaniel.architectury.event.events.InteractionEvent;
import me.shedaniel.architectury.event.events.LifecycleEvent;
import me.shedaniel.architectury.event.events.PlayerEvent;
import me.shedaniel.architectury.event.events.TickEvent;
import me.shedaniel.architectury.utils.IntValue;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class EventHandlerImplCommon {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            TickEvent.SERVER_PRE.invoker().tick(ServerLifecycleHooks.getCurrentServer());
        } else if (event.phase == TickEvent.Phase.END) {
            TickEvent.SERVER_POST.invoker().tick(ServerLifecycleHooks.getCurrentServer());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(TickEvent.WorldTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            if (event.phase == TickEvent.Phase.START) {
                TickEvent.SERVER_WORLD_PRE.invoker().tick((ServerWorld)event.world);
            } else if (event.phase == TickEvent.Phase.END) {
                TickEvent.SERVER_WORLD_POST.invoker().tick((ServerWorld)event.world);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(FMLServerStartingEvent event) {
        LifecycleEvent.SERVER_STARTING.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(FMLServerStartedEvent event) {
        LifecycleEvent.SERVER_STARTED.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(FMLServerStoppingEvent event) {
        LifecycleEvent.SERVER_STOPPING.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(FMLServerStoppedEvent event) {
        LifecycleEvent.SERVER_STOPPED.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(RegisterCommandsEvent event) {
        CommandRegistrationEvent.EVENT.invoker().register((CommandDispatcher<CommandSource>)event.getDispatcher(), event.getEnvironment());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEvent.PLAYER_JOIN.invoker().join((ServerPlayerEntity)event.getPlayer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerEvent.PLAYER_QUIT.invoker().quit((ServerPlayerEntity)event.getPlayer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.PlayerRespawnEvent event) {
        PlayerEvent.PLAYER_RESPAWN.invoker().respawn((ServerPlayerEntity)event.getPlayer(), event.isEndConquered());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(CommandEvent event) {
        CommandPerformEvent performEvent = new CommandPerformEvent((ParseResults<CommandSource>)event.getParseResults(), event.getException());
        if (CommandPerformEvent.EVENT.invoker().act(performEvent) == ActionResultType.FAIL) {
            event.setCanceled(true);
        }
        event.setParseResults(performEvent.getResults());
        event.setException(performEvent.getThrowable());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            TickEvent.PLAYER_PRE.invoker().tick(event.player);
        } else if (event.phase == TickEvent.Phase.END) {
            TickEvent.PLAYER_POST.invoker().tick(event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ServerChatEvent event) {
        ActionResult<ITextComponent> process = ChatEvent.SERVER.invoker().process(event.getPlayer(), event.getMessage(), event.getComponent());
        if (process.func_188398_b() != null) {
            event.setComponent((ITextComponent)process.func_188398_b());
        }
        if (process.func_188397_a() == ActionResultType.FAIL) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)event.getWorld();
            LifecycleEvent.SERVER_WORLD_LOAD.invoker().act(world);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(WorldEvent.Unload event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)event.getWorld();
            LifecycleEvent.SERVER_WORLD_UNLOAD.invoker().act(world);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(WorldEvent.Save event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)event.getWorld();
            LifecycleEvent.SERVER_WORLD_SAVE.invoker().act(world);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(LivingDeathEvent event) {
        if (EntityEvent.LIVING_DEATH.invoker().die(event.getEntityLiving(), event.getSource()) == ActionResultType.FAIL) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(AdvancementEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            PlayerEvent.PLAYER_ADVANCEMENT.invoker().award((ServerPlayerEntity)event.getPlayer(), event.getAdvancement());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.Clone event) {
        if (event.getOriginal() instanceof ServerPlayerEntity && event.getPlayer() instanceof ServerPlayerEntity) {
            PlayerEvent.PLAYER_CLONE.invoker().clone((ServerPlayerEntity)event.getOriginal(), (ServerPlayerEntity)event.getPlayer(), !event.isWasDeath());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ExplosionEvent.Start event) {
        if (ExplosionEvent.PRE.invoker().explode(event.getWorld(), event.getExplosion()) == ActionResultType.FAIL) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ExplosionEvent.Detonate event) {
        ExplosionEvent.DETONATE.invoker().explode(event.getWorld(), event.getExplosion(), event.getAffectedEntities());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(LivingAttackEvent event) {
        if (EntityEvent.LIVING_ATTACK.invoker().attack(event.getEntityLiving(), event.getSource(), event.getAmount()) == ActionResultType.FAIL) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(EntityJoinWorldEvent event) {
        if (EntityEvent.ADD.invoker().add(event.getEntity(), event.getWorld()) == ActionResultType.FAIL) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(BlockEvent.FarmlandTrampleEvent event) {
        if (InteractionEvent.FARMLAND_TRAMPLE.invoker().trample((World)event.getWorld(), event.getPos(), event.getState(), event.getFallDistance(), event.getEntity()).value() != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(FillBucketEvent event) {
        ItemStack oldItem = event.getEmptyBucket();
        CompoundEventResult<ItemStack> result = PlayerEvent.FILL_BUCKET.invoker().fill(event.getPlayer(), event.getWorld(), oldItem, event.getTarget());
        if (result.interruptsFurtherEvaluation()) {
            event.setCanceled(true);
            event.setFilledBucket(result.object());
            if (result.value() != null) {
                event.setResult(result.value() != false ? Event.Result.ALLOW : Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(EntityEvent.EnteringChunk event) {
        EntityEvent.ENTER_CHUNK.invoker().enterChunk(event.getEntity(), event.getNewChunkX(), event.getNewChunkZ(), event.getOldChunkX(), event.getOldChunkZ());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(LivingSpawnEvent.CheckSpawn event) {
        EventResult result = EntityEvent.LIVING_CHECK_SPAWN.invoker().canSpawn(event.getEntityLiving(), event.getWorld(), event.getX(), event.getY(), event.getZ(), event.getSpawnReason(), event.getSpawner());
        if (result.interruptsFurtherEvaluation()) {
            if (result.value() != null) {
                event.setResult(result.value() == Boolean.TRUE ? Event.Result.ALLOW : Event.Result.DENY);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.ItemCraftedEvent event) {
        PlayerEvent.CRAFT_ITEM.invoker().craft(event.getPlayer(), event.getCrafting(), event.getInventory());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.ItemSmeltedEvent event) {
        PlayerEvent.SMELT_ITEM.invoker().smelt(event.getPlayer(), event.getSmelting());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(EntityItemPickupEvent event) {
        PlayerEvent.PICKUP_ITEM_PRE.invoker().canPickup(event.getPlayer(), event.getItem(), event.getItem().func_92059_d());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.ItemPickupEvent event) {
        PlayerEvent.PICKUP_ITEM_POST.invoker().pickup(event.getPlayer(), event.getOriginalEntity(), event.getStack());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ItemTossEvent event) {
        PlayerEvent.DROP_ITEM.invoker().drop(event.getPlayer(), event.getEntityItem());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerContainerEvent.Open event) {
        PlayerEvent.OPEN_MENU.invoker().open(event.getPlayer(), event.getContainer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerContainerEvent.Close event) {
        PlayerEvent.CLOSE_MENU.invoker().close(event.getPlayer(), event.getContainer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerInteractEvent.RightClickItem event) {
        ActionResult<ItemStack> result = InteractionEvent.RIGHT_CLICK_ITEM.invoker().click(event.getPlayer(), event.getHand());
        if (result.func_188397_a() != ActionResultType.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(result.func_188397_a());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerInteractEvent.RightClickBlock event) {
        ActionResultType result = InteractionEvent.RIGHT_CLICK_BLOCK.invoker().click(event.getPlayer(), event.getHand(), event.getPos(), event.getFace());
        if (result != ActionResultType.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(result);
            event.setUseBlock(Event.Result.DENY);
            event.setUseItem(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerInteractEvent.EntityInteract event) {
        ActionResultType result = InteractionEvent.INTERACT_ENTITY.invoker().interact(event.getPlayer(), event.getTarget(), event.getHand());
        if (result != ActionResultType.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerInteractEvent.LeftClickBlock event) {
        ActionResultType result = InteractionEvent.LEFT_CLICK_BLOCK.invoker().click(event.getPlayer(), event.getHand(), event.getPos(), event.getFace());
        if (result != ActionResultType.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(result);
            event.setUseBlock(Event.Result.DENY);
            event.setUseItem(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(final BlockEvent.BreakEvent event) {
        ActionResultType result;
        if (event.getPlayer() instanceof ServerPlayerEntity && event.getWorld() instanceof World && (result = BlockEvent.BREAK.invoker().breakBlock((World)event.getWorld(), event.getPos(), event.getState(), (ServerPlayerEntity)event.getPlayer(), new IntValue(){

            @Override
            public int getAsInt() {
                return event.getExpToDrop();
            }

            @Override
            public void accept(int value) {
                event.setExpToDrop(value);
            }
        })) != ActionResultType.PASS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(BlockEvent.EntityPlaceEvent event) {
        ActionResultType result;
        if (event.getWorld() instanceof World && (result = BlockEvent.PLACE.invoker().placeBlock((World)event.getWorld(), event.getPos(), event.getState(), event.getEntity())) != ActionResultType.PASS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(FMLServerAboutToStartEvent event) {
        LifecycleEvent.SERVER_BEFORE_START.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            PlayerEvent.CHANGE_DIMENSION.invoker().change((ServerPlayerEntity)event.getPlayer(), (RegistryKey<World>)event.getFrom(), (RegistryKey<World>)event.getTo());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ChunkDataEvent.Save event) {
        if (event.getWorld() instanceof ServerWorld) {
            ChunkEvent.SAVE_DATA.invoker().save(event.getChunk(), (ServerWorld)event.getWorld(), event.getData());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ChunkDataEvent.Load event) {
        IWorld level = event.getChunk().getWorldForge();
        if (!(level instanceof ServerWorld)) {
            level = ((WorldEventAttachment)event).architectury$getAttachedLevel();
        }
        ChunkEvent.LOAD_DATA.invoker().load(event.getChunk(), level instanceof ServerWorld ? (ServerWorld)level : null, event.getData());
    }

    public static interface WorldEventAttachment {
        public IWorld architectury$getAttachedLevel();

        public void architectury$attachLevel(IWorld var1);
    }

    public static class ModBasedEventHandler {
    }
}

