/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.RegistryObject;

public class RefineryRecipe
extends MultiblockRecipe {
    public static IRecipeType<RefineryRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<RefineryRecipe>> SERIALIZER;
    public final FluidStack output;
    public final FluidTagInput input0;
    public final FluidTagInput input1;
    public static Map<ResourceLocation, RefineryRecipe> recipeList;

    public RefineryRecipe(ResourceLocation id, FluidStack output, FluidTagInput input0, FluidTagInput input1, int energy) {
        super(ItemStack.field_190927_a, TYPE, id);
        this.output = output;
        this.input0 = input0;
        this.input1 = input1;
        this.setTimeAndEnergy(1, energy);
        this.fluidInputList = Lists.newArrayList((Object[])new FluidTagInput[]{this.input0, this.input1});
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.output});
    }

    @Override
    protected IERecipeSerializer<RefineryRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public static RefineryRecipe findRecipe(FluidStack input0, FluidStack input1) {
        for (RefineryRecipe recipe : recipeList.values()) {
            if (input0 != null) {
                if (recipe.input0 != null && recipe.input0.test(input0) && (recipe.input1 == null && input1 == null || recipe.input1 != null && input1 != null && recipe.input1.test(input1))) {
                    return recipe;
                }
                if (recipe.input1 == null || !recipe.input1.test(input0) || (recipe.input0 != null || input1 != null) && (recipe.input0 == null || input1 == null || !recipe.input0.test(input1))) continue;
                return recipe;
            }
            if (input1 == null) continue;
            if (recipe.input0 != null && recipe.input0.test(input1) && recipe.input1 == null) {
                return recipe;
            }
            if (recipe.input1 == null || !recipe.input1.test(input1) || recipe.input0 != null) continue;
            return recipe;
        }
        return null;
    }

    public static Optional<RefineryRecipe> findIncompleteRefineryRecipe(@Nonnull FluidStack input0, @Nonnull FluidStack input1) {
        if (input0.isEmpty() && input1.isEmpty()) {
            return Optional.empty();
        }
        for (RefineryRecipe recipe : recipeList.values()) {
            if (!(!input0.isEmpty() && input1.isEmpty() ? recipe.input0.testIgnoringAmount(input0) || recipe.input1.testIgnoringAmount(input0) : (input0.isEmpty() && !input1.isEmpty() ? recipe.input0.testIgnoringAmount(input1) || recipe.input1.testIgnoringAmount(input1) : recipe.input0.testIgnoringAmount(input0) && recipe.input1.testIgnoringAmount(input1) || recipe.input1.testIgnoringAmount(input0) && recipe.input0.testIgnoringAmount(input1)))) continue;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        recipeList = Collections.emptyMap();
    }
}

