/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy.immersiveflux;

import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxStorage;
import net.minecraft.nbt.CompoundNBT;

public class FluxStorage
implements IFluxStorage {
    protected int energy;
    protected int capacity;
    protected int limitReceive;
    protected int limitExtract;

    public FluxStorage(int capacity, int limitReceive, int limitExtract) {
        this.capacity = capacity;
        this.limitReceive = limitReceive;
        this.limitExtract = limitExtract;
    }

    public FluxStorage(int capacity, int limitTransfer) {
        this(capacity, limitTransfer, limitTransfer);
    }

    public FluxStorage(int capacity) {
        this(capacity, capacity, capacity);
    }

    public FluxStorage readFromNBT(CompoundNBT nbt) {
        this.energy = nbt.func_74762_e("ifluxEnergy");
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
        return this;
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        if (this.energy < 0) {
            this.energy = 0;
        }
        nbt.func_74768_a("ifluxEnergy", this.energy);
        return nbt;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.energy > capacity) {
            this.energy = capacity;
        }
    }

    public void setLimitTransfer(int limitTransfer) {
        this.setLimitReceive(limitTransfer);
        this.setMaxExtract(limitTransfer);
    }

    public void setLimitReceive(int limitReceive) {
        this.limitReceive = limitReceive;
    }

    public void setMaxExtract(int limitExtract) {
        this.limitExtract = limitExtract;
    }

    public int getLimitReceive() {
        return this.limitReceive;
    }

    public int getLimitExtract() {
        return this.limitExtract;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public void modifyEnergyStored(int energy) {
        this.energy += energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    @Override
    public int receiveEnergy(int energy, boolean simulate) {
        int received = Math.min(this.capacity - this.energy, Math.min(this.limitReceive, energy));
        if (!simulate) {
            this.energy += received;
        }
        return received;
    }

    @Override
    public int extractEnergy(int energy, boolean simulate) {
        int extracted = Math.min(this.energy, Math.min(this.limitExtract, energy));
        if (!simulate) {
            this.energy -= extracted;
        }
        return extracted;
    }

    @Override
    public int getEnergyStored() {
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.capacity;
    }
}

