/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj;

import blusunrize.immersiveengineering.api.utils.QuadTransformer;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.IModelBuilder;

public class QuadListAdder
implements IModelBuilder<QuadListAdder> {
    private final Consumer<BakedQuad> output;
    private final BiConsumer<BakedQuad, Direction> outputFace;
    private final Function<BakedQuad, BakedQuad> transform;

    public QuadListAdder(Consumer<BakedQuad> output, BiConsumer<BakedQuad, Direction> outputFace, TransformationMatrix transform) {
        this.output = output;
        this.outputFace = outputFace;
        this.transform = new QuadTransformer(transform, x -> x);
    }

    public QuadListAdder(Consumer<BakedQuad> output, TransformationMatrix transform) {
        this(output, (quad, dir) -> output.accept((BakedQuad)quad), transform);
    }

    @Nonnull
    public QuadListAdder addFaceQuad(@Nonnull Direction facing, @Nonnull BakedQuad quad) {
        this.outputFace.accept(this.transform.apply(quad), facing);
        return this;
    }

    @Nonnull
    public QuadListAdder addGeneralQuad(@Nonnull BakedQuad quad) {
        this.output.accept(this.transform.apply(quad));
        return this;
    }

    @Nonnull
    public IBakedModel build() {
        throw new UnsupportedOperationException();
    }
}

