/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.InternalStorageItem;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.util.ListUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public class SpeedloaderItem
extends InternalStorageItem
implements ITool,
IEItemInterfaces.IBulletContainer {
    public SpeedloaderItem() {
        super("speedloader", new Item.Properties().func_200917_a(1));
    }

    @Override
    public int getSlotCount() {
        return 8;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            this.openGui(player, hand == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public boolean isEmpty(ItemStack stack) {
        return stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(inv -> {
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack b = inv.getStackInSlot(i);
                if (b.func_190926_b() || !(b.func_77973_b() instanceof BulletItem)) continue;
                return false;
            }
            return true;
        }).orElse(true);
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    @Override
    public int getBulletCount(ItemStack container) {
        return this.getSlotCount();
    }

    @Override
    public NonNullList<ItemStack> getBullets(ItemStack revolver) {
        return ListUtils.fromItems(this.getContainedItems(revolver).subList(0, this.getSlotCount()));
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        return RevolverItem.copyBulletsToShareTag(stack, super.getShareTag(stack));
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        super.readShareTag(stack, nbt);
        RevolverItem.readBulletsFromShareTag(stack, nbt);
    }
}

