/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.managers;

import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.AbstractActionRemoveMultipleOutputs;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.helper.CraftTweakerHelper;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersiveengineering/Sawmill")
@ZenCodeType.Name(value="mods.immersiveengineering.Sawmill")
public class SawmillRecipeManager
implements IRecipeManager {
    public IRecipeType<SawmillRecipe> getRecipeType() {
        return SawmillRecipe.TYPE;
    }

    public void removeRecipe(IItemStack output) {
        AbstractActionRemoveMultipleOutputs<SawmillRecipe> action = new AbstractActionRemoveMultipleOutputs<SawmillRecipe>((IRecipeManager)this, (IIngredient)output){

            @Override
            public List<ItemStack> getAllOutputs(SawmillRecipe recipe) {
                ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
                itemStacks.add(recipe.output);
                itemStacks.add(recipe.stripped);
                itemStacks.addAll((Collection<ItemStack>)recipe.secondaryOutputs);
                itemStacks.addAll((Collection<ItemStack>)recipe.secondaryStripping);
                return itemStacks;
            }
        };
        CraftTweakerAPI.apply((IAction)action);
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredient input, int energy, IItemStack strippedOutput, IItemStack[] strippedOutputSecondaries, IItemStack output, IItemStack[] outputSecondaries) {
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipePath);
        Ingredient ingredient = input.asVanillaIngredient();
        ItemStack stripped = strippedOutput.getInternal();
        ItemStack[] secondaryStripping = CraftTweakerHelper.getItemStacks((IItemStack[])strippedOutputSecondaries);
        if (stripped.func_190926_b() && strippedOutputSecondaries.length != 0) {
            throw new IllegalArgumentException("Cannot have secondary stripped outputs when the main stripped output is empty!");
        }
        ItemStack mainOutput = output.getInternal();
        ItemStack[] secondaryOutputs = CraftTweakerHelper.getItemStacks((IItemStack[])outputSecondaries);
        SawmillRecipe recipe = new SawmillRecipe(resourceLocation, mainOutput, stripped, ingredient, energy);
        for (ItemStack stack : secondaryStripping) {
            recipe.addToSecondaryStripping(stack);
        }
        for (ItemStack stack : secondaryOutputs) {
            recipe.addToSecondaryOutput(stack);
        }
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)recipe, null));
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredient input, int energy, IItemStack output, IItemStack[] outputSecondaries) {
        this.addRecipe(recipePath, input, energy, (IItemStack)MCItemStack.EMPTY.get(), new IItemStack[0], output, outputSecondaries);
    }
}

