/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network.packets;

import com.google.common.base.Preconditions;
import mezz.jei.network.IPacketId;
import mezz.jei.network.PacketIdServer;
import mezz.jei.network.packets.PacketJei;
import mezz.jei.util.CommandUtilServer;
import mezz.jei.util.ErrorUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class PacketSetHotbarItemStack
extends PacketJei {
    private final ItemStack itemStack;
    private final int hotbarSlot;

    public PacketSetHotbarItemStack(ItemStack itemStack, int hotbarSlot) {
        ErrorUtil.checkNotNull(itemStack, "itemStack");
        Preconditions.checkArgument((boolean)PlayerInventory.func_184435_e((int)hotbarSlot), (Object)("hotbar slot must be in the hotbar. got: " + hotbarSlot));
        this.itemStack = itemStack;
        this.hotbarSlot = hotbarSlot;
    }

    @Override
    public IPacketId getPacketId() {
        return PacketIdServer.SET_HOTBAR_ITEM;
    }

    @Override
    public void writePacketData(PacketBuffer buf) {
        buf.func_150788_a(this.itemStack);
        buf.func_150787_b(this.hotbarSlot);
    }

    public static void readPacketData(PacketBuffer buf, PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity sender = (ServerPlayerEntity)player;
            ItemStack itemStack = buf.func_150791_c();
            if (!itemStack.func_190926_b()) {
                int hotbarSlot = buf.func_150792_a();
                CommandUtilServer.setHotbarSlot(sender, itemStack, hotbarSlot);
            }
        }
    }
}

