/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import com.google.common.collect.ImmutableSet;
import flaxbeard.immersivepetroleum.api.crafting.SulfurRecoveryRecipe;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.multiblocks.HydroTreaterMultiblock;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class HydrotreaterTileEntity
extends PoweredMultiblockTileEntity<HydrotreaterTileEntity, SulfurRecoveryRecipe>
implements IEBlockInterfaces.IBlockBounds {
    public static final int TANK_INPUT_A = 0;
    public static final int TANK_INPUT_B = 1;
    public static final int TANK_OUTPUT = 2;
    public static final BlockPos Fluid_IN_A = new BlockPos(1, 0, 3);
    public static final BlockPos Fluid_IN_B = new BlockPos(2, 2, 1);
    public static final BlockPos Fluid_OUT = new BlockPos(0, 1, 2);
    public static final BlockPos Item_OUT = new BlockPos(0, 0, 2);
    public static final Set<BlockPos> Energy_IN = ImmutableSet.of((Object)new BlockPos(2, 2, 3));
    public static final Set<BlockPos> Redstone_IN = ImmutableSet.of((Object)new BlockPos(0, 1, 3));
    public final FluidTank[] tanks = new FluidTank[]{new FluidTank(12000), new FluidTank(12000), new FluidTank(12000)};
    private static CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(HydrotreaterTileEntity::getShape);

    public HydrotreaterTileEntity() {
        super((IETemplateMultiblock)HydroTreaterMultiblock.INSTANCE, 8000, true, null);
    }

    public TileEntityType<?> func_200662_C() {
        return (TileEntityType)IPTileTypes.TREATER.get();
    }

    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.tanks[2].readFromNBT(nbt.func_74775_l("tank2"));
    }

    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_218657_a("tank0", (INBT)this.tanks[0].writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("tank1", (INBT)this.tanks[1].writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("tank2", (INBT)this.tanks[2].writeToNBT(new CompoundNBT()));
    }

    protected SulfurRecoveryRecipe getRecipeForId(ResourceLocation id) {
        return SulfurRecoveryRecipe.recipes.get(id);
    }

    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return false;
    }

    public int getSlotLimit(int slot) {
        return 0;
    }

    public void doGraphicalUpdates() {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    public Set<BlockPos> getEnergyPos() {
        return Energy_IN;
    }

    public Set<BlockPos> getRedstonePos() {
        return Redstone_IN;
    }

    public IEEnums.IOSideConfig getEnergySideConfig(Direction facing) {
        if (this.formed && this.isEnergyPos() && (facing == null || facing == Direction.UP)) {
            return IEEnums.IOSideConfig.INPUT;
        }
        return IEEnums.IOSideConfig.NONE;
    }

    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    public SulfurRecoveryRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    public int[] getOutputSlots() {
        return null;
    }

    public int[] getOutputTanks() {
        return new int[]{2};
    }

    public boolean additionalCanProcessCheck(PoweredMultiblockTileEntity.MultiblockProcess<SulfurRecoveryRecipe> process) {
        int outputAmount = 0;
        for (FluidStack outputFluid : ((SulfurRecoveryRecipe)process.recipe).getFluidOutputs()) {
            outputAmount += outputFluid.getAmount();
        }
        return this.tanks[2].getCapacity() >= this.tanks[2].getFluidAmount() + outputAmount;
    }

    public void doProcessOutput(ItemStack output) {
        IItemHandler handler;
        Direction outputdir = this.getIsMirrored() ? this.getFacing().func_176746_e() : this.getFacing().func_176735_f();
        BlockPos outputpos = this.getBlockPosForPos(Item_OUT).func_177972_a(outputdir);
        TileEntity te = this.field_145850_b.func_175625_s(outputpos);
        if (te != null && (handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, outputdir.func_176734_d()).orElse(null)) != null) {
            output = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)output, (boolean)false);
        }
        if (!output.func_190926_b()) {
            Direction facing;
            double x = (double)outputpos.func_177958_n() + 0.5;
            double y = (double)outputpos.func_177956_o() + 0.25;
            double z = (double)outputpos.func_177952_p() + 0.5;
            Direction direction = facing = this.getIsMirrored() ? this.getFacing().func_176734_d() : this.getFacing();
            if (facing != Direction.EAST && facing != Direction.WEST) {
                x = (double)outputpos.func_177958_n() + (facing == Direction.SOUTH ? 0.15 : 0.85);
            }
            if (facing != Direction.NORTH && facing != Direction.SOUTH) {
                z = (double)outputpos.func_177952_p() + (facing == Direction.WEST ? 0.15 : 0.85);
            }
            ItemEntity ei = new ItemEntity(this.field_145850_b, x, y, z, output.func_77946_l());
            ei.func_213293_j(0.075 * (double)outputdir.func_82601_c(), 0.025, 0.075 * (double)outputdir.func_82599_e());
            this.field_145850_b.func_217376_c((Entity)ei);
        }
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(PoweredMultiblockTileEntity.MultiblockProcess<SulfurRecoveryRecipe> process) {
    }

    public void func_73660_a() {
        SulfurRecoveryRecipe recipe;
        this.checkForNeedlessTicking();
        if (this.field_145850_b.field_72995_K || this.isDummy() || this.isRSDisabled()) {
            return;
        }
        boolean update = false;
        if (!(this.energyStorage.getEnergyStored() <= 0 || this.processQueue.size() >= this.getProcessQueueMaxLength() || this.tanks[0].getFluidAmount() <= 0 && this.tanks[1].getFluidAmount() <= 0 || (recipe = SulfurRecoveryRecipe.findRecipe(this.tanks[0].getFluid(), this.tanks[1].getFluid())) == null || this.energyStorage.getEnergyStored() < recipe.getTotalProcessEnergy() || this.tanks[0].getFluidAmount() < recipe.getInputFluid().getAmount() || recipe.getSecondaryInputFluid() != null && this.tanks[1].getFluidAmount() < recipe.getSecondaryInputFluid().getAmount())) {
            int[] inputAmounts;
            int[] inputs;
            if (recipe.getSecondaryInputFluid() != null) {
                inputs = new int[]{0, 1};
                inputAmounts = new int[]{recipe.getInputFluid().getAmount(), recipe.getSecondaryInputFluid().getAmount()};
            } else {
                inputs = new int[]{0};
                inputAmounts = new int[]{recipe.getInputFluid().getAmount()};
            }
            PoweredMultiblockTileEntity.MultiblockProcessInMachine process = new PoweredMultiblockTileEntity.MultiblockProcessInMachine((MultiblockRecipe)recipe, new int[0]).setInputTanks(inputs).setInputAmounts(inputAmounts);
            if (this.addProcessToQueue((PoweredMultiblockTileEntity.MultiblockProcess)process, true)) {
                this.addProcessToQueue((PoweredMultiblockTileEntity.MultiblockProcess)process, false);
                update = true;
            }
        }
        if (!this.processQueue.isEmpty()) {
            update = true;
        }
        super.func_73660_a();
        if (this.tanks[2].getFluidAmount() > 0) {
            BlockPos outPos = this.getBlockPosForPos(Fluid_OUT).func_177984_a();
            update |= FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)outPos, (Direction)Direction.DOWN).map(output -> {
                boolean ret = false;
                FluidStack target = this.tanks[2].getFluid();
                int accepted = output.fill(target = FluidHelper.copyFluid(target, Math.min(target.getAmount(), 1000)), IFluidHandler.FluidAction.SIMULATE);
                if (accepted > 0) {
                    int drained = output.fill(FluidHelper.copyFluid(target, Math.min(target.getAmount(), accepted)), IFluidHandler.FluidAction.EXECUTE);
                    this.tanks[2].drain(new FluidStack(target.getFluid(), drained), IFluidHandler.FluidAction.EXECUTE);
                    ret |= true;
                }
                return ret;
            }).orElse(false).booleanValue();
        }
        if (update) {
            this.updateMasterBlock(null, true);
        }
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 1;
    }

    public float getMinProcessDistance(PoweredMultiblockTileEntity.MultiblockProcess<SulfurRecoveryRecipe> process) {
        return 1.0f;
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        HydrotreaterTileEntity master = (HydrotreaterTileEntity)this.master();
        if (master != null) {
            if (this.posInMultiblock.equals((Object)Fluid_IN_A) && (side == null || side == this.getFacing().func_176734_d())) {
                return new IFluidTank[]{master.tanks[0]};
            }
            if (this.posInMultiblock.equals((Object)Fluid_IN_B) && (side == null || side == Direction.UP)) {
                return new IFluidTank[]{master.tanks[1]};
            }
            if (this.posInMultiblock.equals((Object)Fluid_OUT) && (side == null || side == Direction.UP)) {
                return new IFluidTank[]{master.tanks[2]};
            }
        }
        return new IFluidTank[0];
    }

    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resource) {
        HydrotreaterTileEntity master;
        if (this.posInMultiblock.equals((Object)Fluid_IN_A) && (side == null || side == this.getFacing().func_176734_d()) && (master = (HydrotreaterTileEntity)this.master()) != null && master.tanks[0].getFluidAmount() < master.tanks[0].getCapacity()) {
            if (master.tanks[0].isEmpty()) {
                return SulfurRecoveryRecipe.hasRecipeWithInput(resource, true);
            }
            return resource.isFluidEqual(master.tanks[0].getFluid());
        }
        if (this.posInMultiblock.equals((Object)Fluid_IN_B) && (side == null || side == Direction.UP) && (master = (HydrotreaterTileEntity)this.master()) != null && master.tanks[1].getFluidAmount() < master.tanks[1].getCapacity()) {
            if (master.tanks[1].isEmpty()) {
                return SulfurRecoveryRecipe.hasRecipeWithSecondaryInput(resource, true);
            }
            return resource.isFluidEqual(master.tanks[1].getFluid());
        }
        return false;
    }

    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return false;
    }

    public VoxelShape getBlockBounds(ISelectionContext ctx) {
        return SHAPES.get((Object)this.posInMultiblock, (Object)Pair.of((Object)this.getFacing(), (Object)this.getIsMirrored()));
    }

    private static List<AxisAlignedBB> getShape(BlockPos posInMultiblock) {
        int x = posInMultiblock.func_177958_n();
        int y = posInMultiblock.func_177956_o();
        int z = posInMultiblock.func_177952_p();
        ArrayList<AxisAlignedBB> main = new ArrayList<AxisAlignedBB>();
        if (y == 0 && (x != 0 || z != 2) && (z != 3 || x != 1 && x != 2)) {
            main.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        if (y == 0 && x == 0 && z == 3) {
            main.add(new AxisAlignedBB(0.75, 0.5, 0.625, 0.875, 1.0, 0.875));
            main.add(new AxisAlignedBB(0.125, 0.5, 0.625, 0.25, 1.0, 0.875));
        } else if (y == 1 && x == 0 && z == 3) {
            main.add(new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0));
        }
        if (x == 0) {
            if (y == 0) {
                if (z == 0) {
                    main.add(new AxisAlignedBB(0.125, 0.75, 0.5, 1.0, 1.0, 1.0));
                    main.add(new AxisAlignedBB(0.25, 0.5, 0.75, 0.875, 0.75, 1.0));
                }
                if (z == 1) {
                    main.add(new AxisAlignedBB(0.125, 0.75, 0.0, 1.0, 1.0, 1.0));
                }
                if (z == 3) {
                    main.add(new AxisAlignedBB(0.125, 0.75, 0.0, 1.0, 1.0, 0.25));
                }
            }
            if (y == 1) {
                if (z == 0) {
                    main.add(new AxisAlignedBB(0.125, 0.0, 0.5, 1.0, 0.75, 1.0));
                }
                if (z == 1) {
                    main.add(new AxisAlignedBB(0.125, 0.0, 0.0, 1.0, 0.75, 1.0));
                }
                if (z == 3) {
                    main.add(new AxisAlignedBB(0.125, 0.0, 0.0, 1.0, 0.75, 0.25));
                }
            }
        }
        if (y == 0) {
            if (z == 0) {
                if (x == 1) {
                    main.add(new AxisAlignedBB(0.125, 0.3125, 0.0625, 0.375, 1.0, 0.3125));
                }
                if (x == 2) {
                    main.add(new AxisAlignedBB(0.625, 0.3125, 0.0625, 0.875, 1.0, 0.3125));
                }
            }
            if (z == 1) {
                if (x == 1) {
                    main.add(new AxisAlignedBB(0.125, 0.3125, 0.875, 0.375, 1.0, 1.0));
                }
                if (x == 2) {
                    main.add(new AxisAlignedBB(0.625, 0.3125, 0.875, 0.875, 1.0, 1.0));
                }
            }
            if (z == 2 && x == 2) {
                main.add(new AxisAlignedBB(0.625, 0.3125, 0.0, 0.875, 1.0, 0.125));
            }
        }
        if (main.isEmpty()) {
            main.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
        }
        return main;
    }
}

