/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.events;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.plane.ClientConfig;
import de.maxhenkel.plane.Main;
import de.maxhenkel.plane.corelib.math.MathUtils;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class RenderEvents {
    private static final ResourceLocation PLANE_INFO_TEXTURE = new ResourceLocation("plane", "textures/gui/plane_info.png");
    private Minecraft mc = Minecraft.func_71410_x();
    private EntityPlaneSoundBase lastVehicle;
    private double cachedRelativeHeight = 0.0;

    @SubscribeEvent
    public void onRender(EntityViewRenderEvent.CameraSetup evt) {
        if (this.getPlane() != null && !this.mc.field_71474_y.func_243230_g().func_243192_a()) {
            evt.getInfo().func_216782_a(-evt.getInfo().func_216779_a(((Double)Main.CLIENT_CONFIG.planeZoom.get()).doubleValue()) + 4.0, 0.0, 0.0);
        }
    }

    @SubscribeEvent
    public void onRender(InputEvent.MouseScrollEvent evt) {
        if (this.getPlane() != null && !this.mc.field_71474_y.func_243230_g().func_243192_a()) {
            Main.CLIENT_CONFIG.planeZoom.set((Object)Math.max(1.0, Math.min(20.0, (Double)Main.CLIENT_CONFIG.planeZoom.get() - evt.getScrollDelta())));
            Main.CLIENT_CONFIG.planeZoom.save();
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent evt) {
        if (!evt.getType().equals((Object)RenderGameOverlayEvent.ElementType.EXPERIENCE)) {
            return;
        }
        ClientPlayerEntity player = this.mc.field_71439_g;
        Entity e = player.func_184187_bx();
        if (!(e instanceof EntityPlaneSoundBase)) {
            return;
        }
        EntityPlaneSoundBase plane = (EntityPlaneSoundBase)e;
        if (((Boolean)Main.CLIENT_CONFIG.showPlaneInfo.get()).booleanValue()) {
            this.renderPlaneInfo(evt.getMatrixStack(), plane);
        }
    }

    public void renderPlaneInfo(MatrixStack matrixStack, EntityPlaneSoundBase plane) {
        matrixStack.func_227860_a_();
        this.mc.func_110434_K().func_110577_a(PLANE_INFO_TEXTURE);
        int texWidth = 110;
        int texHeight = 90;
        int height = this.mc.func_228018_at_().func_198087_p();
        int width = this.mc.func_228018_at_().func_198107_o();
        float scale = ((Double)Main.CLIENT_CONFIG.planeInfoScale.get()).floatValue();
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        matrixStack.func_227861_a_((double)(-width), (double)(-height), 0.0);
        matrixStack.func_227861_a_((double)width * (1.0 / (double)scale), (double)height * (1.0 / (double)scale), 0.0);
        int padding = 3;
        int yStart = height - texHeight - padding;
        int xStart = width - texWidth - padding;
        this.mc.field_71456_v.func_238474_b_(matrixStack, xStart, yStart, 0, 0, texWidth, texHeight);
        FontRenderer font = this.mc.field_71456_v.func_175179_f();
        Function<Integer, Integer> heightFunc = integer -> {
            font.getClass();
            return yStart + 8 + (9 + 2) * integer;
        };
        font.func_238422_b_(matrixStack, new TranslationTextComponent("tooltip.plane.speed", new Object[]{((ClientConfig.SpeedType)((Object)Main.CLIENT_CONFIG.planeInfoSpeedType.get())).getTextComponent(plane.func_213322_ci().func_72433_c())}).func_241878_f(), (float)(xStart + 7), (float)heightFunc.apply(0).intValue(), 0);
        font.func_238422_b_(matrixStack, new TranslationTextComponent("tooltip.plane.vertical_speed", new Object[]{((ClientConfig.SpeedType)((Object)Main.CLIENT_CONFIG.planeInfoSpeedType.get())).getTextComponent(plane.func_213322_ci().func_82617_b())}).func_241878_f(), (float)(xStart + 7), (float)heightFunc.apply(1).intValue(), 0);
        font.func_238422_b_(matrixStack, new TranslationTextComponent("tooltip.plane.throttle", new Object[]{String.valueOf(Math.round(plane.getEngineSpeed() * 100.0f))}).func_241878_f(), (float)(xStart + 7), (float)heightFunc.apply(2).intValue(), 0);
        font.func_238422_b_(matrixStack, new TranslationTextComponent("tooltip.plane.height", new Object[]{String.valueOf(Math.round(plane.func_226278_cu_()))}).func_241878_f(), (float)(xStart + 7), (float)heightFunc.apply(3).intValue(), 0);
        font.func_238422_b_(matrixStack, new TranslationTextComponent("tooltip.plane.relative_height", new Object[]{String.valueOf(Math.round(this.cachedRelativeHeight))}).func_241878_f(), (float)(xStart + 7), (float)heightFunc.apply(4).intValue(), 0);
        font.func_238422_b_(matrixStack, new TranslationTextComponent("tooltip.plane.fuel", new Object[]{String.valueOf(plane.getFuel())}).func_241878_f(), (float)(xStart + 7), (float)heightFunc.apply(5).intValue(), 0);
        font.func_238422_b_(matrixStack, new TranslationTextComponent("tooltip.plane.damage", new Object[]{String.valueOf(MathUtils.round(plane.getPlaneDamage(), 2))}).func_241878_f(), (float)(xStart + 7), (float)heightFunc.apply(6).intValue(), 0);
        matrixStack.func_227865_b_();
    }

    private double getRelativeHeight(EntityPlaneSoundBase plane) {
        int highestBlock = (int)plane.func_226278_cu_();
        BlockPos.Mutable p = new BlockPos.Mutable(plane.func_226277_ct_(), plane.func_226278_cu_(), plane.func_226281_cx_());
        for (int y = highestBlock; y >= 0; --y) {
            p.func_185336_p(y);
            if (!plane.field_70170_p.func_180495_p((BlockPos)p).func_200132_m()) continue;
            highestBlock = y;
            break;
        }
        return plane.func_226278_cu_() - (double)(highestBlock + 1);
    }

    @SubscribeEvent
    public void renderPlayerPre(RenderPlayerEvent.Pre event) {
        PlayerEntity player = event.getPlayer();
        if (player.func_184187_bx() instanceof EntityPlaneSoundBase) {
            EntityPlaneSoundBase plane = (EntityPlaneSoundBase)event.getPlayer().func_184187_bx();
            event.getMatrixStack().func_227860_a_();
            event.getMatrixStack().func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-(plane.field_70126_B + (plane.field_70177_z - plane.field_70126_B) * event.getPartialRenderTick())));
            event.getMatrixStack().func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(plane.field_70127_C + (plane.field_70125_A - plane.field_70127_C) * event.getPartialRenderTick()));
            List passengers = plane.func_184188_bt();
            int i = passengers.indexOf(player);
            if (i >= 0) {
                Vector3d offset = plane.getPlayerOffsets()[i];
                offset = offset.func_178789_a((float)(-Math.toRadians(plane.field_70125_A)));
                event.getMatrixStack().func_227861_a_(0.0, offset.field_72448_b, 0.0);
            }
            event.getMatrixStack().func_227862_a_(plane.getPlayerScaleFactor(), plane.getPlayerScaleFactor(), plane.getPlayerScaleFactor());
            event.getMatrixStack().func_227861_a_(0.0, (double)((player.func_213302_cg() - player.func_213302_cg() * plane.getPlayerScaleFactor()) / 1.5f + (float)plane.getPlayerOffsets()[0].field_72448_b), 0.0);
            event.getMatrixStack().func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(plane.field_70126_B + (plane.field_70177_z - plane.field_70126_B) * event.getPartialRenderTick()));
        }
    }

    @SubscribeEvent
    public void renderPlayerPost(RenderPlayerEvent.Post event) {
        if (event.getPlayer().func_184187_bx() instanceof EntityPlaneSoundBase) {
            event.getMatrixStack().func_227865_b_();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (!evt.player.equals((Object)this.mc.field_71439_g)) {
            return;
        }
        EntityPlaneSoundBase vehicle = this.getPlane();
        if (vehicle != null && evt.player.equals((Object)vehicle.getDriver())) {
            this.cachedRelativeHeight = this.getRelativeHeight(vehicle);
        }
        if (vehicle != null && this.lastVehicle == null) {
            this.mc.field_71474_y.func_243229_a(PointOfView.THIRD_PERSON_BACK);
        } else if (vehicle == null && this.lastVehicle != null) {
            this.mc.field_71474_y.func_243229_a(PointOfView.FIRST_PERSON);
        }
        this.lastVehicle = vehicle;
    }

    private EntityPlaneSoundBase getPlane() {
        if (this.mc.field_71439_g.func_184187_bx() instanceof EntityPlaneSoundBase) {
            return (EntityPlaneSoundBase)this.mc.field_71439_g.func_184187_bx();
        }
        return null;
    }
}

