/*
 * Decompiled with CFR 0.152.
 */
package com.tm.playingcards.entity.base;

import com.tm.playingcards.entity.data.PCDataSerializers;
import com.tm.playingcards.util.ArrayHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class EntityStacked
extends Entity {
    public static final byte MAX_STACK_SIZE = 52;
    protected static final DataParameter<Byte[]> STACK = EntityDataManager.func_187226_a(EntityStacked.class, PCDataSerializers.STACK);

    public EntityStacked(EntityType<? extends EntityStacked> type, World world) {
        super(type, world);
    }

    public EntityStacked(EntityType<? extends EntityStacked> type, World world, Vector3d position) {
        this(type, world);
        this.func_70012_b(position.field_72450_a, position.field_72448_b, position.field_72449_c, 0.0f, 0.0f);
    }

    public int getStackAmount() {
        return ((Byte[])this.field_70180_af.func_187225_a(STACK)).length;
    }

    public byte getTopStackID() {
        return this.getIDAt(this.getStackAmount() - 1);
    }

    public byte getIDAt(int index) {
        if (index >= 0 && index < this.getStackAmount()) {
            return ((Byte[])this.field_70180_af.func_187225_a(STACK))[index];
        }
        return 0;
    }

    public void removeFromTop() {
        Byte[] newStack = new Byte[this.getStackAmount() - 1];
        for (int index = 0; index < newStack.length; ++index) {
            newStack[index] = ((Byte[])this.field_70180_af.func_187225_a(STACK))[index];
        }
        this.field_70180_af.func_187227_b(STACK, (Object)newStack);
    }

    public void addToTop(byte id) {
        Byte[] newStack = new Byte[this.getStackAmount() + 1];
        for (int index = 0; index < this.getStackAmount(); ++index) {
            newStack[index] = ((Byte[])this.field_70180_af.func_187225_a(STACK))[index];
        }
        newStack[newStack.length - 1] = id;
        this.field_70180_af.func_187227_b(STACK, (Object)newStack);
    }

    public void createStack() {
        Byte[] newStack = new Byte[]{};
        this.field_70180_af.func_187227_b(STACK, (Object)newStack);
    }

    public void shuffleStack() {
        Object[] newStack = new Byte[this.getStackAmount()];
        for (int index = 0; index < this.getStackAmount(); ++index) {
            newStack[index] = ((Byte[])this.field_70180_af.func_187225_a(STACK))[index];
        }
        ArrayHelper.shuffle(newStack);
        this.field_70180_af.func_187227_b(STACK, (Object)newStack);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.field_70145_X = false;
        } else {
            boolean bl = this.field_70145_X = !this.field_70170_p.func_226669_j_((Entity)this);
            if (this.field_70145_X) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.02, 0.0));
            } else {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
            }
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        Vector3d pos = this.func_213303_ch();
        double size = 0.2;
        double addAmount = 0.0045;
        this.func_174826_a(new AxisAlignedBB(pos.field_72450_a - size, pos.field_72448_b, pos.field_72449_c - size, pos.field_72450_a + size, pos.field_72448_b + 0.03 + addAmount * (double)this.getStackAmount(), pos.field_72449_c + size));
    }

    public abstract void moreData();

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(STACK, (Object)new Byte[0]);
        this.moreData();
    }

    protected void func_70037_a(CompoundNBT nbt) {
        this.field_70180_af.func_187227_b(STACK, (Object)ArrayHelper.toObject(nbt.func_74770_j("Stack")));
    }

    protected void func_213281_b(CompoundNBT nbt) {
        nbt.func_74773_a("Stack", ArrayHelper.toPrimitive((Byte[])this.field_70180_af.func_187225_a(STACK)));
    }

    public boolean func_70067_L() {
        return true;
    }
}

