/*
 * Decompiled with CFR 0.152.
 */
package com.tm.playingcards.util;

import java.util.Random;

public class ArrayHelper {
    public static byte[] toPrimitive(Byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new byte[0];
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Byte[] toObject(byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new Byte[0];
        }
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static <T> T[] clone(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static void shuffle(Object[] array) {
        Random random = new Random();
        for (int i = array.length; i > 1; --i) {
            ArrayHelper.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    private static void swap(Object[] array, int offset1, int offset2, int length) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        length = Math.min(Math.min(length, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < length) {
            Object aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }
}

