/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.lua;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaValues;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Nullable;

public interface LuaTable<K, V>
extends Map<K, V> {
    default public int length() {
        int size = 0;
        while (this.containsKey(size + 1)) {
            ++size;
        }
        return size;
    }

    default public long getLong(int index) throws LuaException {
        Object value = this.get(index);
        if (!(value instanceof Number)) {
            throw LuaValues.badTableItem(index, "number", LuaValues.getType(value));
        }
        Number number = (Number)value;
        double asDouble = number.doubleValue();
        if (!Double.isFinite(asDouble)) {
            throw LuaValues.badTableItem(index, "number", LuaValues.getNumericType(asDouble));
        }
        return number.longValue();
    }

    default public long getLong(String key) throws LuaException {
        Object value = this.get(key);
        if (!(value instanceof Number)) {
            throw LuaValues.badField(key, "number", LuaValues.getType(value));
        }
        Number number = (Number)value;
        double asDouble = number.doubleValue();
        if (!Double.isFinite(asDouble)) {
            throw LuaValues.badField(key, "number", LuaValues.getNumericType(asDouble));
        }
        return number.longValue();
    }

    default public int getInt(int index) throws LuaException {
        return (int)this.getLong(index);
    }

    default public int getInt(String key) throws LuaException {
        return (int)this.getLong(key);
    }

    @Override
    @Nullable
    default public V put(K o, V o2) {
        throw new UnsupportedOperationException("Cannot modify LuaTable");
    }

    @Override
    default public V remove(Object o) {
        throw new UnsupportedOperationException("Cannot modify LuaTable");
    }

    @Override
    default public void putAll(@Nonnull Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException("Cannot modify LuaTable");
    }

    @Override
    default public void clear() {
        throw new UnsupportedOperationException("Cannot modify LuaTable");
    }
}

