/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.command.arguments.ArgumentSerializers;
import dan200.computercraft.shared.common.ColourableRecipe;
import dan200.computercraft.shared.common.ContainerHeldItem;
import dan200.computercraft.shared.common.DefaultBundledRedstoneProvider;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.computer.blocks.BlockComputer;
import dan200.computercraft.shared.computer.blocks.TileCommandComputer;
import dan200.computercraft.shared.computer.blocks.TileComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import dan200.computercraft.shared.computer.inventory.ContainerViewComputer;
import dan200.computercraft.shared.computer.items.ItemComputer;
import dan200.computercraft.shared.computer.recipe.ComputerUpgradeRecipe;
import dan200.computercraft.shared.data.BlockNamedEntityLootCondition;
import dan200.computercraft.shared.data.HasComputerIdLootCondition;
import dan200.computercraft.shared.data.PlayerCreativeLootCondition;
import dan200.computercraft.shared.integration.morered.MoreRedIntegration;
import dan200.computercraft.shared.media.items.ItemDisk;
import dan200.computercraft.shared.media.items.ItemPrintout;
import dan200.computercraft.shared.media.items.ItemTreasureDisk;
import dan200.computercraft.shared.media.items.RecordMedia;
import dan200.computercraft.shared.media.recipes.DiskRecipe;
import dan200.computercraft.shared.media.recipes.PrintoutRecipe;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.network.container.HeldItemContainerData;
import dan200.computercraft.shared.network.container.ViewComputerContainerData;
import dan200.computercraft.shared.peripheral.diskdrive.BlockDiskDrive;
import dan200.computercraft.shared.peripheral.diskdrive.ContainerDiskDrive;
import dan200.computercraft.shared.peripheral.diskdrive.TileDiskDrive;
import dan200.computercraft.shared.peripheral.generic.methods.EnergyMethods;
import dan200.computercraft.shared.peripheral.generic.methods.FluidMethods;
import dan200.computercraft.shared.peripheral.generic.methods.InventoryMethods;
import dan200.computercraft.shared.peripheral.modem.wired.BlockCable;
import dan200.computercraft.shared.peripheral.modem.wired.BlockWiredModemFull;
import dan200.computercraft.shared.peripheral.modem.wired.ItemBlockCable;
import dan200.computercraft.shared.peripheral.modem.wired.TileCable;
import dan200.computercraft.shared.peripheral.modem.wired.TileWiredModemFull;
import dan200.computercraft.shared.peripheral.modem.wireless.BlockWirelessModem;
import dan200.computercraft.shared.peripheral.modem.wireless.TileWirelessModem;
import dan200.computercraft.shared.peripheral.monitor.BlockMonitor;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.peripheral.printer.BlockPrinter;
import dan200.computercraft.shared.peripheral.printer.ContainerPrinter;
import dan200.computercraft.shared.peripheral.printer.TilePrinter;
import dan200.computercraft.shared.peripheral.speaker.BlockSpeaker;
import dan200.computercraft.shared.peripheral.speaker.TileSpeaker;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.pocket.peripherals.PocketModem;
import dan200.computercraft.shared.pocket.peripherals.PocketSpeaker;
import dan200.computercraft.shared.pocket.recipes.PocketComputerUpgradeRecipe;
import dan200.computercraft.shared.turtle.blocks.BlockTurtle;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.turtle.inventory.ContainerTurtle;
import dan200.computercraft.shared.turtle.items.ItemTurtle;
import dan200.computercraft.shared.turtle.recipes.TurtleRecipe;
import dan200.computercraft.shared.turtle.recipes.TurtleUpgradeRecipe;
import dan200.computercraft.shared.turtle.upgrades.TurtleAxe;
import dan200.computercraft.shared.turtle.upgrades.TurtleCraftingTable;
import dan200.computercraft.shared.turtle.upgrades.TurtleHoe;
import dan200.computercraft.shared.turtle.upgrades.TurtleModem;
import dan200.computercraft.shared.turtle.upgrades.TurtleShovel;
import dan200.computercraft.shared.turtle.upgrades.TurtleSpeaker;
import dan200.computercraft.shared.turtle.upgrades.TurtleSword;
import dan200.computercraft.shared.turtle.upgrades.TurtleTool;
import dan200.computercraft.shared.util.CreativeTabMain;
import dan200.computercraft.shared.util.FixedPointTileEntityType;
import dan200.computercraft.shared.util.ImpostorRecipe;
import dan200.computercraft.shared.util.ImpostorShapelessRecipe;
import dan200.computercraft.shared.util.NullStorage;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="computercraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Registry {
    private static final ItemGroup mainItemGroup = new CreativeTabMain();

    private Registry() {
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Registry.registerTurtleUpgrades();
        Registry.registerPocketUpgrades();
    }

    private static void registerTurtleUpgrades() {
        ComputerCraft.TurtleUpgrades.wirelessModemNormal = new TurtleModem(false, new ResourceLocation("computercraft", "wireless_modem_normal"));
        ComputerCraftAPI.registerTurtleUpgrade(ComputerCraft.TurtleUpgrades.wirelessModemNormal);
        ComputerCraft.TurtleUpgrades.wirelessModemAdvanced = new TurtleModem(true, new ResourceLocation("computercraft", "wireless_modem_advanced"));
        ComputerCraftAPI.registerTurtleUpgrade(ComputerCraft.TurtleUpgrades.wirelessModemAdvanced);
        ComputerCraft.TurtleUpgrades.speaker = new TurtleSpeaker(new ResourceLocation("computercraft", "speaker"));
        ComputerCraftAPI.registerTurtleUpgrade(ComputerCraft.TurtleUpgrades.speaker);
        ComputerCraft.TurtleUpgrades.craftingTable = new TurtleCraftingTable(new ResourceLocation("minecraft", "crafting_table"));
        ComputerCraftAPI.registerTurtleUpgrade(ComputerCraft.TurtleUpgrades.craftingTable);
        ComputerCraft.TurtleUpgrades.diamondSword = new TurtleSword(new ResourceLocation("minecraft", "diamond_sword"), Items.field_151048_u);
        ComputerCraftAPI.registerTurtleUpgrade(ComputerCraft.TurtleUpgrades.diamondSword);
        ComputerCraft.TurtleUpgrades.diamondShovel = new TurtleShovel(new ResourceLocation("minecraft", "diamond_shovel"), Items.field_151047_v);
        ComputerCraftAPI.registerTurtleUpgrade(ComputerCraft.TurtleUpgrades.diamondShovel);
        ComputerCraft.TurtleUpgrades.diamondPickaxe = new TurtleTool(new ResourceLocation("minecraft", "diamond_pickaxe"), Items.field_151046_w);
        ComputerCraftAPI.registerTurtleUpgrade(ComputerCraft.TurtleUpgrades.diamondPickaxe);
        ComputerCraft.TurtleUpgrades.diamondAxe = new TurtleAxe(new ResourceLocation("minecraft", "diamond_axe"), Items.field_151056_x);
        ComputerCraftAPI.registerTurtleUpgrade(ComputerCraft.TurtleUpgrades.diamondAxe);
        ComputerCraft.TurtleUpgrades.diamondHoe = new TurtleHoe(new ResourceLocation("minecraft", "diamond_hoe"), Items.field_151012_L);
        ComputerCraftAPI.registerTurtleUpgrade(ComputerCraft.TurtleUpgrades.diamondHoe);
    }

    private static void registerPocketUpgrades() {
        ComputerCraft.PocketUpgrades.wirelessModemNormal = new PocketModem(false);
        ComputerCraftAPI.registerPocketUpgrade(ComputerCraft.PocketUpgrades.wirelessModemNormal);
        ComputerCraft.PocketUpgrades.wirelessModemAdvanced = new PocketModem(true);
        ComputerCraftAPI.registerPocketUpgrade(ComputerCraft.PocketUpgrades.wirelessModemAdvanced);
        ComputerCraft.PocketUpgrades.speaker = new PocketSpeaker();
        ComputerCraftAPI.registerPocketUpgrade(ComputerCraft.PocketUpgrades.speaker);
    }

    @SubscribeEvent
    public static void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new IRecipeSerializer[]{(IRecipeSerializer)ColourableRecipe.SERIALIZER.setRegistryName(new ResourceLocation("computercraft", "colour")), (IRecipeSerializer)ComputerUpgradeRecipe.SERIALIZER.setRegistryName(new ResourceLocation("computercraft", "computer_upgrade")), (IRecipeSerializer)PocketComputerUpgradeRecipe.SERIALIZER.setRegistryName(new ResourceLocation("computercraft", "pocket_computer_upgrade")), (IRecipeSerializer)DiskRecipe.SERIALIZER.setRegistryName(new ResourceLocation("computercraft", "disk")), (IRecipeSerializer)PrintoutRecipe.SERIALIZER.setRegistryName(new ResourceLocation("computercraft", "printout")), (IRecipeSerializer)TurtleRecipe.SERIALIZER.setRegistryName(new ResourceLocation("computercraft", "turtle")), (IRecipeSerializer)TurtleUpgradeRecipe.SERIALIZER.setRegistryName(new ResourceLocation("computercraft", "turtle_upgrade")), (IRecipeSerializer)ImpostorShapelessRecipe.SERIALIZER.setRegistryName(new ResourceLocation("computercraft", "impostor_shapeless")), (IRecipeSerializer)ImpostorRecipe.SERIALIZER.setRegistryName(new ResourceLocation("computercraft", "impostor_shaped"))});
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        NetworkHandler.setup();
        DeferredWorkQueue.runLater(() -> {
            Registry.registerProviders();
            ArgumentSerializers.register();
            Registry.registerLoot();
        });
        ComputerCraftAPI.registerGenericSource(new InventoryMethods());
        ComputerCraftAPI.registerGenericSource(new FluidMethods());
        ComputerCraftAPI.registerGenericSource(new EnergyMethods());
    }

    private static void registerProviders() {
        ComputerCraftAPI.registerBundledRedstoneProvider(new DefaultBundledRedstoneProvider());
        ComputerCraftAPI.registerMediaProvider(stack -> {
            Item item = stack.func_77973_b();
            if (item instanceof IMedia) {
                return (IMedia)item;
            }
            if (item instanceof MusicDiscItem) {
                return RecordMedia.INSTANCE;
            }
            return null;
        });
        CapabilityManager.INSTANCE.register(IWiredElement.class, new NullStorage(), () -> null);
        CapabilityManager.INSTANCE.register(IPeripheral.class, new NullStorage(), () -> null);
        ComputerCraftAPI.registerGenericCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        ComputerCraftAPI.registerGenericCapability(CapabilityEnergy.ENERGY);
        ComputerCraftAPI.registerGenericCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        if (ModList.get().isLoaded("morered")) {
            MoreRedIntegration.initialise();
        }
    }

    public static void registerLoot() {
        Registry.registerCondition("block_named", BlockNamedEntityLootCondition.TYPE);
        Registry.registerCondition("player_creative", PlayerCreativeLootCondition.TYPE);
        Registry.registerCondition("has_id", HasComputerIdLootCondition.TYPE);
    }

    private static void registerCondition(String name, LootConditionType serializer) {
        net.minecraft.util.registry.Registry.func_218322_a((net.minecraft.util.registry.Registry)net.minecraft.util.registry.Registry.field_239704_ba_, (ResourceLocation)new ResourceLocation("computercraft", name), (Object)serializer);
    }

    public static void setup() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.BLOCKS.register(bus);
        ModTiles.TILES.register(bus);
        ModItems.ITEMS.register(bus);
        ModEntities.ENTITIES.register(bus);
        ModContainers.CONTAINERS.register(bus);
    }

    public static class ModContainers {
        static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"computercraft");
        public static final RegistryObject<ContainerType<ContainerComputerBase>> COMPUTER = CONTAINERS.register("computer", () -> ContainerData.toType(ComputerContainerData::new, ComputerMenuWithoutInventory::new));
        public static final RegistryObject<ContainerType<ContainerComputerBase>> POCKET_COMPUTER = CONTAINERS.register("pocket_computer", () -> ContainerData.toType(ComputerContainerData::new, ComputerMenuWithoutInventory::new));
        public static final RegistryObject<ContainerType<ContainerComputerBase>> POCKET_COMPUTER_NO_TERM = CONTAINERS.register("pocket_computer_no_term", () -> ContainerData.toType(ComputerContainerData::new, ComputerMenuWithoutInventory::new));
        public static final RegistryObject<ContainerType<ContainerTurtle>> TURTLE = CONTAINERS.register("turtle", () -> ContainerData.toType(ComputerContainerData::new, ContainerTurtle::new));
        public static final RegistryObject<ContainerType<ContainerDiskDrive>> DISK_DRIVE = CONTAINERS.register("disk_drive", () -> new ContainerType(ContainerDiskDrive::new));
        public static final RegistryObject<ContainerType<ContainerPrinter>> PRINTER = CONTAINERS.register("printer", () -> new ContainerType(ContainerPrinter::new));
        public static final RegistryObject<ContainerType<ContainerHeldItem>> PRINTOUT = CONTAINERS.register("printout", () -> ContainerData.toType(HeldItemContainerData::new, ContainerHeldItem::createPrintout));
        public static final RegistryObject<ContainerType<ContainerViewComputer>> VIEW_COMPUTER = CONTAINERS.register("view_computer", () -> ContainerData.toType(ViewComputerContainerData::new, ContainerViewComputer::new));
    }

    public static class ModEntities {
        static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"computercraft");
        public static final RegistryObject<EntityType<TurtlePlayer>> TURTLE_PLAYER = ENTITIES.register("turtle_player", () -> EntityType.Builder.func_220319_a((EntityClassification)EntityClassification.MISC).func_200706_c().func_200705_b().func_220321_a(0.0f, 0.0f).func_206830_a("computercraft:turtle_player"));
    }

    public static final class ModItems {
        static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"computercraft");
        public static final RegistryObject<ItemComputer> COMPUTER_NORMAL = ModItems.ofBlock(ModBlocks.COMPUTER_NORMAL, ItemComputer::new);
        public static final RegistryObject<ItemComputer> COMPUTER_ADVANCED = ModItems.ofBlock(ModBlocks.COMPUTER_ADVANCED, ItemComputer::new);
        public static final RegistryObject<ItemComputer> COMPUTER_COMMAND = ModItems.ofBlock(ModBlocks.COMPUTER_COMMAND, ItemComputer::new);
        public static final RegistryObject<ItemPocketComputer> POCKET_COMPUTER_NORMAL = ITEMS.register("pocket_computer_normal", () -> new ItemPocketComputer(ModItems.properties().func_200917_a(1), ComputerFamily.NORMAL));
        public static final RegistryObject<ItemPocketComputer> POCKET_COMPUTER_ADVANCED = ITEMS.register("pocket_computer_advanced", () -> new ItemPocketComputer(ModItems.properties().func_200917_a(1), ComputerFamily.ADVANCED));
        public static final RegistryObject<ItemTurtle> TURTLE_NORMAL = ModItems.ofBlock(ModBlocks.TURTLE_NORMAL, ItemTurtle::new);
        public static final RegistryObject<ItemTurtle> TURTLE_ADVANCED = ModItems.ofBlock(ModBlocks.TURTLE_ADVANCED, ItemTurtle::new);
        public static final RegistryObject<ItemDisk> DISK = ITEMS.register("disk", () -> new ItemDisk(ModItems.properties().func_200917_a(1)));
        public static final RegistryObject<ItemTreasureDisk> TREASURE_DISK = ITEMS.register("treasure_disk", () -> new ItemTreasureDisk(ModItems.properties().func_200917_a(1)));
        public static final RegistryObject<ItemPrintout> PRINTED_PAGE = ITEMS.register("printed_page", () -> new ItemPrintout(ModItems.properties().func_200917_a(1), ItemPrintout.Type.PAGE));
        public static final RegistryObject<ItemPrintout> PRINTED_PAGES = ITEMS.register("printed_pages", () -> new ItemPrintout(ModItems.properties().func_200917_a(1), ItemPrintout.Type.PAGES));
        public static final RegistryObject<ItemPrintout> PRINTED_BOOK = ITEMS.register("printed_book", () -> new ItemPrintout(ModItems.properties().func_200917_a(1), ItemPrintout.Type.BOOK));
        public static final RegistryObject<BlockItem> SPEAKER = ModItems.ofBlock(ModBlocks.SPEAKER, BlockItem::new);
        public static final RegistryObject<BlockItem> DISK_DRIVE = ModItems.ofBlock(ModBlocks.DISK_DRIVE, BlockItem::new);
        public static final RegistryObject<BlockItem> PRINTER = ModItems.ofBlock(ModBlocks.PRINTER, BlockItem::new);
        public static final RegistryObject<BlockItem> MONITOR_NORMAL = ModItems.ofBlock(ModBlocks.MONITOR_NORMAL, BlockItem::new);
        public static final RegistryObject<BlockItem> MONITOR_ADVANCED = ModItems.ofBlock(ModBlocks.MONITOR_ADVANCED, BlockItem::new);
        public static final RegistryObject<BlockItem> WIRELESS_MODEM_NORMAL = ModItems.ofBlock(ModBlocks.WIRELESS_MODEM_NORMAL, BlockItem::new);
        public static final RegistryObject<BlockItem> WIRELESS_MODEM_ADVANCED = ModItems.ofBlock(ModBlocks.WIRELESS_MODEM_ADVANCED, BlockItem::new);
        public static final RegistryObject<BlockItem> WIRED_MODEM_FULL = ModItems.ofBlock(ModBlocks.WIRED_MODEM_FULL, BlockItem::new);
        public static final RegistryObject<ItemBlockCable.Cable> CABLE = ITEMS.register("cable", () -> new ItemBlockCable.Cable((BlockCable)ModBlocks.CABLE.get(), ModItems.properties()));
        public static final RegistryObject<ItemBlockCable.WiredModem> WIRED_MODEM = ITEMS.register("wired_modem", () -> new ItemBlockCable.WiredModem((BlockCable)ModBlocks.CABLE.get(), ModItems.properties()));

        private static Item.Properties properties() {
            return new Item.Properties().func_200916_a(mainItemGroup);
        }

        private static <B extends Block, I extends Item> RegistryObject<I> ofBlock(RegistryObject<B> parent, BiFunction<B, Item.Properties, I> supplier) {
            return ITEMS.register(parent.getId().func_110623_a(), () -> (Item)supplier.apply(parent.get(), ModItems.properties()));
        }
    }

    public static class ModTiles {
        static final DeferredRegister<TileEntityType<?>> TILES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"computercraft");
        public static final RegistryObject<TileEntityType<TileMonitor>> MONITOR_NORMAL = ModTiles.ofBlock(ModBlocks.MONITOR_NORMAL, f -> new TileMonitor((TileEntityType<? extends TileMonitor>)f, false));
        public static final RegistryObject<TileEntityType<TileMonitor>> MONITOR_ADVANCED = ModTiles.ofBlock(ModBlocks.MONITOR_ADVANCED, f -> new TileMonitor((TileEntityType<? extends TileMonitor>)f, true));
        public static final RegistryObject<TileEntityType<TileComputer>> COMPUTER_NORMAL = ModTiles.ofBlock(ModBlocks.COMPUTER_NORMAL, f -> new TileComputer(ComputerFamily.NORMAL, (TileEntityType<? extends TileComputer>)f));
        public static final RegistryObject<TileEntityType<TileComputer>> COMPUTER_ADVANCED = ModTiles.ofBlock(ModBlocks.COMPUTER_ADVANCED, f -> new TileComputer(ComputerFamily.ADVANCED, (TileEntityType<? extends TileComputer>)f));
        public static final RegistryObject<TileEntityType<TileCommandComputer>> COMPUTER_COMMAND = ModTiles.ofBlock(ModBlocks.COMPUTER_COMMAND, f -> new TileCommandComputer(ComputerFamily.COMMAND, (TileEntityType<? extends TileCommandComputer>)f));
        public static final RegistryObject<TileEntityType<TileTurtle>> TURTLE_NORMAL = ModTiles.ofBlock(ModBlocks.TURTLE_NORMAL, f -> new TileTurtle((TileEntityType<? extends TileGeneric>)f, ComputerFamily.NORMAL));
        public static final RegistryObject<TileEntityType<TileTurtle>> TURTLE_ADVANCED = ModTiles.ofBlock(ModBlocks.TURTLE_ADVANCED, f -> new TileTurtle((TileEntityType<? extends TileGeneric>)f, ComputerFamily.ADVANCED));
        public static final RegistryObject<TileEntityType<TileSpeaker>> SPEAKER = ModTiles.ofBlock(ModBlocks.SPEAKER, TileSpeaker::new);
        public static final RegistryObject<TileEntityType<TileDiskDrive>> DISK_DRIVE = ModTiles.ofBlock(ModBlocks.DISK_DRIVE, TileDiskDrive::new);
        public static final RegistryObject<TileEntityType<TilePrinter>> PRINTER = ModTiles.ofBlock(ModBlocks.PRINTER, TilePrinter::new);
        public static final RegistryObject<TileEntityType<TileWiredModemFull>> WIRED_MODEM_FULL = ModTiles.ofBlock(ModBlocks.WIRED_MODEM_FULL, TileWiredModemFull::new);
        public static final RegistryObject<TileEntityType<TileCable>> CABLE = ModTiles.ofBlock(ModBlocks.CABLE, TileCable::new);
        public static final RegistryObject<TileEntityType<TileWirelessModem>> WIRELESS_MODEM_NORMAL = ModTiles.ofBlock(ModBlocks.WIRELESS_MODEM_NORMAL, f -> new TileWirelessModem((TileEntityType<? extends TileWirelessModem>)f, false));
        public static final RegistryObject<TileEntityType<TileWirelessModem>> WIRELESS_MODEM_ADVANCED = ModTiles.ofBlock(ModBlocks.WIRELESS_MODEM_ADVANCED, f -> new TileWirelessModem((TileEntityType<? extends TileWirelessModem>)f, true));

        private static <T extends TileEntity> RegistryObject<TileEntityType<T>> ofBlock(RegistryObject<? extends Block> block, Function<TileEntityType<T>, T> factory) {
            return TILES.register(block.getId().func_110623_a(), () -> FixedPointTileEntityType.create((Supplier<? extends Block>)block, factory));
        }
    }

    public static final class ModBlocks {
        static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"computercraft");
        public static final RegistryObject<BlockComputer> COMPUTER_NORMAL = BLOCKS.register("computer_normal", () -> new BlockComputer(ModBlocks.properties(), ComputerFamily.NORMAL, (RegistryObject<? extends TileEntityType<? extends TileComputer>>)ModTiles.COMPUTER_NORMAL));
        public static final RegistryObject<BlockComputer> COMPUTER_ADVANCED = BLOCKS.register("computer_advanced", () -> new BlockComputer(ModBlocks.properties(), ComputerFamily.ADVANCED, (RegistryObject<? extends TileEntityType<? extends TileComputer>>)ModTiles.COMPUTER_ADVANCED));
        public static final RegistryObject<BlockComputer> COMPUTER_COMMAND = BLOCKS.register("computer_command", () -> new BlockComputer(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(-1.0f, 6000000.0f), ComputerFamily.COMMAND, (RegistryObject<? extends TileEntityType<? extends TileComputer>>)ModTiles.COMPUTER_COMMAND));
        public static final RegistryObject<BlockTurtle> TURTLE_NORMAL = BLOCKS.register("turtle_normal", () -> new BlockTurtle(ModBlocks.turtleProperties(), ComputerFamily.NORMAL, (RegistryObject<? extends TileEntityType<? extends TileTurtle>>)ModTiles.TURTLE_NORMAL));
        public static final RegistryObject<BlockTurtle> TURTLE_ADVANCED = BLOCKS.register("turtle_advanced", () -> new BlockTurtle(ModBlocks.turtleProperties(), ComputerFamily.ADVANCED, (RegistryObject<? extends TileEntityType<? extends TileTurtle>>)ModTiles.TURTLE_ADVANCED));
        public static final RegistryObject<BlockSpeaker> SPEAKER = BLOCKS.register("speaker", () -> new BlockSpeaker(ModBlocks.properties()));
        public static final RegistryObject<BlockDiskDrive> DISK_DRIVE = BLOCKS.register("disk_drive", () -> new BlockDiskDrive(ModBlocks.properties()));
        public static final RegistryObject<BlockPrinter> PRINTER = BLOCKS.register("printer", () -> new BlockPrinter(ModBlocks.properties()));
        public static final RegistryObject<BlockMonitor> MONITOR_NORMAL = BLOCKS.register("monitor_normal", () -> new BlockMonitor(ModBlocks.properties(), (RegistryObject<? extends TileEntityType<? extends TileMonitor>>)ModTiles.MONITOR_NORMAL));
        public static final RegistryObject<BlockMonitor> MONITOR_ADVANCED = BLOCKS.register("monitor_advanced", () -> new BlockMonitor(ModBlocks.properties(), (RegistryObject<? extends TileEntityType<? extends TileMonitor>>)ModTiles.MONITOR_ADVANCED));
        public static final RegistryObject<BlockWirelessModem> WIRELESS_MODEM_NORMAL = BLOCKS.register("wireless_modem_normal", () -> new BlockWirelessModem(ModBlocks.properties(), (RegistryObject<? extends TileEntityType<? extends TileWirelessModem>>)ModTiles.WIRELESS_MODEM_NORMAL));
        public static final RegistryObject<BlockWirelessModem> WIRELESS_MODEM_ADVANCED = BLOCKS.register("wireless_modem_advanced", () -> new BlockWirelessModem(ModBlocks.properties(), (RegistryObject<? extends TileEntityType<? extends TileWirelessModem>>)ModTiles.WIRELESS_MODEM_ADVANCED));
        public static final RegistryObject<BlockWiredModemFull> WIRED_MODEM_FULL = BLOCKS.register("wired_modem_full", () -> new BlockWiredModemFull(ModBlocks.modemProperties()));
        public static final RegistryObject<BlockCable> CABLE = BLOCKS.register("cable", () -> new BlockCable(ModBlocks.modemProperties()));

        private static AbstractBlock.Properties properties() {
            return AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(2.0f);
        }

        private static AbstractBlock.Properties turtleProperties() {
            return AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(2.5f);
        }

        private static AbstractBlock.Properties modemProperties() {
            return AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.5f);
        }
    }
}

