/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.client.SoundManager;
import dan200.computercraft.shared.network.NetworkMessage;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class SpeakerPlayClientMessage
implements NetworkMessage {
    private final UUID source;
    private final Vector3d pos;
    private final ResourceLocation sound;
    private final float volume;
    private final float pitch;

    public SpeakerPlayClientMessage(UUID source, Vector3d pos, ResourceLocation event, float volume, float pitch) {
        this.source = source;
        this.pos = pos;
        this.sound = event;
        this.volume = volume;
        this.pitch = pitch;
    }

    public SpeakerPlayClientMessage(PacketBuffer buf) {
        this.source = buf.func_179253_g();
        this.pos = new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.sound = buf.func_192575_l();
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
    }

    @Override
    public void toBytes(@Nonnull PacketBuffer buf) {
        buf.func_179252_a(this.source);
        buf.writeDouble(this.pos.func_82615_a());
        buf.writeDouble(this.pos.func_82617_b());
        buf.writeDouble(this.pos.func_82616_c());
        buf.func_192572_a(this.sound);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(NetworkEvent.Context context) {
        SoundManager.playSound(this.source, this.pos, this.sound, this.volume, this.pitch);
    }
}

