/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft")
public final class DropConsumer {
    private static Function<ItemStack, ItemStack> dropConsumer;
    private static List<ItemStack> remainingDrops;
    private static World dropWorld;
    private static AxisAlignedBB dropBounds;
    private static Entity dropEntity;

    private DropConsumer() {
    }

    public static void set(Entity entity, Function<ItemStack, ItemStack> consumer) {
        dropConsumer = consumer;
        remainingDrops = new ArrayList<ItemStack>();
        dropEntity = entity;
        dropWorld = entity.field_70170_p;
        dropBounds = new AxisAlignedBB(entity.func_233580_cy_()).func_72314_b(2.0, 2.0, 2.0);
    }

    public static void set(World world, BlockPos pos, Function<ItemStack, ItemStack> consumer) {
        dropConsumer = consumer;
        remainingDrops = new ArrayList<ItemStack>(2);
        dropEntity = null;
        dropWorld = world;
        dropBounds = new AxisAlignedBB(pos).func_72314_b(2.0, 2.0, 2.0);
    }

    public static List<ItemStack> clear() {
        List<ItemStack> remainingStacks = remainingDrops;
        dropConsumer = null;
        remainingDrops = null;
        dropEntity = null;
        dropWorld = null;
        dropBounds = null;
        return remainingStacks;
    }

    public static void clearAndDrop(World world, BlockPos pos, Direction direction) {
        List<ItemStack> remainingDrops = DropConsumer.clear();
        for (ItemStack remaining : remainingDrops) {
            WorldUtil.dropItemStack(remaining, world, pos, direction);
        }
    }

    private static void handleDrops(ItemStack stack) {
        ItemStack remaining = dropConsumer.apply(stack);
        if (!remaining.func_190926_b()) {
            remainingDrops.add(remaining);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntitySpawn(EntityJoinWorldEvent event) {
        if (dropWorld == event.getWorld() && event.getEntity() instanceof ItemEntity && dropBounds.func_72318_a(event.getEntity().func_213303_ch())) {
            DropConsumer.handleDrops(((ItemEntity)event.getEntity()).func_92059_d());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingDrops(LivingDropsEvent drops) {
        if (dropEntity == null || drops.getEntity() != dropEntity) {
            return;
        }
        for (ItemEntity drop : drops.getDrops()) {
            DropConsumer.handleDrops(drop.func_92059_d());
        }
        drops.getDrops().clear();
        drops.setCanceled(true);
    }
}

