/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.squiddev.cobalt.Lua;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.function.LuaClosure;

public class Print {
    public static final String[] OPNAMES = new String[]{"MOVE", "LOADK", "LOADBOOL", "LOADNIL", "GETUPVAL", "GETGLOBAL", "GETTABLE", "SETGLOBAL", "SETUPVAL", "SETTABLE", "NEWTABLE", "SELF", "ADD", "SUB", "MUL", "DIV", "MOD", "POW", "UNM", "NOT", "LEN", "CONCAT", "JMP", "EQ", "LT", "LE", "TEST", "TESTSET", "CALL", "TAILCALL", "RETURN", "FORLOOP", "FORPREP", "TFORLOOP", "SETLIST", "CLOSE", "CLOSURE", "VARARG", null};

    static void printString(PrintStream ps, LuaString s) {
        ps.print('\"');
        int n = s.length;
        block11: for (int i = 0; i < n; ++i) {
            byte c = s.bytes[s.offset + i];
            if (c >= 32 && c <= 126 && c != 34 && c != 92) {
                ps.print((char)c);
                continue;
            }
            switch (c) {
                case 34: {
                    ps.print("\\\"");
                    continue block11;
                }
                case 92: {
                    ps.print("\\\\");
                    continue block11;
                }
                case 7: {
                    ps.print("\\a");
                    continue block11;
                }
                case 8: {
                    ps.print("\\b");
                    continue block11;
                }
                case 12: {
                    ps.print("\\f");
                    continue block11;
                }
                case 9: {
                    ps.print("\\t");
                    continue block11;
                }
                case 13: {
                    ps.print("\\r");
                    continue block11;
                }
                case 10: {
                    ps.print("\\n");
                    continue block11;
                }
                case 11: {
                    ps.print("\\v");
                    continue block11;
                }
                default: {
                    ps.print('\\');
                    ps.print(Integer.toString(0x4E7 & c).substring(1));
                }
            }
        }
        ps.print('\"');
    }

    private static void printValue(PrintStream ps, LuaValue v) {
        switch (v.type()) {
            case 4: {
                Print.printString(ps, (LuaString)v);
                break;
            }
            default: {
                ps.print(v.toString());
            }
        }
    }

    private static void printConstant(PrintStream ps, Prototype f, int i) {
        Print.printValue(ps, f.k[i]);
    }

    public static void printCode(PrintStream ps, Prototype f) {
        int[] code = f.code;
        int n = code.length;
        for (int pc = 0; pc < n; ++pc) {
            Print.printOpcode(ps, f, pc);
            ps.println();
        }
    }

    public static void printOpcode(PrintStream ps, Prototype f, int pc) {
        int[] code = f.code;
        int i = code[pc];
        int o = Lua.GET_OPCODE(i);
        int a = Lua.GETARG_A(i);
        int b = Lua.GETARG_B(i);
        int c = Lua.GETARG_C(i);
        int bx = Lua.GETARG_Bx(i);
        int sbx = Lua.GETARG_sBx(i);
        int line = Print.getline(f, pc);
        ps.print("  " + (pc + 1) + "  ");
        if (line > 0) {
            ps.print("[" + line + "]  ");
        } else {
            ps.print("[-]  ");
        }
        ps.print(OPNAMES[o] + "  ");
        switch (Lua.getOpMode(o)) {
            case 0: {
                ps.print(a);
                if (Lua.getBMode(o) != 0) {
                    ps.print(" " + (Lua.ISK(b) ? -1 - Lua.INDEXK(b) : b));
                }
                if (Lua.getCMode(o) == 0) break;
                ps.print(" " + (Lua.ISK(c) ? -1 - Lua.INDEXK(c) : c));
                break;
            }
            case 1: {
                if (Lua.getBMode(o) == 3) {
                    ps.print(a + " " + (-1 - bx));
                    break;
                }
                ps.print(a + " " + bx);
                break;
            }
            case 2: {
                if (o == 22) {
                    ps.print(sbx);
                    break;
                }
                ps.print(a + " " + sbx);
            }
        }
        switch (o) {
            case 1: {
                ps.print("  ; ");
                Print.printConstant(ps, f, bx);
                break;
            }
            case 4: 
            case 8: {
                ps.print("  ; ");
                if (f.upvalues.length > b) {
                    Print.printValue(ps, f.upvalues[b]);
                    break;
                }
                ps.print("-");
                break;
            }
            case 5: 
            case 7: {
                ps.print("  ; ");
                Print.printConstant(ps, f, bx);
                break;
            }
            case 6: 
            case 11: {
                if (!Lua.ISK(c)) break;
                ps.print("  ; ");
                Print.printConstant(ps, f, Lua.INDEXK(c));
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 23: 
            case 24: 
            case 25: {
                if (!Lua.ISK(b) && !Lua.ISK(c)) break;
                ps.print("  ; ");
                if (Lua.ISK(b)) {
                    Print.printConstant(ps, f, Lua.INDEXK(b));
                } else {
                    ps.print("-");
                }
                ps.print(" ");
                if (Lua.ISK(c)) {
                    Print.printConstant(ps, f, Lua.INDEXK(c));
                    break;
                }
                ps.print("-");
                break;
            }
            case 22: 
            case 31: 
            case 32: {
                ps.print("  ; to " + (sbx + pc + 2));
                break;
            }
            case 36: {
                ps.print("  ; " + f.p[bx].getClass().getName());
                break;
            }
            case 34: {
                if (c == 0) {
                    ps.print("  ; " + code[++pc]);
                    break;
                }
                ps.print("  ; " + c);
                break;
            }
            case 37: {
                ps.print("  ; is_vararg=" + f.is_vararg);
                break;
            }
        }
    }

    private static int getline(Prototype f, int pc) {
        return pc > 0 && f.lineinfo != null && pc < f.lineinfo.length ? f.lineinfo[pc] : -1;
    }

    private static void printHeader(PrintStream ps, Prototype f) {
        String s = String.valueOf(f.source);
        s = s.startsWith("@") || s.startsWith("=") ? s.substring(1) : ("\u001bLua".equals(s) ? "(bstring)" : "(string)");
        String a = f.linedefined == 0 ? "main" : "function";
        ps.print("\n%" + a + " <" + s + ":" + f.linedefined + "," + f.lastlinedefined + "> (" + f.code.length + " instructions, " + f.code.length * 4 + " bytes at " + Print.id(f) + ")\n");
        ps.print(f.numparams + " param, " + f.maxstacksize + " slot, " + f.upvalues.length + " upvalue, ");
        ps.print(f.locvars.length + " local, " + f.k.length + " constant, " + f.p.length + " function\n");
    }

    private static void printConstants(PrintStream ps, Prototype f) {
        int n = f.k.length;
        ps.print("constants (" + n + ") for " + Print.id(f) + ":\n");
        for (int i = 0; i < n; ++i) {
            ps.print("  " + (i + 1) + "  ");
            Print.printValue(ps, f.k[i]);
            ps.print("\n");
        }
    }

    private static void printLocals(PrintStream ps, Prototype f) {
        int n = f.locvars.length;
        ps.print("locals (" + n + ") for " + Print.id(f) + ":\n");
        for (int i = 0; i < n; ++i) {
            ps.println("  " + i + "  " + f.locvars[i].name + " " + (f.locvars[i].startpc + 1) + " " + (f.locvars[i].endpc + 1));
        }
    }

    private static void printUpValues(PrintStream ps, Prototype f) {
        int n = f.upvalues.length;
        ps.print("upvalues (" + n + ") for " + Print.id(f) + ":\n");
        for (int i = 0; i < n; ++i) {
            ps.print("  " + i + "  " + f.upvalues[i] + "\n");
        }
    }

    public static String show(Prototype p) {
        return Print.showWith(ps -> Print.printFunction(ps, p, true));
    }

    public static void printFunction(PrintStream ps, Prototype f, boolean full) {
        int n = f.p.length;
        Print.printHeader(ps, f);
        Print.printCode(ps, f);
        if (full) {
            Print.printConstants(ps, f);
            Print.printLocals(ps, f);
            Print.printUpValues(ps, f);
        }
        for (int i = 0; i < n; ++i) {
            Print.printFunction(ps, f.p[i], full);
        }
    }

    private static void format(PrintStream ps, String s, int maxcols) {
        int n = s.length();
        if (n > maxcols) {
            ps.print(s.substring(0, maxcols));
        } else {
            ps.print(s);
            int i = maxcols - n;
            while (--i >= 0) {
                ps.print(' ');
            }
        }
    }

    private static String id(Prototype f) {
        return f.sourceShort() + ":" + f.linedefined;
    }

    public static void printState(PrintStream ps, LuaClosure cl, int pc, LuaValue[] stack, int top, Varargs varargs) {
        Print.format(ps, Print.showWith(p -> Print.printOpcode(p, cl.getPrototype(), pc)), 50);
        ps.print('[');
        for (int i = 0; i < stack.length; ++i) {
            LuaValue v = stack[i];
            if (v == null) {
                ps.print("null");
            } else {
                switch (v.type()) {
                    case 4: {
                        LuaString s = (LuaString)v;
                        ps.print(s.length() < 48 ? s.toString() : s.substring(0, 32).toString() + "...+" + (s.length() - 32) + "b");
                        break;
                    }
                    case 6: {
                        ps.print(v instanceof LuaClosure ? ((LuaClosure)v).getPrototype().toString() : v.toString());
                        break;
                    }
                    case 7: {
                        Object o = v.toUserdata();
                        if (o != null) {
                            String n = o.getClass().getName();
                            n = n.substring(n.lastIndexOf(46) + 1);
                            ps.print(n + ": " + Integer.toHexString(o.hashCode()));
                            break;
                        }
                        ps.print(v.toString());
                        break;
                    }
                    default: {
                        ps.print(v.toString());
                    }
                }
            }
            if (i + 1 == top) {
                ps.print(']');
            }
            ps.print(" | ");
        }
        ps.print(varargs);
        ps.println();
    }

    private static String showWith(Consumer<PrintStream> f) {
        PrintStream ps;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            ps = new PrintStream((OutputStream)output, false, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 should exist", e);
        }
        f.accept(ps);
        ps.flush();
        return new String(output.toByteArray(), StandardCharsets.UTF_8);
    }
}

