/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.cmd;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.Print;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.compiler.DumpState;
import org.squiddev.cobalt.compiler.LuaC;
import org.squiddev.cobalt.lib.jse.JsePlatform;

public class luac {
    private static final String version = "Luaj 0.0Copyright (C) 2009 luaj.org";
    private static final String usage = "usage: java -cp luaj-jse.jar org.squiddev.cobalt.cmd.luac [options] [filenames].\nAvailable options are:\n  -        process stdin\n  -l       list\n  -o name  output to file 'name' (default is \"org.squiddev.cobalt.cmd.luac.out\")\n  -p       parse only\n  -s       strip debug information\n  -E       big endian format for numbers\n  -i<n>    number format 'n', (n=0,1 or 4, default=0)\n  -v       show version information\n  --       stop handling options\n";
    private boolean list = false;
    private String output = "luac.out";
    private boolean parseonly = false;
    private boolean stripdebug = false;
    private boolean littleendian = true;
    private int numberformat = 0;
    private boolean versioninfo = false;
    private boolean processing = true;

    private static void usageExit() {
        System.out.println(usage);
        System.exit(-1);
    }

    public static void main(String[] args) throws IOException {
        new luac(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private luac(String[] args) throws IOException {
        try {
            block19: for (int i = 0; i < args.length; ++i) {
                if (!this.processing || !args[i].startsWith("-") || args[i].length() <= 1) continue;
                switch (args[i].charAt(1)) {
                    case 'l': {
                        this.list = true;
                        continue block19;
                    }
                    case 'o': {
                        if (++i >= args.length) {
                            luac.usageExit();
                        }
                        this.output = args[i];
                        continue block19;
                    }
                    case 'p': {
                        this.parseonly = true;
                        continue block19;
                    }
                    case 's': {
                        this.stripdebug = true;
                        continue block19;
                    }
                    case 'E': {
                        this.littleendian = false;
                        continue block19;
                    }
                    case 'i': {
                        if (args[i].length() <= 2) {
                            luac.usageExit();
                        }
                        this.numberformat = Integer.parseInt(args[i].substring(2));
                        continue block19;
                    }
                    case 'v': {
                        this.versioninfo = true;
                        continue block19;
                    }
                    case '-': {
                        if (args[i].length() > 2) {
                            luac.usageExit();
                        }
                        this.processing = false;
                        continue block19;
                    }
                    default: {
                        luac.usageExit();
                    }
                }
            }
            if (this.versioninfo) {
                System.out.println(version);
            }
            try (FileOutputStream fos = new FileOutputStream(this.output);){
                JsePlatform.standardGlobals(new LuaState());
                this.processing = true;
                block20: for (int i = 0; i < args.length; ++i) {
                    if (!this.processing || !args[i].startsWith("-")) {
                        this.processScript(new FileInputStream(args[i]), "@" + args[i], fos);
                        continue;
                    }
                    if (args[i].length() <= 1) {
                        this.processScript(System.in, "=stdin", fos);
                        continue;
                    }
                    switch (args[i].charAt(1)) {
                        case 'o': {
                            ++i;
                            continue block20;
                        }
                        case '-': {
                            this.processing = false;
                        }
                    }
                }
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
            System.exit(-2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processScript(InputStream script, String chunkname, OutputStream out) throws IOException {
        try {
            Prototype chunk = LuaC.compile(script, ValueFactory.valueOf(chunkname));
            if (this.list) {
                Print.printCode(System.out, chunk);
            }
            if (!this.parseonly) {
                DumpState.dump(chunk, out, this.stripdebug, this.numberformat, this.littleendian);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            script.close();
        }
    }
}

