/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.ChunkPos;

public class ChunkLoaderTile
extends TileEntity {
    public final int animationOffset = new Random().nextInt(20000);
    private int gridSize;
    private int radius;
    private boolean[][] grid;
    private boolean dataChanged = false;

    public ChunkLoaderTile(TileEntityType<?> tileEntityTypeIn, int gridSize) {
        super(tileEntityTypeIn);
        this.gridSize = gridSize;
        this.radius = (gridSize - 1) / 2;
        this.grid = new boolean[gridSize][gridSize];
    }

    public void unloadAll() {
        this.field_145850_b.getCapability(ChunkLoaderUtil.TRACKER_CAPABILITY).ifPresent(tracker -> {
            ChunkPos pos = this.field_145850_b.func_217349_x(this.field_174879_c).func_76632_l();
            for (int x = 0; x < this.gridSize; ++x) {
                for (int z = 0; z < this.gridSize; ++z) {
                    if (!this.grid[x][z]) continue;
                    tracker.remove(new ChunkPos(pos.field_77276_a + x - this.radius, pos.field_77275_b + z - this.radius), this.field_174879_c);
                }
            }
        });
    }

    public void loadAll() {
        this.field_145850_b.getCapability(ChunkLoaderUtil.TRACKER_CAPABILITY).ifPresent(tracker -> {
            ChunkPos pos = this.field_145850_b.func_217349_x(this.field_174879_c).func_76632_l();
            for (int x = 0; x < this.gridSize; ++x) {
                for (int z = 0; z < this.gridSize; ++z) {
                    this.grid[x][z] = true;
                    tracker.add(new ChunkPos(pos.field_77276_a + x - this.radius, pos.field_77275_b + z - this.radius), this.field_174879_c);
                }
            }
        });
        this.dataChanged();
    }

    public void toggle(int xOffset, int zOffset) {
        this.field_145850_b.getCapability(ChunkLoaderUtil.TRACKER_CAPABILITY).ifPresent(tracker -> {
            ChunkPos pos = this.field_145850_b.func_217349_x(this.field_174879_c).func_76632_l();
            if (this.grid[xOffset + this.radius][zOffset + this.radius]) {
                tracker.remove(new ChunkPos(pos.field_77276_a + xOffset, pos.field_77275_b + zOffset), this.field_174879_c);
            } else {
                tracker.add(new ChunkPos(pos.field_77276_a + xOffset, pos.field_77275_b + zOffset), this.field_174879_c);
            }
            this.grid[xOffset + this.radius][zOffset + this.radius] = !this.grid[xOffset + this.radius][zOffset + this.radius];
        });
        this.dataChanged();
    }

    public boolean isLoaded(int xOffset, int zOffset) {
        return this.grid[xOffset + this.radius][zOffset + this.radius];
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void dataChanged() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.dataChanged = true;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
    }

    private CompoundNBT getChangedData() {
        if (this.dataChanged) {
            this.dataChanged = false;
            return this.getData();
        }
        return null;
    }

    private CompoundNBT getData() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("gridSize", this.gridSize);
        for (int x = 0; x < this.gridSize; ++x) {
            for (int z = 0; z < this.gridSize; ++z) {
                tag.func_74757_a(x + ";" + z, this.grid[x][z]);
            }
        }
        return tag;
    }

    private void handleData(CompoundNBT tag) {
        int n = this.gridSize = tag.func_74764_b("gridSize") ? tag.func_74762_e("gridSize") : this.gridSize;
        if (this.gridSize < 1 || this.gridSize % 2 == 0) {
            this.gridSize = 1;
        }
        this.radius = (this.gridSize - 1) / 2;
        this.grid = new boolean[this.gridSize][this.gridSize];
        for (int x = 0; x < this.gridSize; ++x) {
            for (int z = 0; z < this.gridSize; ++z) {
                this.grid[x][z] = tag.func_74764_b(x + ";" + z) && tag.func_74767_n(x + ";" + z);
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("data", (INBT)this.getData());
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.handleData(compound.func_74775_l("data"));
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        tag.func_218657_a("data", (INBT)this.getData());
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.handleData(tag.func_74775_l("data"));
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tag = this.getChangedData();
        return tag == null || tag.isEmpty() ? null : new SUpdateTileEntityPacket(this.field_174879_c, 0, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleData(pkt.func_148857_g());
    }
}

