/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedSnowyDirtBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCameraEntity;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.models.BlockMineModel;
import net.geforcemods.securitycraft.models.DisguisableDynamicBakedModel;
import net.geforcemods.securitycraft.renderers.BlockPocketManagerTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.BouncingBettyRenderer;
import net.geforcemods.securitycraft.renderers.BulletRenderer;
import net.geforcemods.securitycraft.renderers.EmptyRenderer;
import net.geforcemods.securitycraft.renderers.IMSBombRenderer;
import net.geforcemods.securitycraft.renderers.KeypadChestTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.ProjectorTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.ReinforcedPistonTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.RetinalScannerTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.SecretSignTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.SecurityCameraTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.SentryRenderer;
import net.geforcemods.securitycraft.renderers.SonicSecuritySystemTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.TrophySystemTileEntityRenderer;
import net.geforcemods.securitycraft.screen.BlockPocketManagerScreen;
import net.geforcemods.securitycraft.screen.BlockReinforcerScreen;
import net.geforcemods.securitycraft.screen.BriefcaseInventoryScreen;
import net.geforcemods.securitycraft.screen.BriefcasePasswordScreen;
import net.geforcemods.securitycraft.screen.BriefcaseSetupScreen;
import net.geforcemods.securitycraft.screen.CameraMonitorScreen;
import net.geforcemods.securitycraft.screen.CheckPasswordScreen;
import net.geforcemods.securitycraft.screen.CustomizeBlockScreen;
import net.geforcemods.securitycraft.screen.DisguiseModuleScreen;
import net.geforcemods.securitycraft.screen.EditModuleScreen;
import net.geforcemods.securitycraft.screen.IMSScreen;
import net.geforcemods.securitycraft.screen.InventoryScannerScreen;
import net.geforcemods.securitycraft.screen.KeyChangerScreen;
import net.geforcemods.securitycraft.screen.KeycardReaderScreen;
import net.geforcemods.securitycraft.screen.KeypadFurnaceScreen;
import net.geforcemods.securitycraft.screen.MineRemoteAccessToolScreen;
import net.geforcemods.securitycraft.screen.ProjectorScreen;
import net.geforcemods.securitycraft.screen.SCManualScreen;
import net.geforcemods.securitycraft.screen.SentryRemoteAccessToolScreen;
import net.geforcemods.securitycraft.screen.SetPasswordScreen;
import net.geforcemods.securitycraft.screen.SonicSecuritySystemScreen;
import net.geforcemods.securitycraft.screen.TrophySystemScreen;
import net.geforcemods.securitycraft.screen.UsernameLoggerScreen;
import net.geforcemods.securitycraft.tileentity.SecretSignTileEntity;
import net.geforcemods.securitycraft.tileentity.SonicSecuritySystemTileEntity;
import net.geforcemods.securitycraft.util.Reinforced;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.EditSignScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="securitycraft", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientHandler {
    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        String[] facings = new String[]{"east", "north", "south", "west"};
        ResourceLocation[] facingPoweredBlocks = new ResourceLocation[]{new ResourceLocation("securitycraft", "keycard_reader"), new ResourceLocation("securitycraft", "keypad"), new ResourceLocation("securitycraft", "retinal_scanner")};
        ResourceLocation[] facingBlocks = new ResourceLocation[]{new ResourceLocation("securitycraft", "projector"), new ResourceLocation("securitycraft", "username_logger")};
        ResourceLocation[] poweredBlocks = new ResourceLocation[]{new ResourceLocation("securitycraft", "laser_block")};
        String[] mines = new String[]{"coal_ore", "cobblestone", "diamond_ore", "dirt", "emerald_ore", "gravel", "gold_ore", "gilded_blackstone", "furnace", "iron_ore", "lapis_ore", "nether_gold_ore", "redstone_ore", "sand", "stone"};
        ResourceLocation invScanRL = new ResourceLocation("securitycraft", "inventory_scanner");
        ResourceLocation ppfRL = new ResourceLocation("securitycraft", "keypad_furnace");
        for (String string : facings) {
            for (ResourceLocation facingPoweredBlock : facingPoweredBlocks) {
                ClientHandler.registerDisguisedModel(event, facingPoweredBlock, "facing=" + string + ",powered=true");
                ClientHandler.registerDisguisedModel(event, facingPoweredBlock, "facing=" + string + ",powered=false");
            }
            for (ResourceLocation facingBlock : facingBlocks) {
                ClientHandler.registerDisguisedModel(event, facingBlock, "facing=" + string);
            }
            ClientHandler.registerDisguisedModel(event, ppfRL, "facing=" + string + ",lit=false,open=false");
            ClientHandler.registerDisguisedModel(event, ppfRL, "facing=" + string + ",lit=false,open=true");
            ClientHandler.registerDisguisedModel(event, ppfRL, "facing=" + string + ",lit=true,open=false");
            ClientHandler.registerDisguisedModel(event, ppfRL, "facing=" + string + ",lit=true,open=true");
            ClientHandler.registerDisguisedModel(event, invScanRL, "facing=" + string + ",horizontal=true");
            ClientHandler.registerDisguisedModel(event, invScanRL, "facing=" + string + ",horizontal=false");
        }
        for (String string : poweredBlocks) {
            ClientHandler.registerDisguisedModel(event, (ResourceLocation)string, "powered=false");
            ClientHandler.registerDisguisedModel(event, (ResourceLocation)string, "powered=true");
        }
        ResourceLocation cageTrapRl = new ResourceLocation("securitycraft", "cage_trap");
        ResourceLocation protectoRl = new ResourceLocation("securitycraft", "protecto");
        ClientHandler.registerDisguisedModel(event, cageTrapRl, "deactivated=true");
        ClientHandler.registerDisguisedModel(event, cageTrapRl, "deactivated=false");
        ClientHandler.registerDisguisedModel(event, protectoRl, "enabled=true");
        ClientHandler.registerDisguisedModel(event, protectoRl, "enabled=false");
        ClientHandler.registerDisguisedModel(event, new ResourceLocation("securitycraft", "trophy_system"), "");
        for (String mine : mines) {
            ClientHandler.registerBlockMineModel(event, new ResourceLocation("securitycraft", mine.replace("_ore", "") + "_mine"), new ResourceLocation(mine));
        }
        ClientHandler.registerBlockMineModel(event, new ResourceLocation("securitycraft", "quartz_mine"), new ResourceLocation("nether_quartz_ore"));
    }

    private static void registerDisguisedModel(ModelBakeEvent event, ResourceLocation rl, String stateString) {
        ModelResourceLocation mrl = new ModelResourceLocation(rl, stateString);
        event.getModelRegistry().put(mrl, new DisguisableDynamicBakedModel(rl, (IBakedModel)event.getModelRegistry().get(mrl)));
    }

    private static void registerBlockMineModel(ModelBakeEvent event, ResourceLocation mineRl, ResourceLocation realBlockRl) {
        ModelResourceLocation mineMrl = new ModelResourceLocation(mineRl, "inventory");
        event.getModelRegistry().put(mineMrl, new BlockMineModel((IBakedModel)event.getModelRegistry().get(new ModelResourceLocation(realBlockRl, "inventory")), (IBakedModel)event.getModelRegistry().get(mineMrl)));
    }

    @SubscribeEvent
    public static void onTextureStitchPre(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)Atlases.field_228747_f_)) {
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/active"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/inactive"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/left_active"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/left_inactive"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/right_active"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/right_inactive"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/christmas"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/christmas_left"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/christmas_right"));
        }
    }

    @SubscribeEvent
    public static void onFMLClientSetup(FMLClientSetupEvent event) {
        RenderType cutout = RenderType.func_228643_e_();
        RenderType cutoutMipped = RenderType.func_228641_d_();
        RenderType translucent = RenderType.func_228645_f_();
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.BLOCK_POCKET_MANAGER.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.BLOCK_POCKET_WALL.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.CAGE_TRAP.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Fluid)((Fluid)SCContent.FAKE_WATER.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Fluid)((Fluid)SCContent.FLOWING_FAKE_WATER.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.HORIZONTAL_REINFORCED_IRON_BARS.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.INVENTORY_SCANNER.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.INVENTORY_SCANNER_FIELD.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.KEYCARD_READER.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.KEYPAD.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.KEYPAD_DOOR.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.KEYPAD_FURNACE.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.LASER_BLOCK.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.LASER_FIELD.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_BLACK_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_BLACK_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_BLUE_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_BLUE_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_BROWN_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_BROWN_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_CHAIN.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_COBWEB.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_CYAN_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_CYAN_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_DOOR.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_GLASS.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_GLASS_PANE.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_GRASS_BLOCK.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_GRAY_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_GRAY_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_GREEN_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_GREEN_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_HOPPER.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_ICE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_IRON_BARS.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_IRON_TRAPDOOR.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_LANTERN.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_SOUL_LANTERN.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIGHT_BLUE_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIGHT_BLUE_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIGHT_GRAY_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIGHT_GRAY_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIME_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIME_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_MAGENTA_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_MAGENTA_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_ORANGE_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_ORANGE_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_PINK_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_PINK_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_PURPLE_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_PURPLE_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_RED_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_RED_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_WHITE_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_WHITE_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_YELLOW_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_YELLOW_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.RETINAL_SCANNER.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.SCANNER_DOOR.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.TRACK_MINE.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.TROPHY_SYSTEM.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.USERNAME_LOGGER.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.PROJECTOR.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.PROTECTO.get()), (RenderType)cutoutMipped);
        RenderingRegistry.registerEntityRenderingHandler(SCContent.eTypeBouncingBetty, BouncingBettyRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SCContent.eTypeImsBomb, IMSBombRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SCContent.eTypeSecurityCamera, EmptyRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SCContent.eTypeSentry, SentryRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SCContent.eTypeBullet, BulletRenderer::new);
        ClientRegistry.bindTileEntityRenderer(SCContent.teTypeBlockPocketManager, BlockPocketManagerTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(SCContent.teTypeKeypadChest, KeypadChestTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(SCContent.teTypeRetinalScanner, RetinalScannerTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(SCContent.teTypeSecurityCamera, SecurityCameraTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(SCContent.teTypeSecretSign, SecretSignTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(SCContent.teTypeTrophySystem, TrophySystemTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(SCContent.teTypeProjector, ProjectorTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(SCContent.teTypeReinforcedPiston, ReinforcedPistonTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(SCContent.teTypeSonicSecuritySystem, SonicSecuritySystemTileEntityRenderer::new);
        ScreenManager.func_216911_a(SCContent.cTypeBlockReinforcer, BlockReinforcerScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeBriefcase, BriefcasePasswordScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeBriefcaseInventory, BriefcaseInventoryScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeBriefcaseSetup, BriefcaseSetupScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeCustomizeBlock, CustomizeBlockScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeDisguiseModule, DisguiseModuleScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeInventoryScanner, InventoryScannerScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeKeypadFurnace, KeypadFurnaceScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeCheckPassword, CheckPasswordScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeSetPassword, SetPasswordScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeUsernameLogger, UsernameLoggerScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeIMS, IMSScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeKeycardReader, KeycardReaderScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeKeyChanger, KeyChangerScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeBlockPocketManager, BlockPocketManagerScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeProjector, ProjectorScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeTrophySystem, TrophySystemScreen::new);
        KeyBindings.init();
        ClientHandler.tint();
    }

    public static void tint() {
        HashSet<IForgeRegistryEntry> reinforcedTint = new HashSet<IForgeRegistryEntry>();
        HashMap<Object, Integer> toTint = new HashMap<Object, Integer>();
        HashMap<IForgeRegistryEntry, IBlockColor> specialBlockTint = new HashMap<IForgeRegistryEntry, IBlockColor>();
        HashMap<IForgeRegistryEntry, IItemColor> specialItemTint = new HashMap<IForgeRegistryEntry, IItemColor>();
        for (Field field : SCContent.class.getFields()) {
            if (!field.isAnnotationPresent(Reinforced.class)) continue;
            try {
                if (field.getAnnotation(Reinforced.class).hasReinforcedTint()) {
                    reinforcedTint.add(((RegistryObject)field.get(null)).get());
                }
                if (!field.getAnnotation(Reinforced.class).hasReinforcedTint() && field.getAnnotation(Reinforced.class).customTint() == 0xFFFFFF) continue;
                toTint.put(((RegistryObject)field.get(null)).get(), field.getAnnotation(Reinforced.class).customTint());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        int noTint = 0xFFFFFF;
        int crystalQuartzTint = 1422242;
        toTint.put(SCContent.BLOCK_POCKET_MANAGER.get(), crystalQuartzTint);
        reinforcedTint.add(SCContent.BLOCK_POCKET_MANAGER.get());
        toTint.put(SCContent.BLOCK_POCKET_WALL.get(), crystalQuartzTint);
        reinforcedTint.add(SCContent.BLOCK_POCKET_WALL.get());
        toTint.put(SCContent.CHISELED_CRYSTAL_QUARTZ.get(), crystalQuartzTint);
        toTint.put(SCContent.CRYSTAL_QUARTZ.get(), crystalQuartzTint);
        toTint.put(SCContent.CRYSTAL_QUARTZ_PILLAR.get(), crystalQuartzTint);
        toTint.put(SCContent.CRYSTAL_QUARTZ_SLAB.get(), crystalQuartzTint);
        toTint.put(SCContent.STAIRS_CRYSTAL_QUARTZ.get(), crystalQuartzTint);
        specialBlockTint.put(SCContent.REINFORCED_GRASS_BLOCK.get(), (state, world, pos, tintIndex) -> {
            if (tintIndex == 1 && !((Boolean)state.func_177229_b((Property)ReinforcedSnowyDirtBlock.field_196382_a)).booleanValue()) {
                int grassTint = world != null && pos != null ? BiomeColors.func_228358_a_((IBlockDisplayReader)world, (BlockPos)pos) : GrassColors.func_77480_a((double)0.5, (double)1.0);
                return ClientHandler.mixWithReinforcedTintIfEnabled(grassTint);
            }
            return noTint;
        });
        specialBlockTint.put(SCContent.REINFORCED_CAULDRON.get(), (state, world, pos, tintIndex) -> {
            if (tintIndex == 1) {
                return world != null && pos != null ? BiomeColors.func_228363_c_((IBlockDisplayReader)world, (BlockPos)pos) : -1;
            }
            return noTint;
        });
        specialItemTint.put(SCContent.REINFORCED_GRASS_BLOCK.get(), (stack, tintIndex) -> {
            if (tintIndex == 1) {
                int grassTint = GrassColors.func_77480_a((double)0.5, (double)1.0);
                return ClientHandler.mixWithReinforcedTintIfEnabled(grassTint);
            }
            return noTint;
        });
        toTint.forEach((block, tint) -> Minecraft.func_71410_x().func_184125_al().func_186722_a((state, world, pos, tintIndex) -> {
            if (tintIndex == 0) {
                return reinforcedTint.contains(block) ? ClientHandler.mixWithReinforcedTintIfEnabled(tint) : tint;
            }
            if (specialBlockTint.containsKey(block)) {
                return ((IBlockColor)specialBlockTint.get(block)).getColor(state, world, pos, tintIndex);
            }
            return noTint;
        }, new Block[]{block}));
        toTint.forEach((item, tint) -> Minecraft.func_71410_x().getItemColors().func_199877_a((stack, tintIndex) -> {
            if (tintIndex == 0) {
                return reinforcedTint.contains(item) ? ClientHandler.mixWithReinforcedTintIfEnabled(tint) : tint;
            }
            if (specialItemTint.containsKey(item)) {
                return ((IItemColor)specialItemTint.get(item)).getColor(stack, tintIndex);
            }
            return noTint;
        }, new IItemProvider[]{item}));
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, world, pos, tintIndex) -> {
            Block blockFromItem;
            Block block = state.func_177230_c();
            if (block instanceof DisguisableBlock && (blockFromItem = Block.func_149634_a((Item)((DisguisableBlock)block).getDisguisedStack((IBlockReader)world, pos).func_77973_b())) != Blocks.field_150350_a && !(blockFromItem instanceof DisguisableBlock)) {
                return Minecraft.func_71410_x().func_184125_al().func_228054_a_(blockFromItem.func_176223_P(), world, pos, tintIndex);
            }
            return noTint;
        }, new Block[]{(Block)SCContent.CAGE_TRAP.get(), (Block)SCContent.INVENTORY_SCANNER.get(), (Block)SCContent.KEYCARD_READER.get(), (Block)SCContent.KEYPAD.get(), (Block)SCContent.KEYPAD_FURNACE.get(), (Block)SCContent.LASER_BLOCK.get(), (Block)SCContent.PROJECTOR.get(), (Block)SCContent.PROTECTO.get(), (Block)SCContent.RETINAL_SCANNER.get(), (Block)SCContent.TROPHY_SYSTEM.get(), (Block)SCContent.USERNAME_LOGGER.get()});
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, tintIndex) -> {
            if (tintIndex == 0) {
                IDyeableArmorItem item = (IDyeableArmorItem)stack.func_77973_b();
                if (item.func_200883_f_(stack)) {
                    return item.func_200886_f(stack);
                }
                return 0x333333;
            }
            return -1;
        }, new IItemProvider[]{(IItemProvider)SCContent.BRIEFCASE.get()});
    }

    private static int mixWithReinforcedTintIfEnabled(int tint1) {
        boolean tintReinforcedBlocks = (Boolean)ConfigHandler.SERVER.forceReinforcedBlockTint.get() != false ? ((Boolean)ConfigHandler.SERVER.reinforcedBlockTint.get()).booleanValue() : ((Boolean)ConfigHandler.CLIENT.reinforcedBlockTint.get()).booleanValue();
        return tintReinforcedBlocks ? ClientHandler.mixTints(tint1, 0x999999) : tint1;
    }

    private static int mixTints(int tint1, int tint2) {
        int red = tint1 >> 16 & 0xFF;
        int green = tint1 >> 8 & 0xFF;
        int blue = tint1 & 0xFF;
        red = (int)((float)red * ((float)(tint2 >> 16 & 0xFF) / 255.0f));
        green = (int)((float)green * ((float)(tint2 >> 8 & 0xFF) / 255.0f));
        blue = (int)((float)blue * ((float)(tint2 & 0xFF) / 255.0f));
        return ((red << 8) + green << 8) + blue;
    }

    public static PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static void displayMRATGui(ItemStack stack) {
        Minecraft.func_71410_x().func_147108_a((Screen)new MineRemoteAccessToolScreen(stack));
    }

    public static void displaySRATGui(ItemStack stack, int viewDistance) {
        Minecraft.func_71410_x().func_147108_a((Screen)new SentryRemoteAccessToolScreen(stack, viewDistance));
    }

    public static void displayEditModuleGui(ItemStack stack) {
        Minecraft.func_71410_x().func_147108_a((Screen)new EditModuleScreen(stack));
    }

    public static void displayCameraMonitorGui(PlayerInventory inv, CameraMonitorItem item, CompoundNBT stackTag) {
        Minecraft.func_71410_x().func_147108_a((Screen)new CameraMonitorScreen(inv, item, stackTag));
    }

    public static void displaySCManualGui() {
        Minecraft.func_71410_x().func_147108_a((Screen)new SCManualScreen());
    }

    public static void displayEditSecretSignGui(SecretSignTileEntity te) {
        Minecraft.func_71410_x().func_147108_a((Screen)new EditSignScreen((SignTileEntity)te));
    }

    public static void displaySonicSecuritySystemGui(SonicSecuritySystemTileEntity te) {
        Minecraft.func_71410_x().func_147108_a((Screen)new SonicSecuritySystemScreen(te));
    }

    public static void refreshModelData(TileEntity te) {
        BlockPos pos = te.func_174877_v();
        ModelDataManager.requestModelDataRefresh((TileEntity)te);
        Minecraft.func_71410_x().field_71438_f.func_147585_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static boolean isPlayerMountedOnCamera() {
        return Minecraft.func_71410_x().field_175622_Z instanceof SecurityCameraEntity;
    }
}

