/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordConvertible;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.LinkableTileEntity;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.blocks.SonicSecuritySystemBlock;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedCarpetBlock;
import net.geforcemods.securitycraft.entity.SentryEntity;
import net.geforcemods.securitycraft.entity.camera.SecurityCameraEntity;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.items.UniversalBlockReinforcerItem;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.misc.SonicSecuritySystemTracker;
import net.geforcemods.securitycraft.network.client.SendTip;
import net.geforcemods.securitycraft.tileentity.PortableRadarTileEntity;
import net.geforcemods.securitycraft.tileentity.SecurityCameraTileEntity;
import net.geforcemods.securitycraft.tileentity.SonicSecuritySystemTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.NoteBlockInstrument;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.tuple.MutablePair;

@Mod.EventBusSubscriber(modid="securitycraft")
public class SCEventHandler {
    public static final Integer NOTE_DELAY = 10;
    public static final Map<PlayerEntity, MutablePair<Integer, Deque<SonicSecuritySystemTileEntity.NoteWrapper>>> PLAYING_TUNES = new HashMap<PlayerEntity, MutablePair<Integer, Deque<SonicSecuritySystemTileEntity.NoteWrapper>>>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            PLAYING_TUNES.forEach((player, pair) -> {
                int ticksRemaining = (Integer)pair.getLeft();
                if (ticksRemaining == 0) {
                    if (PlayerUtils.getSelectedItemStack(player, (Item)SCContent.PORTABLE_TUNE_PLAYER.get()).func_190926_b()) {
                        pair.setLeft((Object)-1);
                        return;
                    }
                    SonicSecuritySystemTileEntity.NoteWrapper note = (SonicSecuritySystemTileEntity.NoteWrapper)((Deque)pair.getRight()).poll();
                    if (note != null) {
                        SoundEvent sound = NoteBlockInstrument.valueOf((String)note.instrumentName.toUpperCase()).func_208088_a();
                        float pitch = (float)Math.pow(2.0, (double)(note.noteID - 12) / 12.0);
                        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), sound, SoundCategory.RECORDS, 3.0f, pitch);
                        SCEventHandler.handlePlayedNote(player.field_70170_p, player.func_233580_cy_(), note.noteID, note.instrumentName);
                        pair.setLeft((Object)NOTE_DELAY);
                    } else {
                        pair.setLeft((Object)-1);
                    }
                } else {
                    pair.setLeft((Object)(ticksRemaining - 1));
                }
            });
            if (PLAYING_TUNES.size() > 0) {
                Iterator<Map.Entry<PlayerEntity, MutablePair<Integer, Deque<SonicSecuritySystemTileEntity.NoteWrapper>>>> entries = PLAYING_TUNES.entrySet().iterator();
                while (entries.hasNext()) {
                    if ((Integer)entries.next().getValue().left != -1) continue;
                    entries.remove();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!((Boolean)ConfigHandler.SERVER.disableThanksMessage.get()).booleanValue()) {
            SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new SendTip());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        if (player.func_175398_C() instanceof SecurityCameraEntity) {
            SecurityCameraEntity cam = (SecurityCameraEntity)player.func_175398_C();
            TileEntity tile = player.field_70170_p.func_175625_s(cam.func_233580_cy_());
            if (tile instanceof SecurityCameraTileEntity) {
                ((SecurityCameraTileEntity)tile).stopViewing();
            }
            cam.func_70106_y();
        }
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingHurtEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (event.getSource() == CustomDamageSources.ELECTRICITY) {
            world.func_184133_a(null, entity.func_233580_cy_(), SCSounds.ELECTRIFIED.event, SoundCategory.BLOCKS, 0.25f, 1.0f);
        }
        if (!world.field_72995_K && entity instanceof ServerPlayerEntity && PlayerUtils.isPlayerMountedOnCamera(entity)) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            ((SecurityCameraEntity)player.func_175398_C()).stopViewing(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void highestPriorityOnRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block block;
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (!(stack.func_190926_b() || item == SCContent.UNIVERSAL_BLOCK_REMOVER.get() || item == SCContent.UNIVERSAL_BLOCK_MODIFIER.get() || item == SCContent.UNIVERSAL_OWNER_CHANGER.get() || item == SCContent.SONIC_SECURITY_SYSTEM_ITEM.get() || item instanceof BlockItem || (block = event.getWorld().func_180495_p(event.getPos()).func_177230_c()) != SCContent.KEYPAD_DOOR.get() && block != SCContent.REINFORCED_DOOR.get() && block != SCContent.REINFORCED_IRON_TRAPDOOR.get() && block != SCContent.SCANNER_DOOR.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        List sentries;
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
            return;
        }
        World world = event.getWorld();
        TileEntity te = world.func_175625_s(event.getPos());
        BlockState state = world.func_180495_p(event.getPos());
        Block block = state.func_177230_c();
        if (te instanceof ILockable && ((ILockable)te).isLocked() && ((ILockable)te).disableInteractionWhenLocked(world, event.getPos(), event.getPlayer())) {
            if (event.getHand() == Hand.MAIN_HAND) {
                TranslationTextComponent blockName = Utils.localize(block.func_149739_a(), new Object[0]);
                PlayerUtils.sendMessageToPlayer(event.getPlayer(), (IFormattableTextComponent)blockName, (IFormattableTextComponent)Utils.localize("messages.securitycraft:sonic_security_system.locked", blockName), TextFormatting.DARK_RED, false);
            }
            event.setCanceled(true);
            return;
        }
        if (!world.field_72995_K) {
            if (PlayerUtils.isHoldingItem(event.getPlayer(), SCContent.KEY_PANEL, event.getHand())) {
                for (IPasswordConvertible pc : SecurityCraftAPI.getRegisteredPasswordConvertibles()) {
                    if (pc.getOriginalBlock() != block) continue;
                    event.setUseBlock(Event.Result.DENY);
                    event.setUseItem(Event.Result.ALLOW);
                }
                return;
            }
            if (PlayerUtils.isHoldingItem(event.getPlayer(), SCContent.CODEBREAKER, event.getHand()) && SCEventHandler.handleCodebreaking(event)) {
                event.setCanceled(true);
                return;
            }
            if (te instanceof INameSetter && (te instanceof SecurityCameraTileEntity || te instanceof PortableRadarTileEntity) && PlayerUtils.isHoldingItem(event.getPlayer(), Items.field_151057_cb, event.getHand()) && event.getPlayer().func_184586_b(event.getHand()).func_82837_s()) {
                ItemStack nametag = event.getPlayer().func_184586_b(event.getHand());
                INameSetter nameable = (INameSetter)te;
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
                if (nameable.func_200201_e().equals(nametag.func_200301_q())) {
                    PlayerUtils.sendMessageToPlayer(event.getPlayer(), (IFormattableTextComponent)new TranslationTextComponent(te.func_195044_w().func_177230_c().func_149739_a()), (IFormattableTextComponent)Utils.localize("messages.securitycraft:naming.alreadyMatches", nameable.func_200201_e()), TextFormatting.RED);
                    return;
                }
                if (!event.getPlayer().func_184812_l_()) {
                    nametag.func_190918_g(1);
                }
                nameable.setCustomName(nametag.func_200301_q());
                PlayerUtils.sendMessageToPlayer(event.getPlayer(), (IFormattableTextComponent)new TranslationTextComponent(te.func_195044_w().func_177230_c().func_149739_a()), (IFormattableTextComponent)Utils.localize("messages.securitycraft:naming.named", nameable.func_200201_e()), TextFormatting.RED);
                return;
            }
        }
        if (!(sentries = world.func_217357_a(SentryEntity.class, new AxisAlignedBB(event.getPos()))).isEmpty()) {
            event.setCanceled(((SentryEntity)((Object)sentries.get(0))).func_230254_b_(event.getPlayer(), event.getHand()) == ActionResultType.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
            return;
        }
        ItemStack stack = event.getPlayer().func_184614_ca();
        Item held = stack.func_77973_b();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (held == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get() || held == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_2.get() || held == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_3.get()) {
            UniversalBlockReinforcerItem.convertBlock(world.func_180495_p(pos), world, stack, pos, event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onBlockEventBreak(BlockEvent.BreakEvent event) {
        ItemStack disguiseModule;
        Block block;
        List sentries;
        if (!(event.getWorld() instanceof World)) {
            return;
        }
        if (!event.getWorld().func_201670_d() && event.getWorld().func_175625_s(event.getPos()) instanceof IModuleInventory) {
            IModuleInventory te = (IModuleInventory)event.getWorld().func_175625_s(event.getPos());
            for (int i = 0; i < te.getMaxNumberOfModules(); ++i) {
                if (((ItemStack)te.getInventory().get(i)).func_190926_b()) continue;
                ItemStack stack = (ItemStack)te.getInventory().get(i);
                ItemEntity item = new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), stack);
                WorldUtils.addScheduledTask(event.getWorld(), () -> event.getWorld().func_217376_c((Entity)item));
                te.onModuleRemoved(stack, ((ModuleItem)stack.func_77973_b()).getModuleType());
                if (te instanceof LinkableTileEntity) {
                    ((LinkableTileEntity)te).createLinkedBlockAction(LinkedAction.MODULE_REMOVED, new Object[]{stack, ((ModuleItem)stack.func_77973_b()).getModuleType()}, (LinkableTileEntity)te);
                }
                if (!(te instanceof SecurityCameraTileEntity)) continue;
                SecurityCameraTileEntity cam = (SecurityCameraTileEntity)te;
                cam.func_145831_w().func_195593_d(cam.func_174877_v().func_177967_a((Direction)cam.func_145831_w().func_180495_p(cam.func_174877_v()).func_177229_b((Property)SecurityCameraBlock.FACING), -1), cam.func_145831_w().func_180495_p(cam.func_174877_v()).func_177230_c());
            }
        }
        if (!(sentries = ((World)event.getWorld()).func_217357_a(SentryEntity.class, new AxisAlignedBB(event.getPos()))).isEmpty() && !((SentryEntity)((Object)sentries.get(0))).getDisguiseModule().func_190926_b() && (block = ((ModuleItem)(disguiseModule = ((SentryEntity)((Object)sentries.get(0))).getDisguiseModule()).func_77973_b()).getBlockAddon(disguiseModule.func_77978_p())) == event.getWorld().func_180495_p(event.getPos()).func_177230_c()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onOwnership(OwnershipEvent event) {
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (te instanceof IOwnable) {
            String name = event.getPlayer().func_200200_C_().getString();
            String uuid = event.getPlayer().func_146103_bH().getId().toString();
            ((IOwnable)te).setOwner(uuid, name);
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof SentryEntity) {
            ((MobEntity)event.getEntity()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onLivingDestroyEvent(LivingDestroyBlockEvent event) {
        event.setCanceled(event.getEntity() instanceof WitherEntity && event.getState().func_177230_c() instanceof IReinforcedBlock);
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getPlayer()) && event.getItemStack().func_77973_b() != SCContent.CAMERA_MONITOR.get()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFurnaceFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().func_77973_b();
        if (item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof ReinforcedCarpetBlock) {
            event.setBurnTime(0);
        }
    }

    @SubscribeEvent
    public static void onNoteBlockPlayed(NoteBlockEvent.Play event) {
        SCEventHandler.handlePlayedNote((World)event.getWorld(), event.getPos(), event.getVanillaNoteId(), event.getInstrument().func_176610_l());
    }

    private static void handlePlayedNote(World world, BlockPos pos, int vanillaNoteId, String instrumentName) {
        List<SonicSecuritySystemTileEntity> sonicSecuritySystems = SonicSecuritySystemTracker.getSonicSecuritySystemsInRange(world, pos);
        for (SonicSecuritySystemTileEntity te : sonicSecuritySystems) {
            if (!te.isActive()) continue;
            if (te.isRecording()) {
                te.recordNote(vanillaNoteId, instrumentName);
                continue;
            }
            if (!te.listenToNote(vanillaNoteId, instrumentName)) continue;
            te.correctTuneWasPlayed = true;
            te.powerCooldown = (Integer)te.signalLength.get();
            if (!te.hasModule(ModuleType.REDSTONE)) continue;
            world.func_175656_a(te.func_174877_v(), (BlockState)te.func_145831_w().func_180495_p(te.func_174877_v()).func_206870_a((Property)SonicSecuritySystemBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            BlockUtils.updateIndirectNeighbors(te.func_145831_w(), te.func_174877_v(), (Block)SCContent.SONIC_SECURITY_SYSTEM.get(), Direction.DOWN);
        }
    }

    private static boolean handleCodebreaking(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getPlayer().field_70170_p;
        TileEntity tileEntity = world.func_175625_s(event.getPos());
        if (tileEntity instanceof IPasswordProtected && ((IPasswordProtected)tileEntity).isCodebreakable()) {
            if (((Boolean)ConfigHandler.SERVER.allowCodebreakerItem.get()).booleanValue()) {
                if (event.getPlayer().func_184586_b(event.getHand()).func_77973_b() == SCContent.CODEBREAKER.get()) {
                    event.getPlayer().func_184586_b(event.getHand()).func_222118_a(1, (LivingEntity)event.getPlayer(), p -> p.func_213334_d(event.getHand()));
                }
                if (event.getPlayer().func_184812_l_() || new Random().nextInt(3) == 1) {
                    return ((IPasswordProtected)tileEntity).onCodebreakerUsed(world.func_180495_p(event.getPos()), event.getPlayer());
                }
                PlayerUtils.sendMessageToPlayer(event.getPlayer(), (IFormattableTextComponent)new TranslationTextComponent(((Item)SCContent.CODEBREAKER.get()).func_77658_a()), (IFormattableTextComponent)Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), TextFormatting.RED);
                return true;
            }
            Block block = world.func_180495_p(event.getPos()).func_177230_c();
            PlayerUtils.sendMessageToPlayer(event.getPlayer(), (IFormattableTextComponent)Utils.localize(block.func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), TextFormatting.RED);
        }
        return false;
    }
}

