/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import net.geforcemods.securitycraft.api.LinkableTileEntity;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandlerModifiable;

public interface IModuleInventory
extends IItemHandlerModifiable {
    public NonNullList<ItemStack> getInventory();

    public ModuleType[] acceptedModules();

    public TileEntity getTileEntity();

    default public int getMaxNumberOfModules() {
        return this.acceptedModules().length;
    }

    default public void onModuleInserted(ItemStack stack, ModuleType module) {
        TileEntity te = this.getTileEntity();
        if (!te.func_145831_w().field_72995_K) {
            te.func_145831_w().func_184138_a(te.func_174877_v(), te.func_195044_w(), te.func_195044_w(), 3);
        }
    }

    default public void onModuleRemoved(ItemStack stack, ModuleType module) {
        TileEntity te = this.getTileEntity();
        if (!te.func_145831_w().field_72995_K) {
            te.func_145831_w().func_184138_a(te.func_174877_v(), te.func_195044_w(), te.func_195044_w(), 3);
        }
    }

    default public boolean enableHack() {
        return false;
    }

    default public int fixSlotId(int id) {
        return id >= 100 ? id - 100 : id;
    }

    default public int getSlots() {
        return this.acceptedModules().length;
    }

    default public ItemStack getStackInSlot(int slot) {
        return this.getModuleInSlot(slot);
    }

    default public ItemStack getModuleInSlot(int slot) {
        return (slot = this.fixSlotId(slot)) < 0 || slot >= this.getSlots() ? ItemStack.field_190927_a : (ItemStack)this.getInventory().get(slot);
    }

    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.getModuleInSlot(slot = this.fixSlotId(slot)).func_77946_l();
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!simulate) {
            TileEntity te = this.getTileEntity();
            if (stack.func_77973_b() instanceof ModuleItem) {
                this.onModuleRemoved(stack, ((ModuleItem)stack.func_77973_b()).getModuleType());
                if (te instanceof LinkableTileEntity) {
                    ModuleUtils.createLinkedAction(LinkedAction.MODULE_REMOVED, stack, (LinkableTileEntity)te);
                }
            }
            return ((ItemStack)this.getInventory().set(slot, (Object)ItemStack.field_190927_a)).func_77946_l();
        }
        return stack.func_77946_l();
    }

    default public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.getModuleInSlot(slot = this.fixSlotId(slot)).func_190926_b()) {
            return stack;
        }
        int returnSize = 0;
        if (stack.func_190916_E() > 1) {
            returnSize = stack.func_190916_E() - 1;
        }
        if (!simulate) {
            ItemStack copy = stack.func_77946_l();
            TileEntity te = this.getTileEntity();
            copy.func_190920_e(1);
            this.getInventory().set(slot, (Object)copy);
            if (stack.func_77973_b() instanceof ModuleItem) {
                this.onModuleInserted(stack, ((ModuleItem)stack.func_77973_b()).getModuleType());
                if (te instanceof LinkableTileEntity) {
                    ModuleUtils.createLinkedAction(LinkedAction.MODULE_INSERTED, copy, (LinkableTileEntity)te);
                }
            }
        }
        if (returnSize != 0) {
            ItemStack toReturn = stack.func_77946_l();
            toReturn.func_190920_e(returnSize);
            return toReturn;
        }
        return ItemStack.field_190927_a;
    }

    default public void setStackInSlot(int slot, ItemStack stack) {
        slot = this.fixSlotId(slot);
        TileEntity te = this.getTileEntity();
        ItemStack previous = this.getModuleInSlot(slot);
        if (!previous.func_190926_b()) {
            this.onModuleRemoved(previous, ((ModuleItem)previous.func_77973_b()).getModuleType());
            if (te instanceof LinkableTileEntity) {
                ModuleUtils.createLinkedAction(LinkedAction.MODULE_REMOVED, previous, (LinkableTileEntity)te);
            }
        }
        this.getInventory().set(slot, (Object)stack);
        if (stack.func_77973_b() instanceof ModuleItem) {
            this.onModuleInserted(stack, ((ModuleItem)stack.func_77973_b()).getModuleType());
            if (te instanceof LinkableTileEntity) {
                ModuleUtils.createLinkedAction(LinkedAction.MODULE_INSERTED, stack, (LinkableTileEntity)te);
            }
        }
    }

    default public int getSlotLimit(int slot) {
        return 1;
    }

    default public boolean isItemValid(int slot, ItemStack stack) {
        return this.getModuleInSlot(slot = this.fixSlotId(slot)).func_190926_b() && !stack.func_190926_b() && stack.func_77973_b() instanceof ModuleItem && this.getAcceptedModules().contains((Object)((ModuleItem)stack.func_77973_b()).getModuleType()) && !this.hasModule(((ModuleItem)stack.func_77973_b()).getModuleType());
    }

    default public ArrayList<ModuleType> getAcceptedModules() {
        ArrayList<ModuleType> list = new ArrayList<ModuleType>();
        for (ModuleType module : this.acceptedModules()) {
            list.add(module);
        }
        return list;
    }

    default public ArrayList<ModuleType> getInsertedModules() {
        ArrayList<ModuleType> modules = new ArrayList<ModuleType>();
        for (ItemStack stack : this.getInventory()) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ModuleItem)) continue;
            modules.add(((ModuleItem)stack.func_77973_b()).getModuleType());
        }
        return modules;
    }

    default public ItemStack getModule(ModuleType module) {
        NonNullList<ItemStack> modules = this.getInventory();
        for (int i = 0; i < modules.size(); ++i) {
            if (((ItemStack)modules.get(i)).func_190926_b() || !(((ItemStack)modules.get(i)).func_77973_b() instanceof ModuleItem) || ((ModuleItem)((ItemStack)modules.get(i)).func_77973_b()).getModuleType() != module) continue;
            return (ItemStack)modules.get(i);
        }
        return ItemStack.field_190927_a;
    }

    default public void insertModule(ModuleType module) {
        int i;
        NonNullList<ItemStack> modules = this.getInventory();
        for (i = 0; i < modules.size(); ++i) {
            if (((ItemStack)modules.get(i)).func_190926_b() || ((ItemStack)modules.get(i)).func_77973_b() != module.getItem()) continue;
            return;
        }
        for (i = 0; i < modules.size(); ++i) {
            if (!((ItemStack)modules.get(i)).func_190926_b() && module != null) {
                modules.set(i, (Object)new ItemStack((IItemProvider)module.getItem()));
                break;
            }
            if (((ItemStack)modules.get(i)).func_190926_b() || module != null) continue;
            modules.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    default public void insertModule(ItemStack module) {
        int i;
        if (module.func_190926_b() || !(module.func_77973_b() instanceof ModuleItem)) {
            return;
        }
        NonNullList<ItemStack> modules = this.getInventory();
        for (i = 0; i < modules.size(); ++i) {
            if (((ItemStack)modules.get(i)).func_190926_b() || ((ItemStack)modules.get(i)).func_77973_b() != module.func_77973_b()) continue;
            return;
        }
        for (i = 0; i < modules.size(); ++i) {
            if (!((ItemStack)modules.get(i)).func_190926_b()) continue;
            modules.set(i, (Object)module.func_77946_l());
            break;
        }
    }

    default public void removeModule(ModuleType module) {
        NonNullList<ItemStack> modules = this.getInventory();
        for (int i = 0; i < modules.size(); ++i) {
            if (((ItemStack)modules.get(i)).func_190926_b() || !(((ItemStack)modules.get(i)).func_77973_b() instanceof ModuleItem) || ((ModuleItem)((ItemStack)modules.get(i)).func_77973_b()).getModuleType() != module) continue;
            modules.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    default public boolean hasModule(ModuleType module) {
        NonNullList<ItemStack> modules = this.getInventory();
        if (module == null) {
            for (int i = 0; i < modules.size(); ++i) {
                if (!((ItemStack)modules.get(i)).func_190926_b()) continue;
                return true;
            }
        } else {
            for (int i = 0; i < modules.size(); ++i) {
                if (((ItemStack)modules.get(i)).func_190926_b() || !(((ItemStack)modules.get(i)).func_77973_b() instanceof ModuleItem) || ((ModuleItem)((ItemStack)modules.get(i)).func_77973_b()).getModuleType() != module) continue;
                return true;
            }
        }
        return false;
    }

    default public NonNullList<ItemStack> readModuleInventory(CompoundNBT tag) {
        ListNBT list = tag.func_150295_c("Modules", 10);
        NonNullList modules = NonNullList.func_191197_a((int)this.getMaxNumberOfModules(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT stackTag = list.func_150305_b(i);
            byte slot = stackTag.func_74771_c("ModuleSlot");
            if (slot < 0 || slot >= modules.size()) continue;
            modules.set((int)slot, (Object)ItemStack.func_199557_a((CompoundNBT)stackTag));
        }
        return modules;
    }

    default public CompoundNBT writeModuleInventory(CompoundNBT tag) {
        ListNBT list = new ListNBT();
        NonNullList<ItemStack> modules = this.getInventory();
        for (int i = 0; i < modules.size(); ++i) {
            if (((ItemStack)modules.get(i)).func_190926_b()) continue;
            CompoundNBT stackTag = new CompoundNBT();
            stackTag.func_74774_a("ModuleSlot", (byte)i);
            ((ItemStack)modules.get(i)).func_77955_b(stackTag);
            list.add((Object)stackTag);
        }
        tag.func_218657_a("Modules", (INBT)list);
        return tag;
    }
}

