/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import net.geforcemods.securitycraft.api.CustomizableTileEntity;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.LinkedBlock;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public abstract class LinkableTileEntity
extends CustomizableTileEntity
implements ITickableTileEntity {
    public ArrayList<LinkedBlock> linkedBlocks = new ArrayList();
    private ListNBT nbtTagStorage = null;

    public LinkableTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public void func_73660_a() {
        if (this.func_145830_o() && this.nbtTagStorage != null) {
            this.readLinkedBlocks(this.nbtTagStorage);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            this.nbtTagStorage = null;
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        if (tag.func_74764_b("linkedBlocks")) {
            if (!this.func_145830_o()) {
                this.nbtTagStorage = tag.func_150295_c("linkedBlocks", 10);
                return;
            }
            this.readLinkedBlocks(tag.func_150295_c("linkedBlocks", 10));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (this.func_145830_o() && this.linkedBlocks.size() > 0) {
            ListNBT tagList = new ListNBT();
            WorldUtils.addScheduledTask((IWorld)this.field_145850_b, () -> {
                for (int i = this.linkedBlocks.size() - 1; i >= 0; --i) {
                    LinkedBlock block = this.linkedBlocks.get(i);
                    CompoundNBT toAppend = new CompoundNBT();
                    if (block != null) {
                        if (!block.validate(this.field_145850_b)) {
                            this.linkedBlocks.remove(i);
                            continue;
                        }
                        toAppend.func_74778_a("blockName", block.blockName);
                        toAppend.func_74768_a("blockX", block.getX());
                        toAppend.func_74768_a("blockY", block.getY());
                        toAppend.func_74768_a("blockZ", block.getZ());
                    }
                    tagList.add((Object)toAppend);
                }
                tag.func_218657_a("linkedBlocks", (INBT)tagList);
            });
        }
        return tag;
    }

    private void readLinkedBlocks(ListNBT list) {
        for (int i = 0; i < list.size(); ++i) {
            String name = list.func_150305_b(i).func_74779_i("blockName");
            int x = list.func_150305_b(i).func_74762_e("blockX");
            int y = list.func_150305_b(i).func_74762_e("blockY");
            int z = list.func_150305_b(i).func_74762_e("blockZ");
            LinkedBlock block = new LinkedBlock(name, new BlockPos(x, y, z));
            if (this.func_145830_o() && !block.validate(this.field_145850_b)) {
                list.remove(i);
                continue;
            }
            if (this.linkedBlocks.contains(block)) continue;
            LinkableTileEntity.link(this, block.asTileEntity(this.field_145850_b));
        }
    }

    public void func_145843_s() {
        for (LinkedBlock block : this.linkedBlocks) {
            LinkableTileEntity.unlink(block.asTileEntity(this.field_145850_b), this);
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module) {
        super.onModuleInserted(stack, module);
        ModuleUtils.createLinkedAction(LinkedAction.MODULE_INSERTED, stack, this);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        ModuleUtils.createLinkedAction(LinkedAction.MODULE_REMOVED, stack, this);
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        this.createLinkedBlockAction(LinkedAction.OPTION_CHANGED, (Object[])new Option[]{option}, this);
    }

    public static void link(LinkableTileEntity tileEntity1, LinkableTileEntity tileEntity2) {
        if (LinkableTileEntity.isLinkedWith(tileEntity1, tileEntity2)) {
            return;
        }
        LinkedBlock block1 = new LinkedBlock(tileEntity1);
        LinkedBlock block2 = new LinkedBlock(tileEntity2);
        if (!tileEntity1.linkedBlocks.contains(block2)) {
            tileEntity1.linkedBlocks.add(block2);
        }
        if (!tileEntity2.linkedBlocks.contains(block1)) {
            tileEntity2.linkedBlocks.add(block1);
        }
    }

    public static void unlink(LinkableTileEntity tileEntity1, LinkableTileEntity tileEntity2) {
        if (tileEntity1 == null || tileEntity2 == null) {
            return;
        }
        LinkedBlock block = new LinkedBlock(tileEntity2);
        if (tileEntity1.linkedBlocks.contains(block)) {
            tileEntity1.linkedBlocks.remove(block);
        }
    }

    public static boolean isLinkedWith(LinkableTileEntity tileEntity1, LinkableTileEntity tileEntity2) {
        return tileEntity1.linkedBlocks.contains(new LinkedBlock(tileEntity2)) && tileEntity2.linkedBlocks.contains(new LinkedBlock(tileEntity1));
    }

    public void createLinkedBlockAction(LinkedAction action, Object[] parameters, LinkableTileEntity excludedTE) {
        ArrayList<LinkableTileEntity> list = new ArrayList<LinkableTileEntity>();
        list.add(excludedTE);
        this.createLinkedBlockAction(action, parameters, list);
    }

    public void createLinkedBlockAction(LinkedAction action, Object[] parameters, ArrayList<LinkableTileEntity> excludedTEs) {
        for (LinkedBlock block : this.linkedBlocks) {
            if (excludedTEs.contains(block.asTileEntity(this.field_145850_b))) continue;
            BlockState state = this.field_145850_b.func_180495_p(block.blockPos);
            block.asTileEntity(this.field_145850_b).onLinkedBlockAction(action, parameters, excludedTEs);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    protected void onLinkedBlockAction(LinkedAction action, Object[] parameters, ArrayList<LinkableTileEntity> excludedTEs) {
    }
}

