/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class DisguisableBlock
extends OwnableBlock
implements IOverlayDisplay {
    public DisguisableBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public static boolean isNormalCube(BlockState state, IBlockReader world, BlockPos pos) {
        BlockState disguisedState;
        if (state.func_177230_c() instanceof DisguisableBlock && (disguisedState = ((DisguisableBlock)state.func_177230_c()).getDisguisedStateOrDefault(state, world, pos)).func_177230_c() != state.func_177230_c()) {
            return disguisedState.func_215686_e(world, pos);
        }
        return state.func_185904_a().func_76218_k() && state.func_235785_r_(world, pos);
    }

    public static boolean isSuffocating(BlockState state, IBlockReader world, BlockPos pos) {
        BlockState disguisedState;
        if (state.func_177230_c() instanceof DisguisableBlock && (disguisedState = ((DisguisableBlock)state.func_177230_c()).getDisguisedStateOrDefault(state, world, pos)).func_177230_c() != state.func_177230_c()) {
            return disguisedState.func_229980_m_(world, pos);
        }
        return state.func_185904_a().func_76230_c() && state.func_235785_r_(world, pos);
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, (IBlockReader)world, pos);
        if (disguisedState.func_177230_c() != this) {
            return disguisedState.getSoundType(world, pos, entity);
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, world, pos);
        if (disguisedState.func_177230_c() != this) {
            return disguisedState.func_215700_a(world, pos, ctx);
        }
        return super.func_220053_a(state, world, pos, ctx);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, world, pos);
        if (disguisedState.func_177230_c() != this) {
            return disguisedState.func_215685_b(world, pos, ctx);
        }
        return super.func_220071_b(state, world, pos, ctx);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader world, BlockPos pos) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, world, pos);
        if (disguisedState.func_177230_c() != this) {
            return disguisedState.func_235754_c_(world, pos);
        }
        return super.func_196247_c(state, world, pos);
    }

    public float func_220080_a(BlockState state, IBlockReader world, BlockPos pos) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, world, pos);
        if (disguisedState.func_177230_c() != this) {
            return disguisedState.func_215703_d(world, pos);
        }
        return super.func_220080_a(state, world, pos);
    }

    public final BlockState getDisguisedStateOrDefault(BlockState state, IBlockReader world, BlockPos pos) {
        BlockState disguisedState = this.getDisguisedBlockState(world, pos);
        return disguisedState != null ? disguisedState : state;
    }

    public BlockState getDisguisedBlockState(IBlockReader world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof IModuleInventory) {
            Block block;
            ItemStack module;
            IModuleInventory te = (IModuleInventory)world.func_175625_s(pos);
            ItemStack itemStack = module = te.hasModule(ModuleType.DISGUISE) ? te.getModule(ModuleType.DISGUISE) : ItemStack.field_190927_a;
            if (!module.func_190926_b() && (block = ((ModuleItem)module.func_77973_b()).getBlockAddon(module.func_77978_p())) != null) {
                return block.func_176223_P();
            }
        }
        return null;
    }

    public ItemStack getDisguisedStack(IBlockReader world, BlockPos pos) {
        if (world != null && world.func_175625_s(pos) instanceof IModuleInventory) {
            Block block;
            ItemStack stack;
            IModuleInventory te = (IModuleInventory)world.func_175625_s(pos);
            ItemStack itemStack = stack = te.hasModule(ModuleType.DISGUISE) ? te.getModule(ModuleType.DISGUISE) : ItemStack.field_190927_a;
            if (!stack.func_190926_b() && (block = ((ModuleItem)stack.func_77973_b()).getBlockAddon(stack.func_77978_p())) != null) {
                return new ItemStack((IItemProvider)block);
            }
        }
        return new ItemStack((IItemProvider)this);
    }

    @Override
    public ItemStack getDisplayStack(World world, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockReader)world, pos);
    }

    @Override
    public boolean shouldShowSCInfo(World world, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockReader)world, pos).func_77973_b() == this.func_199767_j();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.getDisguisedStack(world, pos);
    }
}

