/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerFieldBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.InventoryScannerTileEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class InventoryScannerBlock
extends DisguisableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty HORIZONTAL = BooleanProperty.func_177716_a((String)"horizontal");

    public InventoryScannerBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)HORIZONTAL, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (this.isFacingAnotherScanner(world, pos) && player instanceof ServerPlayerEntity) {
            TileEntity te = world.func_175625_s(pos);
            if (!world.field_72995_K && te instanceof INamedContainerProvider) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te), (BlockPos)pos);
            }
            return ActionResultType.SUCCESS;
        }
        PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Block)SCContent.INVENTORY_SCANNER.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:invScan.notConnected", new Object[0]), TextFormatting.RED);
        return ActionResultType.SUCCESS;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        if (world.field_72995_K) {
            return;
        }
        this.checkAndPlaceAppropriately(world, pos);
    }

    private void checkAndPlaceAppropriately(World world, BlockPos pos) {
        InventoryScannerTileEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(world, pos);
        InventoryScannerTileEntity thisTe = (InventoryScannerTileEntity)world.func_175625_s(pos);
        if (connectedScanner == null || !connectedScanner.getOwner().owns(thisTe)) {
            return;
        }
        boolean horizontal = false;
        if (((Boolean)connectedScanner.func_195044_w().func_177229_b((Property)HORIZONTAL)).booleanValue()) {
            horizontal = true;
        }
        thisTe.setHorizontal(horizontal);
        Direction facing = (Direction)world.func_180495_p(pos).func_177229_b((Property)FACING);
        int loopBoundary = facing == Direction.WEST || facing == Direction.EAST ? Math.abs(pos.func_177958_n() - connectedScanner.func_174877_v().func_177958_n()) : (facing == Direction.NORTH || facing == Direction.SOUTH ? Math.abs(pos.func_177952_p() - connectedScanner.func_174877_v().func_177952_p()) : 0);
        for (int i = 1; i < loopBoundary; ++i) {
            if (world.func_180495_p(pos.func_177967_a(facing, i)).func_177230_c() != SCContent.INVENTORY_SCANNER_FIELD.get()) continue;
            return;
        }
        Option<?>[] customOptions = thisTe.customOptions();
        for (int i = 1; i < loopBoundary; ++i) {
            BlockPos offsetPos = pos.func_177967_a(facing, i);
            world.func_175656_a(offsetPos, (BlockState)((BlockState)((Block)SCContent.INVENTORY_SCANNER_FIELD.get()).func_176223_P().func_206870_a((Property)FACING, (Comparable)facing)).func_206870_a((Property)HORIZONTAL, (Comparable)Boolean.valueOf(horizontal)));
            TileEntity te = world.func_175625_s(offsetPos);
            if (!(te instanceof IOwnable)) continue;
            ((IOwnable)te).setOwner(thisTe.getOwner().getUUID(), thisTe.getOwner().getName());
        }
        for (ModuleType type : connectedScanner.getInsertedModules()) {
            thisTe.insertModule(connectedScanner.getModule(type));
        }
        ((Option.BooleanOption)customOptions[0]).setValue(connectedScanner.isHorizontal());
        ((Option.BooleanOption)customOptions[1]).setValue(connectedScanner.doesFieldSolidify());
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        int i;
        if (world.field_72995_K || state.func_177230_c() == newState.func_177230_c()) {
            return;
        }
        InventoryScannerTileEntity connectedScanner = null;
        block0: for (Direction facing : Direction.Plane.HORIZONTAL) {
            for (i = 1; i <= (Integer)ConfigHandler.SERVER.inventoryScannerRange.get(); ++i) {
                BlockPos offsetIPos = pos.func_177967_a(facing, i);
                if (world.func_180495_p(offsetIPos).func_177230_c() != SCContent.INVENTORY_SCANNER.get()) continue;
                for (int j = 1; j < i; ++j) {
                    BlockPos offsetJPos = pos.func_177967_a(facing, j);
                    BlockState field = world.func_180495_p(offsetJPos);
                    if (field.func_177230_c() != SCContent.INVENTORY_SCANNER_FIELD.get()) continue;
                    if (facing == Direction.WEST || facing == Direction.EAST) {
                        if (field.func_177229_b((Property)InventoryScannerFieldBlock.FACING) != Direction.WEST && field.func_177229_b((Property)InventoryScannerFieldBlock.FACING) != Direction.EAST) continue;
                        world.func_175655_b(offsetJPos, false);
                        continue;
                    }
                    if (facing != Direction.NORTH && facing != Direction.SOUTH || field.func_177229_b((Property)InventoryScannerFieldBlock.FACING) != Direction.NORTH && field.func_177229_b((Property)InventoryScannerFieldBlock.FACING) != Direction.SOUTH) continue;
                    world.func_175655_b(offsetJPos, false);
                }
                connectedScanner = (InventoryScannerTileEntity)world.func_175625_s(offsetIPos);
                continue block0;
            }
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof InventoryScannerTileEntity) {
            InventoryScannerTileEntity te = (InventoryScannerTileEntity)tile;
            for (i = 10; i < te.func_70302_i_(); ++i) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)((ItemStack)te.getContents().get(i)));
            }
        }
        if (connectedScanner != null) {
            for (int i2 = 0; i2 < connectedScanner.getContents().size(); ++i2) {
                connectedScanner.getContents().set(i2, (Object)ItemStack.field_190927_a);
            }
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    private boolean isFacingAnotherScanner(World world, BlockPos pos) {
        return InventoryScannerBlock.getConnectedInventoryScanner(world, pos) != null;
    }

    public static InventoryScannerTileEntity getConnectedInventoryScanner(World world, BlockPos pos) {
        Direction facing = (Direction)world.func_180495_p(pos).func_177229_b((Property)FACING);
        for (int i = 0; i <= (Integer)ConfigHandler.SERVER.inventoryScannerRange.get(); ++i) {
            BlockPos offsetPos = pos.func_177967_a(facing, i);
            BlockState state = world.func_180495_p(offsetPos);
            Block block = state.func_177230_c();
            if (!state.isAir((IBlockReader)world, offsetPos) && block != SCContent.INVENTORY_SCANNER_FIELD.get() && block != SCContent.INVENTORY_SCANNER.get()) {
                return null;
            }
            if (block != SCContent.INVENTORY_SCANNER.get() || state.func_177229_b((Property)FACING) != facing.func_176734_d()) continue;
            return (InventoryScannerTileEntity)world.func_175625_s(offsetPos);
        }
        return null;
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        this.checkAndPlaceAppropriately((World)world, pos);
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (!(blockAccess.func_175625_s(pos) instanceof InventoryScannerTileEntity)) {
            return 0;
        }
        return ((InventoryScannerTileEntity)blockAccess.func_175625_s(pos)).hasModule(ModuleType.REDSTONE) && ((InventoryScannerTileEntity)blockAccess.func_175625_s(pos)).shouldProvidePower() ? 15 : 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return this.func_180656_a(blockState, blockAccess, pos, side);
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c, ctx.func_195999_j());
    }

    public BlockState getStateForPlacement(World world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, PlayerEntity placer) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, HORIZONTAL});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new InventoryScannerTileEntity();
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public static class DoorActivator
    implements IDoorActivator {
        private List<Block> blocks = Arrays.asList((Block)SCContent.INVENTORY_SCANNER.get());

        @Override
        public boolean isPowering(World world, BlockPos pos, BlockState state, TileEntity te, Direction direction, int distance) {
            return ((InventoryScannerTileEntity)te).hasModule(ModuleType.REDSTONE) && ((InventoryScannerTileEntity)te).shouldProvidePower();
        }

        @Override
        public List<Block> getBlocks() {
            return this.blocks;
        }
    }
}

