/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.function.BiFunction;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.InventoryScannerTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class InventoryScannerFieldBlock
extends OwnableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty HORIZONTAL = BooleanProperty.func_177716_a((String)"horizontal");
    private static final VoxelShape SHAPE_EW = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_NS = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape HORIZONTAL_SHAPE = Block.func_208617_a((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public InventoryScannerFieldBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)HORIZONTAL, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext ctx) {
        block4: {
            Entity entity;
            InventoryScannerTileEntity connectedScanner;
            World world;
            block5: {
                if (ctx.getEntity() == null) {
                    return VoxelShapes.func_197880_a();
                }
                world = ctx.getEntity().func_130014_f_();
                connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(world, pos);
                entity = ctx.getEntity();
                if (connectedScanner == null || !connectedScanner.doesFieldSolidify()) break block4;
                if (!(entity instanceof PlayerEntity) || EntityUtils.isInvisible((LivingEntity)((PlayerEntity)entity))) break block5;
                if (ModuleUtils.isAllowed((IModuleInventory)connectedScanner, entity)) {
                    return VoxelShapes.func_197880_a();
                }
                for (int i = 0; i < 10; ++i) {
                    if (connectedScanner.getStackInSlotCopy(i).func_190926_b() || !InventoryScannerFieldBlock.checkInventory((PlayerEntity)entity, connectedScanner, connectedScanner.getStackInSlotCopy(i), false)) continue;
                    return this.func_220053_a(state, (IBlockReader)world, pos, ctx);
                }
                break block4;
            }
            if (!(entity instanceof ItemEntity)) break block4;
            for (int i = 0; i < 10; ++i) {
                if (connectedScanner.getStackInSlotCopy(i).func_190926_b() || ((ItemEntity)entity).func_92059_d().func_190926_b() || !InventoryScannerFieldBlock.checkItemEntity((ItemEntity)entity, connectedScanner, connectedScanner.getStackInSlotCopy(i), false)) continue;
                return this.func_220053_a(state, (IBlockReader)world, pos, ctx);
            }
        }
        return VoxelShapes.func_197880_a();
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        block5: {
            InventoryScannerTileEntity connectedScanner;
            block4: {
                connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(world, pos);
                if (connectedScanner == null || connectedScanner.doesFieldSolidify()) {
                    return;
                }
                if (!(entity instanceof PlayerEntity) || EntityUtils.isInvisible((LivingEntity)((PlayerEntity)entity))) break block4;
                if (ModuleUtils.isAllowed((IModuleInventory)connectedScanner, entity)) {
                    return;
                }
                for (int i = 0; i < 10; ++i) {
                    if (connectedScanner.getStackInSlotCopy(i).func_190926_b()) continue;
                    InventoryScannerFieldBlock.checkInventory((PlayerEntity)entity, connectedScanner, connectedScanner.getStackInSlotCopy(i), true);
                }
                break block5;
            }
            if (!(entity instanceof ItemEntity)) break block5;
            for (int i = 0; i < 10; ++i) {
                if (connectedScanner.getStackInSlotCopy(i).func_190926_b() || ((ItemEntity)entity).func_92059_d().func_190926_b()) continue;
                InventoryScannerFieldBlock.checkItemEntity((ItemEntity)entity, connectedScanner, connectedScanner.getStackInSlotCopy(i), true);
            }
        }
    }

    public static boolean checkInventory(PlayerEntity player, InventoryScannerTileEntity te, ItemStack stack, boolean allowInteraction) {
        boolean hasRedstoneModule;
        boolean hasSmartModule = te.hasModule(ModuleType.SMART);
        boolean hasStorageModule = allowInteraction && te.hasModule(ModuleType.STORAGE);
        boolean bl = hasRedstoneModule = allowInteraction && te.hasModule(ModuleType.REDSTONE);
        if (!hasRedstoneModule && !hasStorageModule && allowInteraction || te.getOwner().isOwner(player)) {
            return false;
        }
        return InventoryScannerFieldBlock.loopInventory((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, stack, te, hasSmartModule, hasStorageModule, hasRedstoneModule) || InventoryScannerFieldBlock.loopInventory((NonNullList<ItemStack>)player.field_71071_by.field_70460_b, stack, te, hasSmartModule, hasStorageModule, hasRedstoneModule) || InventoryScannerFieldBlock.loopInventory((NonNullList<ItemStack>)player.field_71071_by.field_184439_c, stack, te, hasSmartModule, hasStorageModule, hasRedstoneModule);
    }

    private static boolean loopInventory(NonNullList<ItemStack> inventory, ItemStack stack, InventoryScannerTileEntity te, boolean hasSmartModule, boolean hasStorageModule, boolean hasRedstoneModule) {
        for (int i = 1; i <= inventory.size(); ++i) {
            ItemStack itemStackChecking = (ItemStack)inventory.get(i - 1);
            if (itemStackChecking.func_190926_b()) continue;
            if (InventoryScannerFieldBlock.areItemsEqual(itemStackChecking, stack, hasSmartModule)) {
                if (hasStorageModule) {
                    te.addItemToStorage((ItemStack)inventory.get(i - 1));
                    inventory.set(i - 1, (Object)ItemStack.field_190927_a);
                }
                if (hasRedstoneModule) {
                    InventoryScannerFieldBlock.updateInventoryScannerPower(te);
                }
                return true;
            }
            if (!InventoryScannerFieldBlock.checkForShulkerBox(itemStackChecking, stack, te, hasSmartModule, hasStorageModule, hasRedstoneModule)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkItemEntity(ItemEntity entity, InventoryScannerTileEntity te, ItemStack stack, boolean allowInteraction) {
        boolean hasRedstoneModule;
        boolean hasSmartModule = te.hasModule(ModuleType.SMART);
        boolean hasStorageModule = allowInteraction && te.hasModule(ModuleType.STORAGE);
        boolean bl = hasRedstoneModule = allowInteraction && te.hasModule(ModuleType.REDSTONE);
        if (!hasRedstoneModule && !hasStorageModule && allowInteraction) {
            return false;
        }
        if (InventoryScannerFieldBlock.areItemsEqual(entity.func_92059_d(), stack, hasSmartModule)) {
            if (hasStorageModule) {
                te.addItemToStorage(entity.func_92059_d());
                entity.func_70106_y();
            }
            if (hasRedstoneModule) {
                InventoryScannerFieldBlock.updateInventoryScannerPower(te);
            }
            return true;
        }
        return InventoryScannerFieldBlock.checkForShulkerBox(entity.func_92059_d(), stack, te, hasSmartModule, hasStorageModule, hasRedstoneModule);
    }

    private static boolean checkForShulkerBox(ItemStack item, ItemStack stackToCheck, InventoryScannerTileEntity te, boolean hasSmartModule, boolean hasStorageModule, boolean hasRedstoneModule) {
        if (item != null && !item.func_190926_b() && item.func_77978_p() != null && Block.func_149634_a((Item)item.func_77973_b()) instanceof ShulkerBoxBlock) {
            ListNBT list = item.func_77978_p().func_74775_l("BlockEntityTag").func_150295_c("Items", 10);
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemInChest = ItemStack.func_199557_a((CompoundNBT)list.func_150305_b(i));
                if (!InventoryScannerFieldBlock.areItemsEqual(itemInChest, stackToCheck, hasSmartModule)) continue;
                if (hasStorageModule) {
                    te.addItemToStorage(itemInChest);
                    list.remove(i);
                }
                if (hasRedstoneModule) {
                    InventoryScannerFieldBlock.updateInventoryScannerPower(te);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean areItemsEqual(ItemStack firstItemStack, ItemStack secondItemStack, boolean hasSmartModule) {
        return hasSmartModule && InventoryScannerFieldBlock.areItemStacksEqual(firstItemStack, secondItemStack) && ItemStack.func_77970_a((ItemStack)firstItemStack, (ItemStack)secondItemStack) || !hasSmartModule && firstItemStack.func_77973_b() == secondItemStack.func_77973_b();
    }

    private static void updateInventoryScannerPower(InventoryScannerTileEntity te) {
        InventoryScannerTileEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(te.func_145831_w(), te.func_174877_v());
        if (connectedScanner == null) {
            return;
        }
        InventoryScannerFieldBlock.updateInvScanner(te);
        InventoryScannerFieldBlock.updateInvScanner(connectedScanner);
    }

    private static void updateInvScanner(InventoryScannerTileEntity te) {
        te.setShouldProvidePower(true);
        te.setCooldown(60);
        BlockUtils.updateAndNotify(te.func_145831_w(), te.func_174877_v(), te.func_195044_w().func_177230_c(), 1, true);
        BlockUtils.updateIndirectNeighbors(te.func_145831_w(), te.func_174877_v(), (Block)SCContent.INVENTORY_SCANNER.get());
    }

    public static boolean areItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        ItemStack s1 = stack1.func_77946_l();
        ItemStack s2 = stack2.func_77946_l();
        s1.func_190920_e(1);
        s2.func_190920_e(1);
        return ItemStack.func_77989_b((ItemStack)s1, (ItemStack)s2);
    }

    public void func_176206_d(IWorld world, BlockPos pos, BlockState state) {
        if (!world.func_201670_d()) {
            Direction facing = (Direction)state.func_177229_b((Property)FACING);
            if (facing == Direction.EAST || facing == Direction.WEST) {
                this.checkAndDestroyFields(world, pos, (p, i) -> p.func_177985_f(i.intValue()));
                this.checkAndDestroyFields(world, pos, (p, i) -> p.func_177965_g(i.intValue()));
            } else if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                this.checkAndDestroyFields(world, pos, (p, i) -> p.func_177964_d(i.intValue()));
                this.checkAndDestroyFields(world, pos, (p, i) -> p.func_177970_e(i.intValue()));
            }
        }
    }

    private void checkAndDestroyFields(IWorld world, BlockPos pos, BiFunction<BlockPos, Integer, BlockPos> posModifier) {
        for (int i = 0; i < (Integer)ConfigHandler.SERVER.inventoryScannerRange.get(); ++i) {
            BlockPos modifiedPos = posModifier.apply(pos, i);
            if (world.func_180495_p(modifiedPos).func_177230_c() != SCContent.INVENTORY_SCANNER.get()) continue;
            for (int j = 1; j < i; ++j) {
                world.func_175655_b(posModifier.apply(pos, j), false);
            }
            break;
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext ctx) {
        if (((Boolean)state.func_177229_b((Property)HORIZONTAL)).booleanValue()) {
            return HORIZONTAL_SHAPE;
        }
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        if (facing == Direction.EAST || facing == Direction.WEST) {
            return SHAPE_EW;
        }
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            return SHAPE_NS;
        }
        return VoxelShapes.func_197868_b();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, HORIZONTAL});
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return ItemStack.field_190927_a;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new OwnableTileEntity(SCContent.teTypeAbstract);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        if ((side == Direction.UP || side == Direction.DOWN) && state.func_177230_c() == adjacentBlockState.func_177230_c()) {
            return true;
        }
        return super.func_200122_a(state, adjacentBlockState, side);
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }
}

