/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class LaserFieldBlock
extends OwnableBlock {
    public static final IntegerProperty BOUNDTYPE = IntegerProperty.func_177719_a((String)"boundtype", (int)1, (int)3);
    private static final VoxelShape SHAPE_X = Block.func_208617_a((double)0.0, (double)6.75, (double)6.75, (double)16.0, (double)9.25, (double)9.25);
    private static final VoxelShape SHAPE_Y = Block.func_208617_a((double)6.75, (double)0.0, (double)6.75, (double)9.25, (double)16.0, (double)9.25);
    private static final VoxelShape SHAPE_Z = Block.func_208617_a((double)6.75, (double)6.75, (double)0.0, (double)9.25, (double)9.25, (double)16.0);

    public LaserFieldBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)BOUNDTYPE, (Comparable)Integer.valueOf(1)));
    }

    public VoxelShape func_220071_b(BlockState blockState, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return VoxelShapes.func_197880_a();
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K && entity instanceof LivingEntity && !EntityUtils.isInvisible((LivingEntity)entity)) {
            for (Direction facing : Direction.values()) {
                for (int i = 0; i < (Integer)ConfigHandler.SERVER.laserBlockRange.get(); ++i) {
                    BlockPos offsetPos = pos.func_177967_a(facing, i);
                    BlockState offsetState = world.func_180495_p(offsetPos);
                    Block offsetBlock = offsetState.func_177230_c();
                    if (offsetBlock != SCContent.LASER_BLOCK.get() || ((Boolean)offsetState.func_177229_b((Property)LaserBlock.POWERED)).booleanValue()) continue;
                    TileEntity te = world.func_175625_s(offsetPos);
                    if (te instanceof IModuleInventory && ModuleUtils.isAllowed((IModuleInventory)te, entity)) {
                        return;
                    }
                    world.func_175656_a(offsetPos, (BlockState)offsetState.func_206870_a((Property)LaserBlock.POWERED, (Comparable)Boolean.valueOf(true)));
                    BlockUtils.updateIndirectNeighbors(world, offsetPos, (Block)SCContent.LASER_BLOCK.get());
                    world.func_205220_G_().func_205360_a(offsetPos, (Object)SCContent.LASER_BLOCK.get(), 50);
                    if (!(te instanceof IModuleInventory) || !((IModuleInventory)te).hasModule(ModuleType.HARMING) || entity instanceof PlayerEntity && ((IOwnable)te).getOwner().isOwner((PlayerEntity)entity)) continue;
                    ((LivingEntity)entity).func_70097_a(CustomDamageSources.LASER, 10.0f);
                }
            }
        }
    }

    public void func_176206_d(IWorld world, BlockPos pos, BlockState state) {
        if (!world.func_201670_d()) {
            Direction[] facingArray;
            block0: for (Direction facing : facingArray = new Direction[]{Direction.func_82600_a((int)(((Integer)state.func_177229_b((Property)BOUNDTYPE) - 1) * 2)), Direction.func_82600_a((int)(((Integer)state.func_177229_b((Property)BOUNDTYPE) - 1) * 2)).func_176734_d()}) {
                for (int i = 0; i < (Integer)ConfigHandler.SERVER.laserBlockRange.get(); ++i) {
                    if (world.func_180495_p(pos.func_177967_a(facing, i)).func_177230_c() != SCContent.LASER_BLOCK.get()) continue;
                    for (int j = 1; j < i; ++j) {
                        world.func_175655_b(pos.func_177967_a(facing, j), false);
                    }
                    continue block0;
                }
            }
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext ctx) {
        if (source.func_180495_p(pos).func_177230_c() instanceof LaserFieldBlock) {
            int boundType = (Integer)source.func_180495_p(pos).func_177229_b((Property)BOUNDTYPE);
            if (boundType == 1) {
                return SHAPE_Y;
            }
            if (boundType == 2) {
                return SHAPE_Z;
            }
            if (boundType == 3) {
                return SHAPE_X;
            }
        }
        return VoxelShapes.func_197880_a();
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c, ctx.func_195999_j());
    }

    public BlockState getStateForPlacement(World world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, PlayerEntity placer) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BOUNDTYPE, (Comparable)Integer.valueOf(1));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BOUNDTYPE});
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return ItemStack.field_190927_a;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new OwnableTileEntity(SCContent.teTypeAbstract);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        int boundType = (Integer)state.func_177229_b((Property)BOUNDTYPE);
        return rot == Rotation.CLOCKWISE_180 ? state : (BlockState)state.func_206870_a((Property)BOUNDTYPE, (Comparable)Integer.valueOf(boundType == 2 ? 3 : (boundType == 3 ? 2 : 1)));
    }
}

