/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.tileentity.MotionActivatedLightTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class MotionActivatedLightBlock
extends OwnableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    private static final VoxelShape SHAPE_NORTH = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)3.0, (double)13.0, (double)10.0, (double)4.0, (double)14.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)13.0, (double)10.0, (double)9.0, (double)14.0), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)7.0, (double)3.0, (double)14.0, (double)9.0, (double)8.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)7.0, (double)4.0, (double)15.0, (double)9.0, (double)7.0, (double)14.0), (IBooleanFunction)IBooleanFunction.field_223234_e_)));
    private static final VoxelShape SHAPE_EAST = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)3.0, (double)6.0, (double)2.0, (double)4.0, (double)10.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)6.0, (double)6.0, (double)2.0, (double)9.0, (double)10.0), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)2.0, (double)3.0, (double)7.0, (double)0.0, (double)8.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)4.0, (double)7.0, (double)2.0, (double)7.0, (double)9.0), (IBooleanFunction)IBooleanFunction.field_223234_e_)));
    private static final VoxelShape SHAPE_SOUTH = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)3.0, (double)2.0, (double)10.0, (double)4.0, (double)3.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)2.0, (double)10.0, (double)9.0, (double)3.0), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)7.0, (double)3.0, (double)0.0, (double)9.0, (double)8.0, (double)2.0), (VoxelShape)Block.func_208617_a((double)7.0, (double)4.0, (double)1.0, (double)9.0, (double)7.0, (double)2.0), (IBooleanFunction)IBooleanFunction.field_223234_e_)));
    private static final VoxelShape SHAPE_WEST = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)13.0, (double)3.0, (double)6.0, (double)14.0, (double)4.0, (double)10.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)13.0, (double)6.0, (double)6.0, (double)14.0, (double)9.0, (double)10.0), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)14.0, (double)3.0, (double)7.0, (double)16.0, (double)8.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)15.0, (double)4.0, (double)7.0, (double)14.0, (double)7.0, (double)9.0), (IBooleanFunction)IBooleanFunction.field_223234_e_)));

    public MotionActivatedLightBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return VoxelShapes.func_197868_b();
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction side = (Direction)state.func_177229_b((Property)FACING);
        return side != Direction.UP && side != Direction.DOWN && BlockUtils.isSideSolid(world, pos.func_177972_a(side.func_176734_d()), side);
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c, ctx.func_195999_j());
    }

    public BlockState getStateForPlacement(World world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, PlayerEntity placer) {
        return facing != Direction.UP && facing != Direction.DOWN && BlockUtils.isSideSolid((IWorldReader)world, pos.func_177972_a(facing.func_176734_d()), facing) ? (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)facing) : null;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
        builder.func_206894_a(new Property[]{LIT});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new MotionActivatedLightTileEntity();
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (facing.func_176740_k() != Direction.Axis.Z) break;
                return (BlockState)state.func_206870_a((Property)FACING, (Comparable)facing.func_176734_d());
            }
            case FRONT_BACK: {
                if (facing.func_176740_k() != Direction.Axis.X) break;
                return (BlockState)state.func_206870_a((Property)FACING, (Comparable)facing.func_176734_d());
            }
        }
        return state;
    }
}

