/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.PortableRadarTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class PortableRadarBlock
extends OwnableBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    private static final VoxelShape SHAPE_UP = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0);
    private static final VoxelShape SHAPE_DOWN = Block.func_208617_a((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)0.0, (double)5.0, (double)5.0, (double)7.0, (double)11.0, (double)11.0);
    private static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)9.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    private static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)5.0, (double)5.0, (double)9.0, (double)11.0, (double)11.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)7.0);

    public PortableRadarBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.UP));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext ctx) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        switch (facing) {
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case UP: {
                return SHAPE_UP;
            }
            case DOWN: {
                return SHAPE_DOWN;
            }
        }
        return VoxelShapes.func_197868_b();
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        Direction facing = ctx.func_196000_l();
        return BlockUtils.isSideSolid((IWorldReader)ctx.func_195991_k(), ctx.func_195995_a().func_177972_a(facing.func_176734_d()), facing) ? (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)facing) : null;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        return BlockUtils.isSideSolid(world, pos.func_177972_a(facing.func_176734_d()), facing);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean flag) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    public static void togglePowerOutput(World world, BlockPos pos, boolean shouldPower) {
        BlockState state = world.func_180495_p(pos);
        if (shouldPower && !((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)));
            BlockUtils.updateIndirectNeighbors(world, pos, (Block)SCContent.PORTABLE_RADAR.get(), (Direction)state.func_177229_b((Property)FACING));
        } else if (!shouldPower && ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(world, pos, (Block)SCContent.PORTABLE_RADAR.get(), (Direction)state.func_177229_b((Property)FACING));
        }
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader world, BlockPos pos, Direction side) {
        if (((Boolean)blockState.func_177229_b((Property)POWERED)).booleanValue() && ((IModuleInventory)world.func_175625_s(pos)).hasModule(ModuleType.REDSTONE)) {
            return 15;
        }
        return 0;
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return (Boolean)state.func_177229_b((Property)POWERED) != false && ((IModuleInventory)world.func_175625_s(pos)).hasModule(ModuleType.REDSTONE) && state.func_177229_b((Property)FACING) == side ? 15 : 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWERED, FACING});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PortableRadarTileEntity();
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (facing.func_176740_k() != Direction.Axis.Z) break;
                return (BlockState)state.func_206870_a((Property)FACING, (Comparable)facing.func_176734_d());
            }
            case FRONT_BACK: {
                if (facing.func_176740_k() != Direction.Axis.X) break;
                return (BlockState)state.func_206870_a((Property)FACING, (Comparable)facing.func_176734_d());
            }
        }
        return state;
    }
}

