/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.geforcemods.securitycraft.blocks.mines.ExplosiveBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.EntitySelectionContext;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BaseFullMineBlock
extends ExplosiveBlock
implements IOverlayDisplay,
IBlockMine {
    private final Block blockDisguisedAs;

    public BaseFullMineBlock(AbstractBlock.Properties properties, Block disguisedBlock) {
        super(properties);
        this.blockDisguisedAs = disguisedBlock;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        if (ctx instanceof EntitySelectionContext) {
            OwnableTileEntity ownableTe;
            TileEntity te;
            Entity entity = ((EntitySelectionContext)ctx).getEntity();
            if (entity instanceof ItemEntity) {
                return VoxelShapes.func_197868_b();
            }
            if (entity instanceof PlayerEntity && (te = world.func_175625_s(pos)) instanceof OwnableTileEntity && (ownableTe = (OwnableTileEntity)te).getOwner().isOwner((PlayerEntity)entity)) {
                return VoxelShapes.func_197868_b();
            }
            return ctx == ISelectionContext.func_216377_a() ? VoxelShapes.func_197868_b() : VoxelShapes.func_197880_a();
        }
        return VoxelShapes.func_197868_b();
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!EntityUtils.doesEntityOwn(entity, world, pos)) {
            this.explode(world, pos);
        }
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K) {
            if (pos.equals((Object)new BlockPos(explosion.getPosition()))) {
                return;
            }
            this.explode(world, pos);
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (!world.field_72995_K) {
            if (player != null && player.func_184812_l_() && !((Boolean)ConfigHandler.SERVER.mineExplodesWhenInCreative.get()).booleanValue()) {
                return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
            }
            if (!EntityUtils.doesPlayerOwn(player, world, pos)) {
                this.explode(world, pos);
                return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    @Override
    public boolean activateMine(World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean defuseMine(World world, BlockPos pos) {
        return false;
    }

    @Override
    public void explode(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            world.func_175655_b(pos, false);
            world.func_217398_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 2.5f : 5.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionMode());
        }
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean explodesWhenInteractedWith() {
        return false;
    }

    @Override
    public boolean isDefusable() {
        return false;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new OwnableTileEntity(SCContent.teTypeAbstract);
    }

    @Override
    public ItemStack getDisplayStack(World world, BlockState state, BlockPos pos) {
        return new ItemStack((IItemProvider)this.blockDisguisedAs);
    }

    @Override
    public boolean shouldShowSCInfo(World world, BlockState state, BlockPos pos) {
        return false;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (world.func_175625_s(pos) instanceof OwnableTileEntity) {
            OwnableTileEntity te = (OwnableTileEntity)world.func_175625_s(pos);
            if (player.func_184812_l_() || te.getOwner().isOwner(player)) {
                return super.getPickBlock(state, target, world, pos, player);
            }
        }
        return new ItemStack((IItemProvider)this.blockDisguisedAs);
    }

    public Block getBlockDisguisedAs() {
        return this.blockDisguisedAs;
    }
}

