/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.geforcemods.securitycraft.blocks.mines.ExplosiveBlock;
import net.geforcemods.securitycraft.entity.BouncingBettyEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class BouncingBettyBlock
extends ExplosiveBlock {
    public static final BooleanProperty DEACTIVATED = BooleanProperty.func_177716_a((String)"deactivated");
    private static final VoxelShape SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0);

    public BouncingBettyBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean flag) {
        if (!world.func_180495_p(pos.func_177977_b()).func_196958_f()) {
            return;
        }
        if (((Boolean)world.func_180495_p(pos).func_177229_b((Property)DEACTIVATED)).booleanValue()) {
            world.func_175655_b(pos, true);
        } else {
            this.explode(world, pos);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return BlockUtils.isSideSolid(world, pos.func_177977_b(), Direction.UP);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!EntityUtils.doesEntityOwn(entity, world, pos)) {
            this.explode(world, pos);
        }
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        if (!player.func_184812_l_() && !EntityUtils.doesPlayerOwn(player, world, pos)) {
            this.explode(world, pos);
        }
    }

    @Override
    public boolean activateMine(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (((Boolean)state.func_177229_b((Property)DEACTIVATED)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
            return true;
        }
        return false;
    }

    @Override
    public boolean defuseMine(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (!((Boolean)state.func_177229_b((Property)DEACTIVATED)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    @Override
    public void explode(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        if (((Boolean)world.func_180495_p(pos).func_177229_b((Property)DEACTIVATED)).booleanValue()) {
            return;
        }
        world.func_175655_b(pos, false);
        BouncingBettyEntity entitytntprimed = new BouncingBettyEntity(world, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f);
        entitytntprimed.fuse = 15;
        entitytntprimed.func_213317_d(entitytntprimed.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72441_c(0.0, 0.5, 0.0));
        WorldUtils.addScheduledTask((IWorld)world, () -> world.func_217376_c((Entity)entitytntprimed));
        entitytntprimed.func_184185_a((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.tnt.primed")), 1.0f, 1.0f);
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this.func_199767_j());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DEACTIVATED});
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((Property)DEACTIVATED) == false;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new OwnableTileEntity(SCContent.teTypeAbstract);
    }
}

