/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.geforcemods.securitycraft.blocks.mines.ExplosiveBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class MineBlock
extends ExplosiveBlock {
    public static final BooleanProperty DEACTIVATED = BooleanProperty.func_177716_a((String)"deactivated");
    private static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);

    public MineBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean flag) {
        if (world.func_180495_p(pos.func_177977_b()).func_185904_a() != Material.field_151579_a) {
            return;
        }
        if (((Boolean)world.func_180495_p(pos).func_177229_b((Property)DEACTIVATED)).booleanValue()) {
            world.func_175655_b(pos, true);
        } else {
            this.explode(world, pos);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return BlockUtils.isSideSolid(world, pos.func_177977_b(), Direction.UP);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (!world.field_72995_K) {
            if (player != null && player.func_184812_l_() && !((Boolean)ConfigHandler.SERVER.mineExplodesWhenInCreative.get()).booleanValue()) {
                return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
            }
            if (!EntityUtils.doesPlayerOwn(player, world, pos)) {
                this.explode(world, pos);
                return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        if (entity instanceof ItemEntity) {
            return;
        }
        if (!EntityUtils.doesEntityOwn(entity, world, pos)) {
            this.explode(world, pos);
        }
    }

    @Override
    public boolean activateMine(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (((Boolean)state.func_177229_b((Property)DEACTIVATED)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
            return true;
        }
        return false;
    }

    @Override
    public boolean defuseMine(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (!((Boolean)state.func_177229_b((Property)DEACTIVATED)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    @Override
    public void explode(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        if (!((Boolean)world.func_180495_p(pos).func_177229_b((Property)DEACTIVATED)).booleanValue()) {
            world.func_175655_b(pos, false);
            world.func_217398_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 1.0f : 3.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionMode());
        }
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)((Block)SCContent.MINE.get()).func_199767_j());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DEACTIVATED});
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((Property)DEACTIVATED) == false;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new OwnableTileEntity();
    }
}

