/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCTags;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.BushBlock;
import net.minecraft.block.DeadBushBlock;
import net.minecraft.block.FungusBlock;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.block.NetherRootsBlock;
import net.minecraft.block.NetherSproutsBlock;
import net.minecraft.block.WitherRoseBlock;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class BaseReinforcedBlock
extends OwnableBlock
implements IReinforcedBlock {
    private final Supplier<Block> vanillaBlockSupplier;

    public BaseReinforcedBlock(AbstractBlock.Properties properties, Block vB) {
        this(properties, () -> vB);
    }

    public BaseReinforcedBlock(AbstractBlock.Properties properties, Supplier<Block> vB) {
        super(properties);
        this.vanillaBlockSupplier = vB;
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState plant = plantable.getPlant(world, pos.func_177972_a(facing));
        PlantType type = plantable.getPlantType(world, pos.func_177972_a(facing));
        if (super.canSustainPlant(state, world, pos, facing, plantable)) {
            return true;
        }
        if (plant.func_177230_c() == Blocks.field_150434_aF) {
            return this == SCContent.REINFORCED_SAND.get() || this == SCContent.REINFORCED_RED_SAND.get();
        }
        if (plantable instanceof BushBlock) {
            boolean bushCondition;
            boolean bl = bushCondition = state.func_203425_a((Block)SCContent.REINFORCED_GRASS_BLOCK.get()) || state.func_203425_a((Block)SCContent.REINFORCED_DIRT.get()) || state.func_203425_a((Block)SCContent.REINFORCED_COARSE_DIRT.get()) || state.func_203425_a((Block)SCContent.REINFORCED_PODZOL.get());
            if (plantable instanceof NetherSproutsBlock || plantable instanceof NetherRootsBlock) {
                return state.func_203425_a((Block)SCContent.REINFORCED_SOUL_SOIL.get()) || bushCondition;
            }
            if (plantable instanceof FungusBlock) {
                return state.func_203425_a((Block)SCContent.REINFORCED_MYCELIUM.get()) || state.func_203425_a((Block)SCContent.REINFORCED_SOUL_SOIL.get()) || bushCondition;
            }
            if (plantable instanceof LilyPadBlock) {
                return world.func_204610_c(pos).func_206886_c() == SCContent.FAKE_WATER.get() && world.func_204610_c(pos.func_177984_a()).func_206886_c() == Fluids.field_204541_a;
            }
            if (plantable instanceof WitherRoseBlock) {
                return state.func_203425_a((Block)SCContent.REINFORCED_NETHERRACK.get()) || state.func_203425_a((Block)SCContent.REINFORCED_SOUL_SOIL.get());
            }
            if (plantable instanceof DeadBushBlock) {
                return state.func_235714_a_(SCTags.Blocks.REINFORCED_SAND) || state.func_203425_a((Block)SCContent.REINFORCED_TERRACOTTA.get()) || state.func_203425_a((Block)SCContent.REINFORCED_WHITE_TERRACOTTA.get()) || state.func_203425_a((Block)SCContent.REINFORCED_ORANGE_TERRACOTTA.get()) || state.func_203425_a((Block)SCContent.REINFORCED_MAGENTA_TERRACOTTA.get()) || state.func_203425_a((Block)SCContent.REINFORCED_LIGHT_BLUE_TERRACOTTA.get()) || state.func_203425_a((Block)SCContent.REINFORCED_YELLOW_TERRACOTTA.get()) || state.func_203425_a((Block)SCContent.REINFORCED_LIME_TERRACOTTA.get()) || state.func_203425_a((Block)SCContent.REINFORCED_PINK_TERRACOTTA.get()) || state.func_203425_a((Block)SCContent.REINFORCED_GRAY_TERRACOTTA.get()) || state.func_203425_a((Block)SCContent.REINFORCED_LIGHT_GRAY_TERRACOTTA.get()) || state.func_203425_a((Block)SCContent.REINFORCED_CYAN_TERRACOTTA.get()) || state.func_203425_a((Block)SCContent.REINFORCED_PURPLE_TERRACOTTA.get()) || state.func_203425_a((Block)SCContent.REINFORCED_BLUE_TERRACOTTA.get()) || state.func_203425_a((Block)SCContent.REINFORCED_BROWN_TERRACOTTA.get()) || state.func_203425_a((Block)SCContent.REINFORCED_GREEN_TERRACOTTA.get()) || state.func_203425_a((Block)SCContent.REINFORCED_RED_TERRACOTTA.get()) || state.func_203425_a((Block)SCContent.REINFORCED_BLACK_TERRACOTTA.get()) || state.func_203425_a((Block)SCContent.REINFORCED_DIRT.get()) || state.func_203425_a((Block)SCContent.REINFORCED_COARSE_DIRT.get()) || state.func_203425_a((Block)SCContent.REINFORCED_PODZOL.get());
            }
        }
        if (type == PlantType.DESERT) {
            return this == SCContent.REINFORCED_SAND.get() || this == SCContent.REINFORCED_RED_SAND.get();
        }
        if (type == PlantType.BEACH) {
            boolean isBeach = state.func_235714_a_(SCTags.Blocks.REINFORCED_SAND);
            boolean hasWater = false;
            for (Direction face : Direction.Plane.HORIZONTAL) {
                BlockState blockState = world.func_180495_p(pos.func_177972_a(face));
                FluidState fluidState = world.func_204610_c(pos.func_177972_a(face));
                hasWater |= blockState.func_203425_a(Blocks.field_185778_de);
                if (!(hasWater |= fluidState.func_206884_a((ITag)FluidTags.field_206959_a))) continue;
                break;
            }
            return isBeach && hasWater;
        }
        return false;
    }

    public boolean isConduitFrame(BlockState state, IWorldReader world, BlockPos pos, BlockPos conduit) {
        return this == SCContent.REINFORCED_PRISMARINE.get() || this == SCContent.REINFORCED_PRISMARINE_BRICKS.get() || this == SCContent.REINFORCED_SEA_LANTERN.get() || this == SCContent.REINFORCED_DARK_PRISMARINE.get();
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (this.getVanillaBlock() instanceof BreakableBlock) {
            return adjacentBlockState.func_177230_c() == this ? true : super.func_200122_a(state, adjacentBlockState, side);
        }
        return false;
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlockSupplier.get();
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return this.func_176223_P();
    }
}

