/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedMovingPistonBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.ReinforcedPistonTileEntity;
import net.geforcemods.securitycraft.tileentity.ValidationOwnableTileEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.ReinforcedPistonBlockStructureHelper;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.MovingPistonBlock;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.PistonType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;

public class ReinforcedPistonBlock
extends PistonBlock
implements IReinforcedBlock {
    public ReinforcedPistonBlock(boolean sticky, AbstractBlock.Properties properties) {
        super(sticky, properties);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof PlayerEntity) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (PlayerEntity)placer));
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        Owner owner;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof OwnableTileEntity && !(owner = ((OwnableTileEntity)te).getOwner()).isValidated()) {
            if (owner.isOwner(player)) {
                owner.setValidated(true);
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(this.func_149739_a(), new Object[0]), (IFormattableTextComponent)new TranslationTextComponent("messages.securitycraft:ownable.validate"), TextFormatting.GREEN);
                return ActionResultType.SUCCESS;
            }
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(this.func_149739_a(), new Object[0]), (IFormattableTextComponent)new TranslationTextComponent("messages.securitycraft:ownable.ownerNotValidated"), TextFormatting.RED);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_176316_e(World world, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.func_177229_b((Property)field_176387_N);
        boolean hasSignal = this.shouldBeExtended(world, pos, direction);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof OwnableTileEntity && !((OwnableTileEntity)te).getOwner().isValidated()) {
            return;
        }
        if (hasSignal && !((Boolean)state.func_177229_b((Property)field_176320_b)).booleanValue()) {
            if (new ReinforcedPistonBlockStructureHelper(world, pos, direction, true).canMove()) {
                world.func_175641_c(pos, (Block)this, 0, direction.func_176745_a());
            }
        } else if (!hasSignal && ((Boolean)state.func_177229_b((Property)field_176320_b)).booleanValue()) {
            ReinforcedPistonTileEntity pistontileentity;
            TileEntity tileentity;
            BlockPos offsetPos = pos.func_177967_a(direction, 2);
            BlockState offsetState = world.func_180495_p(offsetPos);
            int i = 1;
            if (offsetState.func_203425_a((Block)SCContent.REINFORCED_MOVING_PISTON.get()) && offsetState.func_177229_b((Property)field_176387_N) == direction && (tileentity = world.func_175625_s(offsetPos)) instanceof ReinforcedPistonTileEntity && (pistontileentity = (ReinforcedPistonTileEntity)tileentity).isExtending() && (pistontileentity.getProgress(0.0f) < 0.5f || world.func_82737_E() == pistontileentity.getLastTicked() || ((ServerWorld)world).func_211158_j_())) {
                i = 2;
            }
            world.func_175641_c(pos, (Block)this, i, direction.func_176745_a());
        }
    }

    private boolean shouldBeExtended(World world, BlockPos pos, Direction direction) {
        for (Direction dir : Direction.values()) {
            if (dir == direction || !world.func_175709_b(pos.func_177972_a(dir), dir)) continue;
            return true;
        }
        if (world.func_175709_b(pos, Direction.DOWN)) {
            return true;
        }
        BlockPos posAbove = pos.func_177984_a();
        for (Direction dir : Direction.values()) {
            if (dir == Direction.DOWN || !world.func_175709_b(posAbove.func_177972_a(dir), dir)) continue;
            return true;
        }
        return false;
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int id, int param) {
        Direction direction = (Direction)state.func_177229_b((Property)field_176387_N);
        if (!world.field_72995_K) {
            boolean isPowered = this.shouldBeExtended(world, pos, direction);
            if (isPowered && (id == 1 || id == 2)) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)field_176320_b, (Comparable)Boolean.valueOf(true)), 2);
                return false;
            }
            if (!isPowered && id == 0) {
                return false;
            }
        }
        if (id == 0) {
            if (ForgeEventFactory.onPistonMovePre((World)world, (BlockPos)pos, (Direction)direction, (boolean)true)) {
                return false;
            }
            if (!this.doMove(world, pos, direction, true)) {
                return false;
            }
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)field_176320_b, (Comparable)Boolean.valueOf(true)), 67);
            world.func_184133_a(null, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.6f);
        } else if (id == 1 || id == 2) {
            if (ForgeEventFactory.onPistonMovePre((World)world, (BlockPos)pos, (Direction)direction, (boolean)false)) {
                return false;
            }
            TileEntity pistonTE = world.func_175625_s(pos.func_177972_a(direction));
            if (pistonTE instanceof ReinforcedPistonTileEntity) {
                ((ReinforcedPistonTileEntity)pistonTE).clearPistonTileEntity();
            }
            TileEntity te = world.func_175625_s(pos);
            BlockState movingPiston = (BlockState)((BlockState)((Block)SCContent.REINFORCED_MOVING_PISTON.get()).func_176223_P().func_206870_a((Property)MovingPistonBlock.field_196344_a, (Comparable)direction)).func_206870_a((Property)MovingPistonBlock.field_196345_b, (Comparable)(this.field_150082_a ? PistonType.STICKY : PistonType.DEFAULT));
            world.func_180501_a(pos, movingPiston, 20);
            world.func_175690_a(pos, ReinforcedMovingPistonBlock.createTilePiston((BlockState)this.func_176223_P().func_206870_a((Property)field_176387_N, (Comparable)Direction.func_82600_a((int)(param & 7))), te != null ? te.func_189517_E_() : null, direction, false, true));
            world.func_230547_a_(pos, movingPiston.func_177230_c());
            movingPiston.func_235734_a_((IWorld)world, pos, 2);
            if (this.field_150082_a) {
                ReinforcedPistonTileEntity pistonTe;
                TileEntity offsetTe;
                BlockPos offsetPos = pos.func_177982_a(direction.func_82601_c() * 2, direction.func_96559_d() * 2, direction.func_82599_e() * 2);
                BlockState offsetState = world.func_180495_p(offsetPos);
                boolean flag = false;
                if (offsetState.func_203425_a((Block)SCContent.REINFORCED_MOVING_PISTON.get()) && (offsetTe = world.func_175625_s(offsetPos)) instanceof ReinforcedPistonTileEntity && (pistonTe = (ReinforcedPistonTileEntity)offsetTe).getFacing() == direction && pistonTe.isExtending()) {
                    pistonTe.clearPistonTileEntity();
                    flag = true;
                }
                if (!flag) {
                    if (id != 1 || offsetState.func_196958_f() || !ReinforcedPistonBlock.canPush(offsetState, world, pos, offsetPos, direction.func_176734_d(), false, direction) || offsetState.func_185905_o() != PushReaction.NORMAL && !offsetState.func_203425_a((Block)SCContent.REINFORCED_PISTON.get()) && !offsetState.func_203425_a((Block)SCContent.REINFORCED_STICKY_PISTON.get())) {
                        world.func_217377_a(pos.func_177972_a(direction), false);
                    } else {
                        this.doMove(world, pos, direction, false);
                    }
                }
            } else {
                world.func_217377_a(pos.func_177972_a(direction), false);
            }
            world.func_184133_a(null, pos, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.15f + 0.6f);
        }
        ForgeEventFactory.onPistonMovePost((World)world, (BlockPos)pos, (Direction)direction, (id == 0 ? 1 : 0) != 0);
        return true;
    }

    public static boolean canPush(BlockState state, World world, BlockPos pistonPos, BlockPos pos, Direction facing, boolean destroyBlocks, Direction direction) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < world.func_217301_I() && world.func_175723_af().func_177746_a(pos)) {
            if (state.func_196958_f()) {
                return true;
            }
            if (!(state.func_203425_a(Blocks.field_150343_Z) || state.func_203425_a(Blocks.field_235399_ni_) || state.func_203425_a(Blocks.field_235400_nj_) || state.func_203425_a((Block)SCContent.REINFORCED_OBSIDIAN.get()) || state.func_203425_a((Block)SCContent.REINFORCED_CRYING_OBSIDIAN.get()))) {
                if (facing == Direction.DOWN && pos.func_177956_o() == 0 || facing == Direction.UP && pos.func_177956_o() == world.func_217301_I() - 1) {
                    return false;
                }
                if (!(state.func_203425_a(Blocks.field_150331_J) || state.func_203425_a(Blocks.field_150320_F) || state.func_203425_a((Block)SCContent.REINFORCED_PISTON.get()) || state.func_203425_a((Block)SCContent.REINFORCED_STICKY_PISTON.get()))) {
                    if (state.func_177230_c() instanceof IReinforcedBlock ? !ReinforcedPistonBlock.isSameOwner(pos, pistonPos, world) : state.func_185887_b((IBlockReader)world, pos) == -1.0f) {
                        return false;
                    }
                    switch (state.func_185905_o()) {
                        case BLOCK: {
                            return false;
                        }
                        case DESTROY: {
                            return destroyBlocks;
                        }
                        case PUSH_ONLY: {
                            return facing == direction;
                        }
                    }
                } else if (((Boolean)state.func_177229_b((Property)field_176320_b)).booleanValue()) {
                    return false;
                }
                return !state.hasTileEntity() || state.func_177230_c() instanceof IReinforcedBlock;
            }
        }
        return false;
    }

    private boolean doMove(World world, BlockPos pos, Direction facing, boolean extending) {
        ReinforcedPistonBlockStructureHelper structureHelper;
        BlockPos frontPos = pos.func_177972_a(facing);
        TileEntity pistonTe = world.func_175625_s(pos);
        if (!extending && world.func_180495_p(frontPos).func_203425_a((Block)SCContent.REINFORCED_PISTON_HEAD.get())) {
            world.func_180501_a(frontPos, Blocks.field_150350_a.func_176223_P(), 20);
        }
        if (!(structureHelper = new ReinforcedPistonBlockStructureHelper(world, pos, facing, extending)).canMove()) {
            return false;
        }
        HashMap stateToPosMap = Maps.newHashMap();
        List<BlockPos> blocksToMove = structureHelper.getBlocksToMove();
        ArrayList statesToMove = Lists.newArrayList();
        for (int i = 0; i < blocksToMove.size(); ++i) {
            BlockPos posToMove = blocksToMove.get(i);
            BlockState stateToMove = world.func_180495_p(posToMove);
            statesToMove.add(stateToMove);
            stateToPosMap.put(posToMove, stateToMove);
        }
        List<BlockPos> blocksToDestroy = structureHelper.getBlocksToDestroy();
        BlockState[] updatedBlocks = new BlockState[blocksToMove.size() + blocksToDestroy.size()];
        Direction direction = extending ? facing : facing.func_176734_d();
        int j = 0;
        for (int k = blocksToDestroy.size() - 1; k >= 0; --k) {
            BlockPos posToDestroy = blocksToDestroy.get(k);
            BlockState blockState = world.func_180495_p(posToDestroy);
            TileEntity teToDestroy = blockState.hasTileEntity() ? world.func_175625_s(posToDestroy) : null;
            ReinforcedPistonBlock.func_220059_a((BlockState)blockState, (IWorld)world, (BlockPos)posToDestroy, (TileEntity)teToDestroy);
            world.func_180501_a(posToDestroy, Blocks.field_150350_a.func_176223_P(), 18);
            updatedBlocks[j++] = blockState;
        }
        for (int l = blocksToMove.size() - 1; l >= 0; --l) {
            BlockPos posToMove = blocksToMove.get(l);
            BlockState blockState = world.func_180495_p(posToMove);
            TileEntity teToMove = world.func_175625_s(posToMove);
            CompoundNBT tag = null;
            if (teToMove != null) {
                tag = new CompoundNBT();
                teToMove.func_174878_a(posToMove.func_177972_a(direction));
                teToMove.func_189515_b(tag);
            }
            posToMove = posToMove.func_177972_a(direction);
            stateToPosMap.remove(posToMove);
            world.func_180501_a(posToMove, (BlockState)((Block)SCContent.REINFORCED_MOVING_PISTON.get()).func_176223_P().func_206870_a((Property)field_176387_N, (Comparable)facing), 68);
            world.func_175690_a(posToMove, ReinforcedMovingPistonBlock.createTilePiston((BlockState)statesToMove.get(l), tag, facing, extending, false));
            updatedBlocks[j++] = blockState;
        }
        if (extending) {
            PistonType type = this.field_150082_a ? PistonType.STICKY : PistonType.DEFAULT;
            Iterator<Object> pistonHead = (BlockState)((BlockState)((Block)SCContent.REINFORCED_PISTON_HEAD.get()).func_176223_P().func_206870_a((Property)PistonHeadBlock.field_176387_N, (Comparable)facing)).func_206870_a((Property)PistonHeadBlock.field_176325_b, (Comparable)type);
            BlockState blockState = (BlockState)((BlockState)((Block)SCContent.REINFORCED_MOVING_PISTON.get()).func_176223_P().func_206870_a((Property)MovingPistonBlock.field_196344_a, (Comparable)facing)).func_206870_a((Property)MovingPistonBlock.field_196345_b, (Comparable)(this.field_150082_a ? PistonType.STICKY : PistonType.DEFAULT));
            OwnableTileEntity headTe = new OwnableTileEntity();
            if (pistonTe instanceof OwnableTileEntity) {
                headTe.setOwner(((OwnableTileEntity)pistonTe).getOwner().getUUID(), ((OwnableTileEntity)pistonTe).getOwner().getName());
            }
            stateToPosMap.remove(frontPos);
            world.func_180501_a(frontPos, blockState, 68);
            world.func_175690_a(frontPos, ReinforcedMovingPistonBlock.createTilePiston(pistonHead, headTe.func_189517_E_(), facing, true, true));
        }
        BlockState air = Blocks.field_150350_a.func_176223_P();
        for (BlockPos blockPos : stateToPosMap.keySet()) {
            world.func_180501_a(blockPos, air, 82);
        }
        for (Map.Entry entry : stateToPosMap.entrySet()) {
            BlockPos posToUpdate = (BlockPos)entry.getKey();
            BlockState stateToUpdate = (BlockState)entry.getValue();
            stateToUpdate.func_196948_b((IWorld)world, posToUpdate, 2);
            air.func_235734_a_((IWorld)world, posToUpdate, 2);
            air.func_196948_b((IWorld)world, posToUpdate, 2);
        }
        j = 0;
        for (int i1 = blocksToDestroy.size() - 1; i1 >= 0; --i1) {
            BlockState blockState = updatedBlocks[j++];
            BlockPos posToDestroy = blocksToDestroy.get(i1);
            blockState.func_196948_b((IWorld)world, posToDestroy, 2);
            world.func_195593_d(posToDestroy, blockState.func_177230_c());
        }
        for (int j1 = blocksToMove.size() - 1; j1 >= 0; --j1) {
            world.func_195593_d(blocksToMove.get(j1), updatedBlocks[j++].func_177230_c());
        }
        if (extending) {
            world.func_195593_d(frontPos, (Block)SCContent.REINFORCED_PISTON_HEAD.get());
        }
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ValidationOwnableTileEntity();
    }

    @Override
    public Block getVanillaBlock() {
        return this.field_150082_a ? Blocks.field_150320_F : Blocks.field_150331_J;
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_176387_N, vanillaState.func_177229_b((Property)field_176387_N))).func_206870_a((Property)field_176320_b, vanillaState.func_177229_b((Property)field_176320_b));
    }

    private static boolean isSameOwner(BlockPos blockPos, BlockPos pistonPos, World world) {
        TileEntity pistonTE = world.func_175625_s(pistonPos);
        IOwnable blockTE = (IOwnable)world.func_175625_s(blockPos);
        if (pistonTE instanceof IOwnable) {
            return blockTE.getOwner().owns((IOwnable)pistonTE);
        }
        return false;
    }
}

