/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.AllowlistOnlyTileEntity;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ReinforcedPressurePlateBlock
extends PressurePlateBlock
implements IReinforcedBlock {
    private final Block vanillaBlock;

    public ReinforcedPressurePlateBlock(PressurePlateBlock.Sensitivity sensitivity, AbstractBlock.Properties properties, Block vanillaBlock) {
        super(sensitivity, properties);
        this.vanillaBlock = vanillaBlock;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        TileEntity te;
        int redstoneStrength = this.func_176576_e(state);
        if (!world.field_72995_K && redstoneStrength == 0 && entity instanceof PlayerEntity && (te = world.func_175625_s(pos)) instanceof AllowlistOnlyTileEntity && this.isAllowedToPress(world, pos, (AllowlistOnlyTileEntity)te, (PlayerEntity)entity)) {
            this.func_180666_a(world, pos, state, redstoneStrength);
        }
    }

    protected int func_180669_e(World world, BlockPos pos) {
        TileEntity te;
        AxisAlignedBB aabb = field_185511_c.func_186670_a(pos);
        List list = world.func_72839_b(null, aabb);
        if (!list.isEmpty() && (te = world.func_175625_s(pos)) instanceof AllowlistOnlyTileEntity) {
            for (Entity entity : list) {
                if (!(entity instanceof PlayerEntity) || !this.isAllowedToPress(world, pos, (AllowlistOnlyTileEntity)te, (PlayerEntity)entity)) continue;
                return 15;
            }
        }
        return 0;
    }

    public boolean isAllowedToPress(World world, BlockPos pos, AllowlistOnlyTileEntity te, PlayerEntity entity) {
        return te.getOwner().isOwner(entity) || ModuleUtils.isAllowed((IModuleInventory)te, (Entity)entity);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof PlayerEntity) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (PlayerEntity)placer));
        }
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlock;
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return this.func_176223_P();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new AllowlistOnlyTileEntity();
    }

    public static class DoorActivator
    implements IDoorActivator {
        private final List<Block> blocks = Arrays.asList((Block)SCContent.REINFORCED_STONE_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_OAK_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_SPRUCE_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_BIRCH_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_JUNGLE_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_ACACIA_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_DARK_OAK_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_CRIMSON_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_WARPED_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_POLISHED_BLACKSTONE_PRESSURE_PLATE.get());

        @Override
        public boolean isPowering(World world, BlockPos pos, BlockState state, TileEntity te, Direction direction, int distance) {
            return (Boolean)state.func_177229_b((Property)PressurePlateBlock.field_176580_a) != false && (distance < 2 || direction == Direction.UP);
        }

        @Override
        public List<Block> getBlocks() {
            return this.blocks;
        }
    }
}

