/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.geforcemods.securitycraft.blocks.reinforced.BaseReinforcedBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ReinforcedStairsBlock
extends BaseReinforcedBlock
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<Half> HALF = BlockStateProperties.field_208164_Q;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.field_208146_au;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape AABB_SLAB_TOP = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_SLAB_BOTTOM = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NWD_CORNER = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
    protected static final VoxelShape SWD_CORNER = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NWU_CORNER = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SWU_CORNER = Block.func_208617_a((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NED_CORNER = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    protected static final VoxelShape SED_CORNER = Block.func_208617_a((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NEU_CORNER = Block.func_208617_a((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SEU_CORNER = Block.func_208617_a((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape[] SLAB_TOP_SHAPES = ReinforcedStairsBlock.makeShapes(AABB_SLAB_TOP, NWD_CORNER, NED_CORNER, SWD_CORNER, SED_CORNER);
    protected static final VoxelShape[] SLAB_BOTTOM_SHAPES = ReinforcedStairsBlock.makeShapes(AABB_SLAB_BOTTOM, NWU_CORNER, NEU_CORNER, SWU_CORNER, SEU_CORNER);
    private static final int[] field_196522_K = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    private final Block modelBlock;
    private final BlockState modelState;

    public ReinforcedStairsBlock(AbstractBlock.Properties properties, Block vB) {
        this(properties, () -> vB);
    }

    public ReinforcedStairsBlock(AbstractBlock.Properties properties, Supplier<Block> vB) {
        super(properties, vB);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(HALF, (Comparable)Half.BOTTOM)).func_206870_a(SHAPE, (Comparable)StairsShape.STRAIGHT)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.modelBlock = this.getVanillaBlock();
        this.modelState = this.modelBlock.func_176223_P();
    }

    private static VoxelShape[] makeShapes(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(shape -> ReinforcedStairsBlock.combineShapes(shape, slabShape, nwCorner, neCorner, swCorner, seCorner)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape combineShapes(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        VoxelShape shape = slabShape;
        if ((bitfield & 1) != 0) {
            shape = VoxelShapes.func_197872_a((VoxelShape)slabShape, (VoxelShape)nwCorner);
        }
        if ((bitfield & 2) != 0) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)neCorner);
        }
        if ((bitfield & 4) != 0) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)swCorner);
        }
        if ((bitfield & 8) != 0) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)seCorner);
        }
        return shape;
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (state.func_177229_b(HALF) == Half.TOP ? SLAB_TOP_SHAPES : SLAB_BOTTOM_SHAPES)[field_196522_K[this.func_196511_x(state)]];
    }

    private int func_196511_x(BlockState state) {
        return ((StairsShape)state.func_177229_b(SHAPE)).ordinal() * 4 + ((Direction)state.func_177229_b((Property)FACING)).func_176736_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        this.modelBlock.func_180655_c(stateIn, worldIn, pos, rand);
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        this.modelState.func_196942_a(worldIn, pos, player);
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, BlockState state) {
        this.modelBlock.func_176206_d(worldIn, pos, state);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.func_177230_c() != oldState.func_177230_c()) {
            this.modelState.func_215697_a(world, pos, Blocks.field_150350_a, pos, false);
            this.modelBlock.func_220082_b(this.modelState, world, pos, oldState, false);
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.modelState.func_196947_b(world, pos, newState, isMoving);
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entity) {
        this.modelBlock.func_176199_a(worldIn, pos, entity);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        this.modelState.func_227033_a_(world, pos, random);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return this.modelState.func_227031_a_(world, player, hand, hit);
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        this.modelBlock.func_180652_a(world, pos, explosion);
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        Direction dir = ctx.func_196000_l();
        BlockPos pos = ctx.func_195995_a();
        FluidState fluidState = ctx.func_195991_k().func_204610_c(pos);
        BlockState state = (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)ctx.func_195992_f())).func_206870_a(HALF, (Comparable)(!(dir == Direction.DOWN || dir != Direction.UP && ctx.func_221532_j().field_72448_b - (double)pos.func_177956_o() > 0.5) ? Half.BOTTOM : Half.TOP))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
        return (BlockState)state.func_206870_a(SHAPE, (Comparable)ReinforcedStairsBlock.getShapeProperty(state, (IBlockReader)ctx.func_195991_k(), pos));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return facing.func_176740_k().func_176722_c() ? (BlockState)state.func_206870_a(SHAPE, (Comparable)ReinforcedStairsBlock.getShapeProperty(state, (IBlockReader)world, currentPos)) : super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    private static StairsShape getShapeProperty(BlockState state, IBlockReader world, BlockPos pos) {
        Direction offsetOppositeDir;
        Direction offsetDir;
        Direction dir = (Direction)state.func_177229_b((Property)FACING);
        BlockState offsetState = world.func_180495_p(pos.func_177972_a(dir));
        if (ReinforcedStairsBlock.isBlockStairs(offsetState) && state.func_177229_b(HALF) == offsetState.func_177229_b(HALF) && (offsetDir = (Direction)offsetState.func_177229_b((Property)FACING)).func_176740_k() != ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() && ReinforcedStairsBlock.isDifferentStairs(state, world, pos, offsetDir.func_176734_d())) {
            if (offsetDir == dir.func_176735_f()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState offsetOppositeState = world.func_180495_p(pos.func_177972_a(dir.func_176734_d()));
        if (ReinforcedStairsBlock.isBlockStairs(offsetOppositeState) && state.func_177229_b(HALF) == offsetOppositeState.func_177229_b(HALF) && (offsetOppositeDir = (Direction)offsetOppositeState.func_177229_b((Property)FACING)).func_176740_k() != ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() && ReinforcedStairsBlock.isDifferentStairs(state, world, pos, offsetOppositeDir)) {
            if (offsetOppositeDir == dir.func_176735_f()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean isDifferentStairs(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        BlockState offsetState = world.func_180495_p(pos.func_177972_a(face));
        return !ReinforcedStairsBlock.isBlockStairs(offsetState) || offsetState.func_177229_b((Property)FACING) != state.func_177229_b((Property)FACING) || offsetState.func_177229_b(HALF) != state.func_177229_b(HALF);
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.func_177230_c() instanceof ReinforcedStairsBlock || state.func_177230_c() instanceof StairsBlock;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        StairsShape shape = (StairsShape)state.func_177229_b(SHAPE);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.func_176740_k() != Direction.Axis.Z) break;
                switch (shape) {
                    case INNER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return state.func_185907_a(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.func_176740_k() != Direction.Axis.X) break;
                switch (shape) {
                    case INNER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180);
                    }
                }
                break;
            }
        }
        return super.func_185471_a(state, mirror);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, HALF, SHAPE, WATERLOGGED});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return false;
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(SHAPE, vanillaState.func_177229_b(SHAPE))).func_206870_a((Property)FACING, vanillaState.func_177229_b((Property)FACING))).func_206870_a(HALF, vanillaState.func_177229_b(HALF))).func_206870_a((Property)WATERLOGGED, vanillaState.func_177229_b((Property)WATERLOGGED));
    }
}

