/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.waila;

import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import mcp.mobius.waila.api.event.WailaRenderEvent;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.entity.SentryEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.KeycardReaderTileEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

@WailaPlugin(value="securitycraft")
public class WailaDataProvider
implements IWailaPlugin,
IComponentProvider,
IEntityComponentProvider {
    public static final WailaDataProvider INSTANCE = new WailaDataProvider();
    public static final ResourceLocation SHOW_OWNER = new ResourceLocation("securitycraft", "showowner");
    public static final ResourceLocation SHOW_MODULES = new ResourceLocation("securitycraft", "showmodules");
    public static final ResourceLocation SHOW_PASSWORDS = new ResourceLocation("securitycraft", "showpasswords");
    public static final ResourceLocation SHOW_CUSTOM_NAME = new ResourceLocation("securitycraft", "showcustomname");
    private static final Style MOD_NAME_STYLE = Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE).func_240722_b_(Boolean.valueOf(true));
    private static final Style ITEM_NAME_STYLE = Style.field_240709_b_.func_240721_b_(TextFormatting.WHITE);

    public void register(IRegistrar registrar) {
        registrar.addSyncedConfig(SHOW_OWNER, true);
        registrar.addSyncedConfig(SHOW_MODULES, true);
        registrar.addSyncedConfig(SHOW_PASSWORDS, true);
        registrar.addSyncedConfig(SHOW_CUSTOM_NAME, true);
        registrar.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.HEAD, IOverlayDisplay.class);
        registrar.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.BODY, IOwnable.class);
        registrar.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.TAIL, IOverlayDisplay.class);
        registrar.registerStackProvider((IComponentProvider)INSTANCE, IOverlayDisplay.class);
        registrar.registerComponentProvider((IEntityComponentProvider)INSTANCE, TooltipPosition.BODY, SentryEntity.class);
    }

    public ItemStack getStack(IDataAccessor data, IPluginConfig config) {
        return ((IOverlayDisplay)data.getBlock()).getDisplayStack(data.getWorld(), data.getBlockState(), data.getPosition());
    }

    public void appendHead(List<ITextComponent> head, IDataAccessor data, IPluginConfig config) {
        head.set(0, (ITextComponent)new TranslationTextComponent(((IOverlayDisplay)data.getBlock()).getDisplayStack(data.getWorld(), data.getBlockState(), data.getPosition()).func_77977_a()).func_230530_a_(ITEM_NAME_STYLE));
    }

    public void appendBody(List<ITextComponent> body, IDataAccessor data, IPluginConfig config) {
        BlockState disguisedBlockState;
        Block block = data.getBlock();
        boolean disguised = false;
        if (block instanceof DisguisableBlock && (disguisedBlockState = ((DisguisableBlock)block).getDisguisedBlockState((IBlockReader)data.getWorld(), data.getPosition())) != null) {
            disguised = true;
            block = disguisedBlockState.func_177230_c();
        }
        if (block instanceof IOverlayDisplay && !((IOverlayDisplay)block).shouldShowSCInfo(data.getWorld(), data.getBlockState(), data.getPosition())) {
            return;
        }
        TileEntity te = data.getTileEntity();
        if (config.get(SHOW_OWNER) && te instanceof IOwnable && block.getRegistryName().func_110624_b().equals("securitycraft")) {
            body.add((ITextComponent)Utils.localize("waila.securitycraft:owner", PlayerUtils.getOwnerComponent(((IOwnable)te).getOwner().getName())));
        }
        if (disguised) {
            return;
        }
        if (config.get(SHOW_MODULES) && te instanceof IModuleInventory && (!(te instanceof IOwnable) || ((IOwnable)te).getOwner().isOwner(data.getPlayer()))) {
            if (!((IModuleInventory)te).getInsertedModules().isEmpty()) {
                body.add((ITextComponent)Utils.localize("waila.securitycraft:equipped", new Object[0]));
            }
            for (ModuleType module : ((IModuleInventory)te).getInsertedModules()) {
                body.add((ITextComponent)new StringTextComponent("- ").func_230529_a_((ITextComponent)new TranslationTextComponent(module.getTranslationKey())));
            }
        }
        if (config.get(SHOW_PASSWORDS) && te instanceof IPasswordProtected && !(te instanceof KeycardReaderTileEntity) && ((IOwnable)te).getOwner().isOwner(data.getPlayer())) {
            String password = ((IPasswordProtected)te).getPassword();
            body.add((ITextComponent)Utils.localize("waila.securitycraft:password", password != null && !password.isEmpty() ? password : Utils.localize("waila.securitycraft:password.notSet", new Object[0])));
        }
    }

    public void appendTail(List<ITextComponent> tail, IDataAccessor data, IPluginConfig config) {
        ItemStack disguisedAs = ((IOverlayDisplay)data.getBlock()).getDisplayStack(data.getWorld(), data.getBlockState(), data.getPosition());
        tail.set(0, (ITextComponent)new StringTextComponent(((ModContainer)ModList.get().getModContainerById(disguisedAs.func_77973_b().getRegistryName().func_110624_b()).get()).getModInfo().getDisplayName()).func_230530_a_(MOD_NAME_STYLE));
    }

    public void appendBody(List<ITextComponent> body, IEntityAccessor data, IPluginConfig config) {
        Entity entity = data.getEntity();
        if (entity instanceof SentryEntity) {
            SentryEntity sentry = (SentryEntity)entity;
            SentryEntity.SentryMode mode = sentry.getMode();
            if (config.get(SHOW_OWNER)) {
                body.add((ITextComponent)Utils.localize("waila.securitycraft:owner", PlayerUtils.getOwnerComponent(sentry.getOwner().getName())));
            }
            if (config.get(SHOW_MODULES) && sentry.getOwner().isOwner(data.getPlayer()) && (!sentry.getAllowlistModule().func_190926_b() || !sentry.getDisguiseModule().func_190926_b() || sentry.hasSpeedModule())) {
                body.add((ITextComponent)Utils.localize("waila.securitycraft:equipped", new Object[0]));
                if (!sentry.getAllowlistModule().func_190926_b()) {
                    body.add((ITextComponent)new StringTextComponent("- ").func_230529_a_((ITextComponent)new TranslationTextComponent(ModuleType.ALLOWLIST.getTranslationKey())));
                }
                if (!sentry.getDisguiseModule().func_190926_b()) {
                    body.add((ITextComponent)new StringTextComponent("- ").func_230529_a_((ITextComponent)new TranslationTextComponent(ModuleType.DISGUISE.getTranslationKey())));
                }
                if (sentry.hasSpeedModule()) {
                    body.add((ITextComponent)new StringTextComponent("- ").func_230529_a_((ITextComponent)new TranslationTextComponent(ModuleType.SPEED.getTranslationKey())));
                }
            }
            TranslationTextComponent modeDescription = Utils.localize(mode.getModeKey(), new Object[0]);
            if (mode != SentryEntity.SentryMode.IDLE) {
                modeDescription.func_240702_b_("- ").func_230529_a_((ITextComponent)Utils.localize(mode.getTargetKey(), new Object[0]));
            }
            body.add((ITextComponent)modeDescription);
        }
    }

    public static void onWailaRender(WailaRenderEvent.Pre event) {
        if (ClientHandler.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
        }
    }

    static {
        MinecraftForge.EVENT_BUS.addListener(WailaDataProvider::onWailaRender);
    }
}

