/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.IMSTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.AbstractFireballEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class IMSBombEntity
extends AbstractFireballEntity {
    private static final DataParameter<Owner> OWNER = EntityDataManager.func_187226_a(IMSBombEntity.class, Owner.getSerializer());
    private int ticksFlying = 0;
    private int launchTime;
    private boolean launching = true;
    private boolean isFast;

    public IMSBombEntity(EntityType<IMSBombEntity> type, World world) {
        super(SCContent.eTypeImsBomb, world);
    }

    public IMSBombEntity(World world, double x, double y, double z, double accelerationX, double accelerationY, double accelerationZ, int height, IMSTileEntity te) {
        super(SCContent.eTypeImsBomb, x, y, z, accelerationX, accelerationY, accelerationZ, world);
        this.launchTime = height * 3;
        Owner owner = te.getOwner();
        this.field_70180_af.func_187227_b(OWNER, (Object)new Owner(owner.getName(), owner.getUUID()));
        this.isFast = te.hasModule(ModuleType.SPEED);
    }

    public void func_70071_h_() {
        if (!this.launching) {
            super.func_70071_h_();
        } else {
            if (this.ticksFlying == 0) {
                this.func_213293_j(this.func_213322_ci().field_72450_a, this.isFast ? (double)0.66f : (double)0.33f, this.func_213322_ci().field_72449_c);
            }
            if (this.ticksFlying < this.launchTime) {
                this.ticksFlying += this.isFast ? 2 : 1;
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            } else {
                this.func_213293_j(0.0, 0.0, 0.0);
                this.launching = false;
            }
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K && result.func_216346_c() == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(((BlockRayTraceResult)result).func_216350_a()).func_177230_c() != SCContent.IMS.get()) {
            BlockPos impactPos = ((BlockRayTraceResult)result).func_216350_a();
            this.field_70170_p.func_217398_a((Entity)this, (double)impactPos.func_177958_n(), (double)impactPos.func_177956_o() + 1.0, (double)impactPos.func_177952_p(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 3.5f : 7.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionMode());
            this.func_70106_y();
        }
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("launchTime", this.launchTime);
        tag.func_74768_a("ticksFlying", this.ticksFlying);
        tag.func_74757_a("launching", this.launching);
        tag.func_74757_a("isFast", this.isFast);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.launchTime = tag.func_74762_e("launchTime");
        this.ticksFlying = tag.func_74762_e("ticksFlying");
        this.launching = tag.func_74767_n("launching");
        this.isFast = tag.func_74767_n("isFast");
    }

    public Owner getOwner() {
        return (Owner)this.field_70180_af.func_187225_a(OWNER);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER, (Object)new Owner());
    }

    protected float func_82341_c() {
        return this.isFast ? 1.5f : 1.0f;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public float func_70111_Y() {
        return 0.3f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

