/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.entity.BulletEntity;
import net.geforcemods.securitycraft.entity.ai.AttackRangedIfEnabledGoal;
import net.geforcemods.securitycraft.entity.ai.TargetNearestPlayerOrMobGoal;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.network.client.InitSentryAnimation;
import net.geforcemods.securitycraft.tileentity.KeypadChestTileEntity;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.dispenser.ProxyBlockSource;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SentryEntity
extends CreatureEntity
implements IRangedAttackMob {
    private static final DataParameter<Owner> OWNER = EntityDataManager.func_187226_a(SentryEntity.class, Owner.getSerializer());
    private static final DataParameter<CompoundNBT> DISGUISE_MODULE = EntityDataManager.func_187226_a(SentryEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<CompoundNBT> ALLOWLIST = EntityDataManager.func_187226_a(SentryEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<Boolean> HAS_SPEED_MODULE = EntityDataManager.func_187226_a(SentryEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> MODE = EntityDataManager.func_187226_a(SentryEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> HEAD_ROTATION = EntityDataManager.func_187226_a(SentryEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final float MAX_TARGET_DISTANCE = 20.0f;
    private static final float ANIMATION_STEP_SIZE = 0.025f;
    private static final float UPWARDS_ANIMATION_LIMIT = 0.025f;
    private static final float DOWNWARDS_ANIMATION_LIMIT = 0.9f;
    private float headYTranslation = 0.9f;
    public boolean animateUpwards = false;
    public boolean animate = false;
    private long previousTargetId = Long.MIN_VALUE;
    private static Random notRandom = new NotRandom();

    public SentryEntity(EntityType<SentryEntity> type, World world) {
        super(SCContent.eTypeSentry, world);
    }

    public void setupSentry(PlayerEntity owner) {
        this.field_70180_af.func_187227_b(OWNER, (Object)new Owner(owner.func_200200_C_().getString(), PlayerEntity.func_146094_a((GameProfile)owner.func_146103_bH()).toString()));
        this.field_70180_af.func_187227_b(DISGUISE_MODULE, (Object)new CompoundNBT());
        this.field_70180_af.func_187227_b(ALLOWLIST, (Object)new CompoundNBT());
        this.field_70180_af.func_187227_b(HAS_SPEED_MODULE, (Object)false);
        this.field_70180_af.func_187227_b(MODE, (Object)SentryMode.CAMOUFLAGE_HP.ordinal());
        this.field_70180_af.func_187227_b(HEAD_ROTATION, (Object)Float.valueOf(0.0f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER, (Object)new Owner());
        this.field_70180_af.func_187214_a(DISGUISE_MODULE, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(ALLOWLIST, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(HAS_SPEED_MODULE, (Object)false);
        this.field_70180_af.func_187214_a(MODE, (Object)SentryMode.CAMOUFLAGE_HP.ordinal());
        this.field_70180_af.func_187214_a(HEAD_ROTATION, (Object)Float.valueOf(0.0f));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new AttackRangedIfEnabledGoal(this, this::getShootingSpeed, 10.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new TargetNearestPlayerOrMobGoal(this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            BlockPos downPos = this.func_226270_aj_();
            if (this.field_70170_p.func_180495_p(downPos).func_196958_f() || this.field_70170_p.func_226664_a_(new AxisAlignedBB(downPos))) {
                this.func_70106_y();
            }
        } else {
            if (!this.animate && this.headYTranslation > 0.0f && this.getMode().isAggressive()) {
                this.animateUpwards = true;
                this.animate = true;
            }
            if (this.animate) {
                if (this.animateUpwards && this.headYTranslation > 0.025f) {
                    this.headYTranslation -= 0.025f;
                    if (this.headYTranslation <= 0.025f) {
                        this.animateUpwards = false;
                        this.animate = false;
                    }
                } else if (!this.animateUpwards && this.headYTranslation < 0.9f) {
                    this.headYTranslation += 0.025f;
                    if (this.headYTranslation >= 0.9f) {
                        this.animateUpwards = true;
                        this.animate = false;
                    }
                }
            }
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)SCContent.SENTRY.get());
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        BlockPos pos = this.func_233580_cy_();
        if (this.getOwner().isOwner(player) && hand == Hand.MAIN_HAND) {
            Item item = player.func_184614_ca().func_77973_b();
            player.func_71053_j();
            if (player.func_213453_ef()) {
                this.func_70106_y();
            } else if (item == SCContent.UNIVERSAL_BLOCK_REMOVER.get()) {
                this.func_70106_y();
                if (!player.func_184812_l_()) {
                    player.func_184614_ca().func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(hand));
                }
            } else if (item == SCContent.DISGUISE_MODULE.get()) {
                ItemStack module = this.getDisguiseModule();
                if (!module.func_190926_b()) {
                    Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)module);
                    Block block = ((ModuleItem)module.func_77973_b()).getBlockAddon(module.func_77978_p());
                    if (block == this.field_70170_p.func_180495_p(pos).func_177230_c()) {
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    }
                }
                this.setDisguiseModule(player.func_184614_ca());
                if (!player.func_184812_l_()) {
                    player.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                }
            } else if (item == SCContent.ALLOWLIST_MODULE.get()) {
                ItemStack module = this.getAllowlistModule();
                if (!module.func_190926_b()) {
                    Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)module);
                }
                this.setAllowlistModule(player.func_184614_ca());
                if (!player.func_184812_l_()) {
                    player.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                }
            } else if (item == SCContent.SPEED_MODULE.get()) {
                if (!this.hasSpeedModule()) {
                    this.setHasSpeedModule(true);
                    if (!player.func_184812_l_()) {
                        player.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                    }
                }
            } else if (item == SCContent.UNIVERSAL_BLOCK_MODIFIER.get()) {
                Block block;
                if (!this.getDisguiseModule().func_190926_b() && (block = ((ModuleItem)this.getDisguiseModule().func_77973_b()).getBlockAddon(this.getDisguiseModule().func_77978_p())) == this.field_70170_p.func_180495_p(pos).func_177230_c()) {
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
                Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)this.getDisguiseModule());
                Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)this.getAllowlistModule());
                if (this.hasSpeedModule()) {
                    Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)SCContent.SPEED_MODULE.get()));
                }
                this.field_70180_af.func_187227_b(DISGUISE_MODULE, (Object)new CompoundNBT());
                this.field_70180_af.func_187227_b(ALLOWLIST, (Object)new CompoundNBT());
                this.field_70180_af.func_187227_b(HAS_SPEED_MODULE, (Object)false);
            } else if (item == SCContent.REMOTE_ACCESS_SENTRY.get()) {
                item.func_195939_a(new ItemUseContext(player, hand, new BlockRayTraceResult(new Vector3d(0.0, 0.0, 0.0), Direction.NORTH, pos, false)));
            } else if (item == Items.field_151057_cb) {
                this.func_200203_b(player.func_184614_ca().func_200301_q());
                player.func_184614_ca().func_190918_g(1);
            } else if (item == SCContent.UNIVERSAL_OWNER_CHANGER.get()) {
                String newOwner;
                this.field_70180_af.func_187227_b(OWNER, (Object)new Owner(newOwner, PlayerUtils.isPlayerOnline(newOwner = player.func_184614_ca().func_200301_q().getString()) ? PlayerUtils.getPlayerFromName(newOwner).func_110124_au().toString() : "ownerUUID"));
                PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.changed", newOwner), TextFormatting.GREEN);
            } else {
                this.toggleMode(player);
            }
            player.func_184609_a(Hand.MAIN_HAND);
            return ActionResultType.SUCCESS;
        }
        if (!this.getOwner().isOwner(player) && hand == Hand.MAIN_HAND && player.func_184812_l_() && (player.func_213453_ef() || player.func_184614_ca().func_77973_b() == SCContent.UNIVERSAL_BLOCK_REMOVER.get())) {
            this.func_70106_y();
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_70106_y() {
        Block block;
        BlockPos pos = this.func_233580_cy_();
        if (!this.getDisguiseModule().func_190926_b() && (block = ((ModuleItem)this.getDisguiseModule().func_77973_b()).getBlockAddon(this.getDisguiseModule().func_77978_p())) == this.field_70170_p.func_180495_p(pos).func_177230_c()) {
            this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        super.func_70106_y();
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)SCContent.SENTRY.get()));
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)this.getDisguiseModule());
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)this.getAllowlistModule());
        if (this.hasSpeedModule()) {
            Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)SCContent.SPEED_MODULE.get()));
        }
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public void toggleMode(PlayerEntity player) {
        this.toggleMode(player, (Integer)this.field_70180_af.func_187225_a(MODE) + 1, true);
    }

    public void toggleMode(PlayerEntity player, int mode, boolean sendMessage) {
        if (mode < 0 || mode >= SentryMode.values().length) {
            mode = 0;
        }
        this.field_70180_af.func_187227_b(MODE, (Object)mode);
        if (sendMessage) {
            player.func_146105_b((ITextComponent)Utils.localize(SentryMode.values()[mode].getModeKey(), new Object[0]).func_230529_a_((ITextComponent)Utils.localize(SentryMode.values()[mode].getDescriptionKey(), new Object[0])), true);
        }
        if (!player.field_70170_p.field_72995_K) {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new InitSentryAnimation(this.func_233580_cy_(), true, SentryMode.values()[mode].isAggressive()));
        }
    }

    public void func_70624_b(LivingEntity target) {
        if (!this.getMode().isAggressive() && (target == null && this.previousTargetId != Long.MIN_VALUE || target != null && this.previousTargetId != (long)target.func_145782_y())) {
            this.animateUpwards = this.getMode().isCamouflage() && target != null;
            this.animate = true;
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new InitSentryAnimation(this.func_233580_cy_(), this.animate, this.animateUpwards));
        }
        this.previousTargetId = target == null ? Long.MIN_VALUE : (long)target.func_145782_y();
        super.func_70624_b(target);
    }

    public float func_213307_e(Pose pose) {
        return 1.5f;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (target instanceof PlayerEntity && (((PlayerEntity)target).func_175149_v() || ((PlayerEntity)target).func_184812_l_())) {
            return;
        }
        if (this.func_70068_e((Entity)target) > 400.0) {
            return;
        }
        TileEntity te = this.field_70170_p.func_175625_s(this.func_233580_cy_().func_177977_b());
        BulletEntity throwableEntity = null;
        SoundEvent shootSound = SoundEvents.field_187737_v;
        ProjectileDispenseBehavior pdb = null;
        LazyOptional optional = LazyOptional.empty();
        if (te instanceof KeypadChestTileEntity) {
            optional = ((KeypadChestTileEntity)te).getHandlerForSentry(this);
        } else if (te != null) {
            optional = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP);
        }
        if (optional.isPresent()) {
            IItemHandler handler = (IItemHandler)optional.orElse(null);
            for (int i = 0; i < handler.getSlots(); ++i) {
                IDispenseItemBehavior dispenseBehavior;
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.func_190926_b() || !((dispenseBehavior = ((DispenserBlock)Blocks.field_150367_z).func_149940_a(stack)) instanceof ProjectileDispenseBehavior)) continue;
                ItemStack extracted = handler.extractItem(i, 1, false);
                pdb = (ProjectileDispenseBehavior)dispenseBehavior;
                throwableEntity = pdb.func_82499_a(this.field_70170_p, (IPosition)this.func_213303_ch().func_72441_c(0.0, 1.6, 0.0), extracted);
                throwableEntity.func_212361_a((Entity)this);
                shootSound = null;
                break;
            }
        }
        if (throwableEntity == null) {
            throwableEntity = new BulletEntity(this.field_70170_p, this);
        }
        double baseY = target.func_226278_cu_() + (double)target.func_70047_e() - (double)1.1f;
        double x = target.func_226277_ct_() - this.func_226277_ct_();
        double y = baseY - throwableEntity.func_226278_cu_();
        double z = target.func_226281_cx_() - this.func_226281_cx_();
        float yOffset = MathHelper.func_76133_a((double)(x * x + z * z)) * 0.2f;
        this.field_70180_af.func_187227_b(HEAD_ROTATION, (Object)Float.valueOf((float)(MathHelper.func_181159_b((double)x, (double)(-z)) * 57.29577951308232)));
        throwableEntity.func_70186_c(x, y + (double)yOffset, z, 1.6f, 0.0f);
        if (shootSound == null) {
            if (!this.field_70170_p.field_72995_K) {
                pdb.func_82485_a((IBlockSource)new ProxyBlockSource((ServerWorld)this.field_70170_p, this.func_233580_cy_()));
            }
        } else {
            this.func_184185_a(shootSound, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
        this.field_70170_p.func_217376_c((Entity)throwableEntity);
    }

    public void func_213281_b(CompoundNBT tag) {
        tag.func_218657_a("TileEntityData", (INBT)this.getOwnerTag());
        tag.func_218657_a("InstalledModule", (INBT)this.getDisguiseModule().func_77955_b(new CompoundNBT()));
        tag.func_218657_a("InstalledWhitelist", (INBT)this.getAllowlistModule().func_77955_b(new CompoundNBT()));
        tag.func_74757_a("HasSpeedModule", this.hasSpeedModule());
        tag.func_74768_a("SentryMode", ((Integer)this.field_70180_af.func_187225_a(MODE)).intValue());
        tag.func_74776_a("HeadRotation", ((Float)this.field_70180_af.func_187225_a(HEAD_ROTATION)).floatValue());
        super.func_213281_b(tag);
    }

    private CompoundNBT getOwnerTag() {
        CompoundNBT tag = new CompoundNBT();
        Owner owner = (Owner)this.field_70180_af.func_187225_a(OWNER);
        owner.write(tag, false);
        return tag;
    }

    public void func_70037_a(CompoundNBT tag) {
        CompoundNBT teTag = tag.func_74775_l("TileEntityData");
        Owner owner = Owner.fromCompound(teTag);
        this.field_70180_af.func_187227_b(OWNER, (Object)owner);
        this.field_70180_af.func_187227_b(DISGUISE_MODULE, (Object)tag.func_74775_l("InstalledModule"));
        this.field_70180_af.func_187227_b(ALLOWLIST, (Object)tag.func_74775_l("InstalledWhitelist"));
        this.field_70180_af.func_187227_b(HAS_SPEED_MODULE, (Object)tag.func_74767_n("HasSpeedModule"));
        this.field_70180_af.func_187227_b(MODE, (Object)tag.func_74762_e("SentryMode"));
        this.field_70180_af.func_187227_b(HEAD_ROTATION, (Object)Float.valueOf(tag.func_74760_g("HeadRotation")));
        super.func_70037_a(tag);
    }

    public Owner getOwner() {
        return (Owner)this.field_70180_af.func_187225_a(OWNER);
    }

    public void setDisguiseModule(ItemStack module) {
        Block block = ((ModuleItem)module.func_77973_b()).getBlockAddon(module.func_77978_p());
        if (block != null) {
            BlockState state = block.func_176223_P();
            if (this.field_70170_p.func_180495_p(this.func_233580_cy_()).isAir((IBlockReader)this.field_70170_p, this.func_233580_cy_())) {
                this.field_70170_p.func_175656_a(this.func_233580_cy_(), state.func_196954_c((IBlockReader)this.field_70170_p, this.func_233580_cy_()) == VoxelShapes.func_197868_b() ? state : Blocks.field_150350_a.func_176223_P());
            }
        }
        this.field_70180_af.func_187227_b(DISGUISE_MODULE, (Object)module.func_77955_b(new CompoundNBT()));
    }

    public void setAllowlistModule(ItemStack module) {
        this.field_70180_af.func_187227_b(ALLOWLIST, (Object)module.func_77955_b(new CompoundNBT()));
    }

    public void setHasSpeedModule(boolean hasSpeedModule) {
        this.field_70180_af.func_187227_b(HAS_SPEED_MODULE, (Object)hasSpeedModule);
    }

    public ItemStack getDisguiseModule() {
        CompoundNBT tag = (CompoundNBT)this.field_70180_af.func_187225_a(DISGUISE_MODULE);
        if (tag == null || tag.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((CompoundNBT)tag);
    }

    public ItemStack getAllowlistModule() {
        CompoundNBT tag = (CompoundNBT)this.field_70180_af.func_187225_a(ALLOWLIST);
        if (tag == null || tag.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((CompoundNBT)tag);
    }

    public boolean hasSpeedModule() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_SPEED_MODULE);
    }

    public SentryMode getMode() {
        int mode = (Integer)this.field_70180_af.func_187225_a(MODE);
        return mode < 0 || mode >= SentryMode.values().length ? SentryMode.CAMOUFLAGE_HP : SentryMode.values()[mode];
    }

    public float getHeadYTranslation() {
        return this.headYTranslation;
    }

    public boolean isTargetingAllowedPlayer(LivingEntity potentialTarget) {
        if (potentialTarget != null) {
            List<String> players = ModuleUtils.getPlayersFromModule(this.getAllowlistModule());
            for (String s : players) {
                if (!potentialTarget.func_200200_C_().func_150261_e().equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    public int getShootingSpeed() {
        return this.hasSpeedModule() ? 5 : 10;
    }

    public boolean func_70652_k(Entity entity) {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }

    public boolean func_190631_cK() {
        return false;
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        return false;
    }

    public void func_70664_aZ() {
    }

    public boolean func_70781_l() {
        return false;
    }

    public void func_70623_bb() {
    }

    public boolean func_213397_c(double distanceClosestToPlayer) {
        return false;
    }

    public void func_70100_b_(PlayerEntity entity) {
    }

    public void func_213315_a(MoverType type, Vector3d vec) {
    }

    protected void func_82167_n(Entity entity) {
    }

    protected void func_85033_bc() {
    }

    public boolean func_180427_aV() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    public void func_110159_bB() {
    }

    public Random func_70681_au() {
        return notRandom;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum SentryMode {
        CAMOUFLAGE_HP(1, 0, 1),
        CAMOUFLAGE_H(1, 1, 3),
        CAMOUFLAGE_P(1, 2, 5),
        AGGRESSIVE_HP(0, 0, 0),
        AGGRESSIVE_H(0, 1, 2),
        AGGRESSIVE_P(0, 2, 4),
        IDLE(-1, -1, 6);

        private final int type;
        private final int attack;
        private final int descriptionKeyIndex;

        private SentryMode(int type, int attack, int descriptionKeyIndex) {
            this.type = type;
            this.attack = attack;
            this.descriptionKeyIndex = descriptionKeyIndex;
        }

        public boolean isAggressive() {
            return this.type == 0;
        }

        public boolean isCamouflage() {
            return this.type == 1;
        }

        public boolean attacksHostile() {
            return this.attack == 0 || this.attack == 1;
        }

        public boolean attacksPlayers() {
            return this.attack == 0 || this.attack == 2;
        }

        public String getModeKey() {
            String key = "messages.securitycraft:sentry.mode";
            return this.isAggressive() ? key + "0" : (this.isCamouflage() ? key + "1" : key + "2");
        }

        public String getTargetKey() {
            String key = "gui.securitycraft:srat.targets";
            return this.attacksHostile() && this.attacksPlayers() ? key + "1" : (this.attacksHostile() ? key + "2" : (this.attacksPlayers() ? key + "3" : ""));
        }

        public String getDescriptionKey() {
            return "messages.securitycraft:sentry.descriptionMode" + this.descriptionKeyIndex;
        }
    }

    private static class NotRandom
    extends Random {
        private NotRandom() {
        }

        @Override
        public int nextInt(int bound) {
            return 0;
        }
    }
}

