/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.SetCameraView;
import net.geforcemods.securitycraft.network.server.GiveNightVision;
import net.geforcemods.securitycraft.network.server.SetCameraPowered;
import net.geforcemods.securitycraft.tileentity.SecurityCameraTileEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public class SecurityCameraEntity
extends Entity {
    protected final double cameraSpeed;
    public int screenshotSoundCooldown;
    protected int redstoneCooldown;
    protected int toggleNightVisionCooldown;
    private boolean shouldProvideNightVision;
    protected float zoomAmount;
    protected boolean zooming;
    private int viewDistance;
    private boolean loadedChunks;

    public SecurityCameraEntity(EntityType<SecurityCameraEntity> type, World world) {
        super(SCContent.eTypeSecurityCamera, world);
        this.cameraSpeed = (Double)ConfigHandler.CLIENT.cameraSpeed.get();
        this.screenshotSoundCooldown = 0;
        this.redstoneCooldown = 0;
        this.toggleNightVisionCooldown = 0;
        this.shouldProvideNightVision = false;
        this.zoomAmount = 1.0f;
        this.zooming = false;
        this.viewDistance = -1;
        this.loadedChunks = false;
        this.field_70145_X = true;
        this.field_98038_p = true;
    }

    public SecurityCameraEntity(World world, BlockPos pos) {
        this(SCContent.eTypeSecurityCamera, world);
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof SecurityCameraTileEntity)) {
            this.func_70106_y();
            return;
        }
        SecurityCameraTileEntity cam = (SecurityCameraTileEntity)te;
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        if (cam.down) {
            y += 0.25;
        }
        this.func_70107_b(x, y, z);
        this.setInitialPitchYaw(cam);
    }

    public SecurityCameraEntity(World world, BlockPos pos, SecurityCameraEntity oldCamera) {
        this(world, pos);
        oldCamera.discardCamera();
    }

    private void setInitialPitchYaw(SecurityCameraTileEntity te) {
        this.field_70125_A = 30.0f;
        Direction facing = (Direction)this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_177229_b((Property)SecurityCameraBlock.FACING);
        if (facing == Direction.NORTH) {
            this.field_70177_z = 180.0f;
        } else if (facing == Direction.WEST) {
            this.field_70177_z = 90.0f;
        } else if (facing == Direction.SOUTH) {
            this.field_70177_z = 0.0f;
        } else if (facing == Direction.EAST) {
            this.field_70177_z = 270.0f;
        } else if (facing == Direction.DOWN) {
            this.field_70125_A = 75.0f;
        }
    }

    protected boolean func_142008_O() {
        return false;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            if (this.screenshotSoundCooldown > 0) {
                --this.screenshotSoundCooldown;
            }
            if (this.redstoneCooldown > 0) {
                --this.redstoneCooldown;
            }
            if (this.toggleNightVisionCooldown > 0) {
                --this.toggleNightVisionCooldown;
            }
            if (this.shouldProvideNightVision) {
                SecurityCraft.channel.sendToServer((Object)new GiveNightVision());
            }
        } else if (this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_177230_c() != SCContent.SECURITY_CAMERA.get()) {
            this.func_70106_y();
        }
    }

    public void toggleRedstonePower() {
        BlockPos pos = this.func_233580_cy_();
        if (((IModuleInventory)this.field_70170_p.func_175625_s(pos)).hasModule(ModuleType.REDSTONE)) {
            SecurityCraft.channel.sendToServer((Object)new SetCameraPowered(pos, (Boolean)this.field_70170_p.func_180495_p(pos).func_177229_b((Property)SecurityCameraBlock.POWERED) == false));
        }
    }

    public void toggleNightVision() {
        this.toggleNightVisionCooldown = 30;
        this.shouldProvideNightVision = !this.shouldProvideNightVision;
    }

    public float getZoomAmount() {
        return this.zoomAmount;
    }

    public boolean isCameraDown() {
        return this.field_70170_p.func_175625_s(this.func_233580_cy_()) instanceof SecurityCameraTileEntity && ((SecurityCameraTileEntity)this.field_70170_p.func_175625_s((BlockPos)this.func_233580_cy_())).down;
    }

    protected void func_70101_b(float yaw, float pitch) {
        super.func_70101_b(yaw, pitch);
    }

    public void stopViewing(ServerPlayerEntity player) {
        if (!this.field_70170_p.field_72995_K) {
            this.discardCamera();
            player.field_175401_bS = player;
            SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SetCameraView((Entity)player));
        }
    }

    public void discardCamera() {
        if (!this.field_70170_p.field_72995_K) {
            TileEntity te = this.field_70170_p.func_175625_s(this.func_233580_cy_());
            if (te instanceof SecurityCameraTileEntity) {
                ((SecurityCameraTileEntity)te).stopViewing();
            }
            SectionPos chunkPos = SectionPos.func_218167_a((BlockPos)this.func_233580_cy_());
            int viewDistance = this.viewDistance <= 0 ? this.field_70170_p.func_73046_m().func_184103_al().func_72395_o() : this.viewDistance;
            for (int x = chunkPos.func_177958_n() - viewDistance; x <= chunkPos.func_177958_n() + viewDistance; ++x) {
                for (int z = chunkPos.func_177952_p() - viewDistance; z <= chunkPos.func_177952_p() + viewDistance; ++z) {
                    ForgeChunkManager.forceChunk((ServerWorld)((ServerWorld)this.field_70170_p), (String)"securitycraft", (Entity)this, (int)x, (int)z, (boolean)false, (boolean)false);
                }
            }
        }
        this.func_70106_y();
    }

    public void setHasLoadedChunks(int initialViewDistance) {
        this.loadedChunks = true;
        this.viewDistance = initialViewDistance;
    }

    public boolean hasLoadedChunks() {
        return this.loadedChunks;
    }

    protected void func_70088_a() {
    }

    public void func_213281_b(CompoundNBT tag) {
    }

    public void func_70037_a(CompoundNBT tag) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

