/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.containers.DisguiseModuleContainer;
import net.geforcemods.securitycraft.inventory.ModuleItemInventory;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class ModuleItem
extends Item {
    private static final IFormattableTextComponent MODIFIABLE = new TranslationTextComponent("tooltip.securitycraft:module.modifiable").func_230530_a_(Utils.GRAY_STYLE);
    private static final IFormattableTextComponent NOT_MODIFIABLE = new TranslationTextComponent("tooltip.securitycraft:module.notModifiable").func_230530_a_(Utils.GRAY_STYLE);
    public static final int MAX_PLAYERS = 50;
    private final ModuleType module;
    private final boolean containsCustomData;
    private boolean canBeCustomized;

    public ModuleItem(Item.Properties properties, ModuleType module, boolean containsCustomData) {
        this(properties, module, containsCustomData, false);
    }

    public ModuleItem(Item.Properties properties, ModuleType module, boolean containsCustomData, boolean canBeCustomized) {
        super(properties);
        this.module = module;
        this.containsCustomData = containsCustomData;
        this.canBeCustomized = canBeCustomized;
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        TileEntity te = ctx.func_195991_k().func_175625_s(ctx.func_195995_a());
        ItemStack stack = ctx.func_195996_i();
        if (te instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)te;
            ModuleType type = ((ModuleItem)stack.func_77973_b()).getModuleType();
            if (te instanceof IOwnable && !((IOwnable)te).getOwner().isOwner(ctx.func_195999_j())) {
                return ActionResultType.PASS;
            }
            if (inv.getAcceptedModules().contains((Object)type) && !inv.hasModule(type)) {
                inv.insertModule(stack);
                inv.onModuleInserted(stack, type);
                if (!ctx.func_195999_j().func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, final Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.canBeCustomized()) {
            if (this.module == ModuleType.ALLOWLIST || this.module == ModuleType.DENYLIST) {
                if (world.field_72995_K) {
                    ClientHandler.displayEditModuleGui(stack);
                }
                return ActionResult.func_226249_b_((Object)stack);
            }
            if (this.module == ModuleType.DISGUISE) {
                if (!world.field_72995_K) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                        public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                            return new DisguiseModuleContainer(windowId, inv, new ModuleItemInventory(player.func_184586_b(hand)));
                        }

                        public ITextComponent func_145748_c_() {
                            return new TranslationTextComponent(ModuleItem.this.func_77658_a());
                        }
                    });
                }
                return ActionResult.func_226249_b_((Object)stack);
            }
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        Block addon;
        if (this.containsCustomData || this.canBeCustomized()) {
            list.add((ITextComponent)MODIFIABLE);
        } else {
            list.add((ITextComponent)NOT_MODIFIABLE);
        }
        if (this.canBeCustomized() && (addon = this.getBlockAddon(stack.func_77978_p())) != null) {
            list.add((ITextComponent)Utils.localize("tooltip.securitycraft:module.itemAddons.added", Utils.localize(addon.func_149739_a(), new Object[0])).func_230530_a_(Utils.GRAY_STYLE));
        }
    }

    public ModuleType getModuleType() {
        return this.module;
    }

    public Block getBlockAddon(CompoundNBT tag) {
        Item item;
        if (tag == null) {
            return null;
        }
        ListNBT items = tag.func_150295_c("ItemInventory", 10);
        if (items != null && !items.isEmpty() && (item = ItemStack.func_199557_a((CompoundNBT)items.func_150305_b(0)).func_77973_b()) instanceof BlockItem) {
            return ((BlockItem)item).func_179223_d();
        }
        return null;
    }

    public boolean canBeCustomized() {
        return this.canBeCustomized;
    }
}

