/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.camera;

import net.geforcemods.securitycraft.entity.camera.SecurityCameraEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.server.ChunkManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkManager.class}, priority=1100)
public abstract class ChunkManagerMixin {
    @Shadow
    private int field_219247_A;

    @Shadow
    protected abstract void func_219199_a(ServerPlayerEntity var1, ChunkPos var2, IPacket<?>[] var3, boolean var4, boolean var5);

    @Redirect(method={"func_219215_b(Lnet/minecraft/util/math/ChunkPos;Lnet/minecraft/entity/player/ServerPlayerEntity;Z)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;getManagedSectionPos()Lnet/minecraft/util/math/SectionPos;"))
    private static SectionPos getCameraSectionPos(ServerPlayerEntity player) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) {
            return SectionPos.func_218157_a((Entity)player.func_175398_C());
        }
        return player.func_213842_M();
    }

    @Inject(method={"updatePlayerPosition"}, at={@At(value="TAIL")})
    private void trackCameraLoadedChunks(ServerPlayerEntity player, CallbackInfo callback) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) {
            SectionPos pos = SectionPos.func_218157_a((Entity)player.func_175398_C());
            SecurityCameraEntity camera = (SecurityCameraEntity)player.func_175398_C();
            for (int i = pos.func_218149_a() - this.field_219247_A; i <= pos.func_218149_a() + this.field_219247_A; ++i) {
                for (int j = pos.func_218148_c() - this.field_219247_A; j <= pos.func_218148_c() + this.field_219247_A; ++j) {
                    ChunkPos chunkPos = new ChunkPos(i, j);
                    this.func_219199_a(player, chunkPos, new IPacket[2], camera.hasLoadedChunks(), true);
                }
            }
            camera.setHasLoadedChunks(this.field_219247_A);
        }
    }
}

