/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.tileentity.ProjectorTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncProjector {
    private BlockPos pos;
    private int data;
    private DataType dataType;

    public SyncProjector() {
    }

    public SyncProjector(BlockPos pos, int data, DataType dataType) {
        this.pos = pos;
        this.data = data;
        this.dataType = dataType;
    }

    public static void encode(SyncProjector message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.func_179249_a((Enum)message.dataType);
        if (message.dataType == DataType.HORIZONTAL) {
            buf.writeBoolean(message.data == 1);
        } else {
            buf.func_150787_b(message.data);
        }
    }

    public static SyncProjector decode(PacketBuffer buf) {
        SyncProjector message = new SyncProjector();
        message.pos = buf.func_179259_c();
        message.dataType = (DataType)buf.func_179257_a(DataType.class);
        message.data = message.dataType == DataType.HORIZONTAL ? (buf.readBoolean() ? 1 : 0) : buf.func_150792_a();
        return message;
    }

    public static void onMessage(SyncProjector message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockPos pos = message.pos;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.field_70170_p;
            TileEntity te = world.func_175625_s(pos);
            if (world.func_195588_v(pos) && te instanceof ProjectorTileEntity && ((ProjectorTileEntity)te).getOwner().isOwner((PlayerEntity)player)) {
                ProjectorTileEntity projector = (ProjectorTileEntity)te;
                BlockState state = world.func_180495_p(pos);
                switch (message.dataType) {
                    case WIDTH: {
                        projector.setProjectionWidth(message.data);
                        break;
                    }
                    case HEIGHT: {
                        projector.setProjectionHeight(message.data);
                        break;
                    }
                    case RANGE: {
                        projector.setProjectionRange(message.data);
                        break;
                    }
                    case OFFSET: {
                        projector.setProjectionOffset(message.data);
                        break;
                    }
                    case HORIZONTAL: {
                        projector.setHorizontal(message.data == 1);
                        break;
                    }
                }
                world.func_184138_a(pos, state, state, 2);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum DataType {
        WIDTH,
        HEIGHT,
        RANGE,
        OFFSET,
        HORIZONTAL,
        INVALID;

    }
}

