/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.tileentity.ReinforcedPistonTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.PistonType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;

public class ReinforcedPistonTileEntityRenderer
extends TileEntityRenderer<ReinforcedPistonTileEntity> {
    private BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();

    public ReinforcedPistonTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(ReinforcedPistonTileEntity te, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        World world = te.func_145831_w();
        if (world != null) {
            BlockPos oppositePos = te.func_174877_v().func_177972_a(te.getMotionDirection().func_176734_d());
            BlockState state = te.getPistonState();
            if (!state.func_196958_f()) {
                BlockModelRenderer.func_211847_a();
                matrix.func_227860_a_();
                matrix.func_227861_a_((double)te.getOffsetX(partialTicks), (double)te.getOffsetY(partialTicks), (double)te.getOffsetZ(partialTicks));
                if (state.func_203425_a((Block)SCContent.REINFORCED_PISTON_HEAD.get()) && te.getProgress(partialTicks) <= 4.0f) {
                    state = (BlockState)state.func_206870_a((Property)PistonHeadBlock.field_176327_M, (Comparable)Boolean.valueOf(te.getProgress(partialTicks) <= 0.5f));
                    this.renderBlocks(oppositePos, state, matrix, buffer, world, false, combinedOverlay);
                } else if (te.shouldPistonHeadBeRendered() && !te.isExtending()) {
                    PistonType pistonType = state.func_203425_a((Block)SCContent.REINFORCED_STICKY_PISTON.get()) ? PistonType.STICKY : PistonType.DEFAULT;
                    BlockState headState = (BlockState)((BlockState)((Block)SCContent.REINFORCED_PISTON_HEAD.get()).func_176223_P().func_206870_a((Property)PistonHeadBlock.field_176325_b, (Comparable)pistonType)).func_206870_a((Property)PistonHeadBlock.field_176387_N, state.func_177229_b((Property)PistonBlock.field_176387_N));
                    BlockPos renderPos = oppositePos.func_177972_a(te.getMotionDirection());
                    headState = (BlockState)headState.func_206870_a((Property)PistonHeadBlock.field_176327_M, (Comparable)Boolean.valueOf(te.getProgress(partialTicks) >= 0.5f));
                    this.renderBlocks(oppositePos, headState, matrix, buffer, world, false, combinedOverlay);
                    matrix.func_227865_b_();
                    matrix.func_227860_a_();
                    state = (BlockState)state.func_206870_a((Property)PistonBlock.field_176320_b, (Comparable)Boolean.valueOf(true));
                    this.renderBlocks(renderPos, state, matrix, buffer, world, true, combinedOverlay);
                } else {
                    this.renderBlocks(oppositePos, state, matrix, buffer, world, false, combinedOverlay);
                }
                matrix.func_227865_b_();
                BlockModelRenderer.func_210266_a();
            }
        }
    }

    private void renderBlocks(BlockPos pos, BlockState state, MatrixStack stack, IRenderTypeBuffer buffer, World world, boolean checkSides, int combinedOverlay) {
        ForgeHooksClient.renderPistonMovedBlocks((BlockPos)pos, (BlockState)state, (MatrixStack)stack, (IRenderTypeBuffer)buffer, (World)world, (boolean)checkSides, (int)combinedOverlay, (BlockRendererDispatcher)(this.blockRenderer == null ? (this.blockRenderer = Minecraft.func_71410_x().func_175602_ab()) : this.blockRenderer));
    }
}

