/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.network.server.CheckPassword;
import net.geforcemods.securitycraft.screen.components.IdButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CheckPasswordScreen
extends ContainerScreen<GenericTEContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private TileEntity tileEntity;
    private char[] allowedChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\b', '\u001b'};
    private TranslationTextComponent blockName;
    private TextFieldWidget keycodeTextbox;
    private String currentString = "";
    private static final int MAX_CHARS = 20;

    public CheckPasswordScreen(GenericTEContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.tileEntity = container.te;
        this.blockName = Utils.localize(this.tileEntity.func_195044_w().func_177230_c().func_149739_a(), new Object[0]);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.func_230480_a_((Widget)new IdButton(0, this.field_230708_k_ / 2 - 38, this.field_230709_l_ / 2 + 30 + 10, 80, 20, "0", this::actionPerformed));
        this.func_230480_a_((Widget)new IdButton(1, this.field_230708_k_ / 2 - 38, this.field_230709_l_ / 2 - 60 + 10, 20, 20, "1", this::actionPerformed));
        this.func_230480_a_((Widget)new IdButton(2, this.field_230708_k_ / 2 - 8, this.field_230709_l_ / 2 - 60 + 10, 20, 20, "2", this::actionPerformed));
        this.func_230480_a_((Widget)new IdButton(3, this.field_230708_k_ / 2 + 22, this.field_230709_l_ / 2 - 60 + 10, 20, 20, "3", this::actionPerformed));
        this.func_230480_a_((Widget)new IdButton(4, this.field_230708_k_ / 2 - 38, this.field_230709_l_ / 2 - 30 + 10, 20, 20, "4", this::actionPerformed));
        this.func_230480_a_((Widget)new IdButton(5, this.field_230708_k_ / 2 - 8, this.field_230709_l_ / 2 - 30 + 10, 20, 20, "5", this::actionPerformed));
        this.func_230480_a_((Widget)new IdButton(6, this.field_230708_k_ / 2 + 22, this.field_230709_l_ / 2 - 30 + 10, 20, 20, "6", this::actionPerformed));
        this.func_230480_a_((Widget)new IdButton(7, this.field_230708_k_ / 2 - 38, this.field_230709_l_ / 2 + 10, 20, 20, "7", this::actionPerformed));
        this.func_230480_a_((Widget)new IdButton(8, this.field_230708_k_ / 2 - 8, this.field_230709_l_ / 2 + 10, 20, 20, "8", this::actionPerformed));
        this.func_230480_a_((Widget)new IdButton(9, this.field_230708_k_ / 2 + 22, this.field_230709_l_ / 2 + 10, 20, 20, "9", this::actionPerformed));
        this.func_230480_a_((Widget)new IdButton(10, this.field_230708_k_ / 2 + 48, this.field_230709_l_ / 2 + 30 + 10, 25, 20, "<-", this::actionPerformed));
        this.keycodeTextbox = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 37, this.field_230709_l_ / 2 - 67, 77, 12, StringTextComponent.field_240750_d_);
        this.func_230480_a_((Widget)this.keycodeTextbox);
        this.keycodeTextbox.func_146203_f(20);
        this.keycodeTextbox.func_200675_a(s -> s.matches("[0-9]*\\**"));
        this.func_212928_a((IGuiEventListener)this.keycodeTextbox);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)this.blockName, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.blockName) / 2), 6.0f, 0x404040);
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrix, startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 259 && this.currentString.length() > 0) {
            Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 0.15f, 1.0f);
            this.currentString = Utils.removeLastChar(this.currentString);
            this.setTextboxCensoredText(this.keycodeTextbox, this.currentString);
            this.checkCode(this.currentString);
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (this.isValidChar(typedChar) && this.currentString.length() < 20) {
            Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 0.15f, 1.0f);
            this.currentString = this.currentString + typedChar;
            this.setTextboxCensoredText(this.keycodeTextbox, this.currentString);
            this.checkCode(this.currentString);
            return true;
        }
        return super.func_231042_a_(typedChar, keyCode);
    }

    private boolean isValidChar(char c) {
        for (int i = 0; i < this.allowedChars.length; ++i) {
            if (c != this.allowedChars[i]) continue;
            return true;
        }
        return false;
    }

    protected void actionPerformed(IdButton button) {
        if (this.currentString.length() < 20 && button.id >= 0 && button.id <= 9) {
            this.currentString = this.currentString + "" + button.id;
            this.setTextboxCensoredText(this.keycodeTextbox, this.currentString);
            this.checkCode(this.currentString);
        } else if (button.id == 10 && this.currentString.length() > 0) {
            this.currentString = Utils.removeLastChar(this.currentString);
            this.setTextboxCensoredText(this.keycodeTextbox, this.currentString);
        }
    }

    private void setTextboxCensoredText(TextFieldWidget textField, String text) {
        String x = "";
        for (int i = 1; i <= text.length(); ++i) {
            x = x + "*";
        }
        textField.func_146180_a(x);
    }

    public void checkCode(String code) {
        SecurityCraft.channel.sendToServer((Object)new CheckPassword(this.tileEntity.func_174877_v().func_177958_n(), this.tileEntity.func_174877_v().func_177956_o(), this.tileEntity.func_174877_v().func_177952_p(), code));
    }
}

